/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.mrw;

import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.mrw.MRWHeaderProcessor;
import it.tidalwave.imageio.mrw.MRWMetadata;
import it.tidalwave.imageio.mrw.MRWRasterReader;
import it.tidalwave.imageio.mrw.MinoltaMakerNote;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.imageio.spi.ImageReaderSpi;

public class MRWImageReader
extends TIFFImageReaderSupport {
    private static final String CLASS = MRWImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected MRWImageReader(@Nonnull ImageReaderSpi originatingProvider, Object extension) {
        super(originatingProvider, MinoltaMakerNote.class, MRWMetadata.class);
        this.headerProcessor = new MRWHeaderProcessor();
    }

    @Nonnull
    protected Directory loadPrimaryDirectory() throws IOException {
        logger.fine("loadPrimaryDirectory() - %s", this.iis);
        this.headerProcessor.process(this.iis);
        this.iis.setBaseOffset(this.headerProcessor.getBaseOffset());
        this.iis.seek(this.headerProcessor.getOffset());
        long directoryOffset = MRWImageReader.processHeader(this.iis, this.headerProcessor);
        IFD primaryIFD = new IFD();
        primaryIFD.loadAll(this.iis, directoryOffset);
        this.iis.setBaseOffset(0L);
        return primaryIFD;
    }

    protected void processEXIFAndMakerNote(@Nonnull Directory directory) throws IOException {
        this.iis.setBaseOffset(this.headerProcessor.getBaseOffset());
        super.processEXIFAndMakerNote(directory);
        this.iis.setBaseOffset(0L);
    }

    @Nonnull
    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis: %s", this.iis);
        long time = System.currentTimeMillis();
        MRWRasterReader rasterReader = new MRWRasterReader();
        this.initializeRasterReader(rasterReader);
        MRWHeaderProcessor mrwHeaderProcessor = (MRWHeaderProcessor)this.headerProcessor;
        MinoltaRawData minoltaRawData = mrwHeaderProcessor.getMinoltaRawData();
        long rasterOffset = minoltaRawData.getRasterOffset();
        int sensorWidth = minoltaRawData.getPRD().getCcdSize().width;
        int sensorHeight = minoltaRawData.getPRD().getCcdSize().height;
        this.iis.seek(rasterOffset);
        logger.finest(">>>> rasterOffset: %d, size: %d x %d", rasterOffset, sensorWidth, sensorHeight);
        rasterReader.setWidth(sensorWidth);
        rasterReader.setHeight(sensorHeight);
        rasterReader.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int dataSize = minoltaRawData.getPRD().getDataSize();
        rasterReader.setBitsPerSample(dataSize);
        int rasterDataSize = sensorWidth * sensorHeight / dataSize;
        rasterReader.setStripByteCount(rasterDataSize);
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec.", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(@Nonnull RasterReader rasterReader) {
        IFD primaryIFD = (IFD)this.primaryDirectory;
        IFD exifIFD = (IFD)primaryIFD.getNamedDirectory("EXIF");
        rasterReader.setCFAPattern(new byte[]{0, 1, 1, 2});
        rasterReader.setCompression(primaryIFD.getCompression().intValue());
        MinoltaMakerNote minoltaMakerNote = (MinoltaMakerNote)this.makerNote;
        if (minoltaMakerNote.isRasterDataSizeAvailable()) {
            rasterReader.setStripByteCount(minoltaMakerNote.getRasterDataSize());
        }
    }
}

