/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import java.awt.image.BufferedImage;

public class WipeFilter
extends AbstractBufferedImageOp {
    public static final int WIPE = 0;
    public static final int BARN_DOORS = 1;
    public static final int SQUARES = 2;
    public static final int DIAMONDS = 3;
    public static final int DIAMOND_LATTICE = 4;
    public static final int CIRCLES = 5;
    public static final int BLOCKS = 6;
    public static final int FAN = 7;
    public static final int COMB = 8;
    private float density = 0.0f;
    private float softness = 0.0f;
    private float amountX = 1.0f;
    private float amountY = 0.0f;
    private float amountR = 0.0f;
    private float amountT = 0.0f;
    private float delayX = 0.0f;
    private float delayY = 0.0f;
    private float delayR = 0.0f;
    private boolean invert;
    private int type;
    private int repeatsX = 1;
    private int repeatsY = 1;
    private int repeatsR = 1;
    private BufferedImage mask;
    private int width;
    private int height;
    private int centreX;
    private int centreY;

    public void setDensity(float density) {
        this.density = density;
    }

    public float getDensity() {
        return this.density;
    }

    public void setSoftness(float softness) {
        this.softness = softness;
    }

    public float getSoftness() {
        return this.softness;
    }

    public void setAmountX(float amountX) {
        this.amountX = amountX;
    }

    public float getAmountX() {
        return this.amountX;
    }

    public void setAmountY(float amountY) {
        this.amountY = amountY;
    }

    public float getAmountY() {
        return this.amountY;
    }

    public void setAmountR(float amountR) {
        this.amountR = amountR;
    }

    public float getAmountR() {
        return this.amountR;
    }

    public void setAmountT(float amountT) {
        this.amountT = amountT;
    }

    public float getAmountT() {
        return this.amountT;
    }

    public void setDelayX(float delayX) {
        this.delayX = delayX;
    }

    public float getDelayX() {
        return this.delayX;
    }

    public void setDelayY(float delayY) {
        this.delayY = delayY;
    }

    public float getDelayY() {
        return this.delayY;
    }

    public void setDelayR(float delayR) {
        this.delayR = delayR;
    }

    public float getDelayR() {
        return this.delayR;
    }

    public void setMask(BufferedImage mask) {
        this.mask = mask;
    }

    public BufferedImage getMask() {
        return this.mask;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setRepeatsX(int repeatsX) {
        this.repeatsX = repeatsX;
    }

    public int getRepeatsX() {
        return this.repeatsX;
    }

    public void setRepeatsY(int repeatsY) {
        this.repeatsY = repeatsY;
    }

    public int getRepeatsY() {
        return this.repeatsY;
    }

    public void setRepeatsR(int repeatsR) {
        this.repeatsR = repeatsR;
    }

    public int getRepeatsR() {
        return this.repeatsR;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.width = src.getWidth();
        this.height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        float d = this.density * (1.0f + this.softness);
        float lower = d - this.softness;
        float upper = d;
        int[] inPixels = new int[this.width];
        this.centreX = this.width / 2;
        this.centreY = this.height / 2;
        for (int y = 0; y < this.height; ++y) {
            this.getRGB(src, 0, y, this.width, 1, inPixels);
            for (int x = 0; x < this.width; ++x) {
                int inRGB = inPixels[x];
                float f = this.valueAt(x, y);
                f = ImageMath.smoothStep(lower, upper, f);
                int a = (int)((float)(inRGB >> 24 & 0xFF) * f);
                if (this.invert) {
                    a = 255 - a;
                }
                inPixels[x] = a << 24 | inRGB & 0xFFFFFF;
            }
            this.setRGB(dst, 0, y, this.width, 1, inPixels);
        }
        return dst;
    }

    protected float valueAt(int x, int y) {
        float fx = (float)x / (float)this.width;
        float fy = (float)y / (float)this.height;
        float mx = ImageMath.mod((float)this.repeatsX * fx, 1.0f);
        float my = ImageMath.mod((float)this.repeatsY * fy, 1.0f);
        mx = this.delayX * fx + (1.0f - this.delayX) * mx;
        my = this.delayY * fy + (1.0f - this.delayY) * my;
        float dx = mx - 0.5f;
        float dy = my - 0.5f;
        float r = (float)Math.sqrt(dx * dx + dy * dy);
        float t = (float)((Math.atan2(y - this.centreY, x - this.centreX) + Math.PI) / (Math.PI * 2));
        r = this.delayR * r + (1.0f - this.delayR) * ImageMath.mod((float)this.repeatsR * r, 1.0f);
        t = this.delayR * t + (1.0f - this.delayR) * ImageMath.mod((float)this.repeatsR * t, 1.0f);
        switch (this.type) {
            case 0: {
                return my;
            }
            case 1: {
                return ImageMath.triangle(mx);
            }
            case 2: {
                return Math.max(mx, my);
            }
            case 3: {
                return Math.abs(Math.max(dx + dy, dx - dy));
            }
            case 4: {
                return Math.abs(Math.min(dx + dy, dx - dy)) * 2.0f;
            }
            case 5: {
                return r;
            }
            case 7: {
                return t;
            }
            case 8: {
                return my < 0.5f ? mx : 1.0f - mx;
            }
            case 6: {
                return (int)(fy * (float)this.repeatsY) * this.repeatsX + (int)(fx * (float)this.repeatsX) / (this.repeatsX * this.repeatsY);
            }
        }
        return dx;
    }

    public String toString() {
        return "Transitions/Wipe...";
    }
}

