/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.ReactDiffuse;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ReactDiffuseCustomizer
extends PreviewFilterCustomizer
implements ItemListener,
ChangeListener,
PropertyChangeListener {
    private JSlider speed;
    private JSlider p1;
    private JSlider p2;
    private JSlider p3;
    private JSlider iterations;
    private JCheckBox spots;
    private ReactDiffuse filter;
    private Gradient gradient;

    public ReactDiffuseCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        this.spots = new JCheckBox("Spots");
        p.add(this.spots);
        p.add(new JLabel(""));
        p.add(new JLabel("Speed:", 4));
        this.speed = new JSlider(0, 0, 200, 100);
        p.add(this.speed);
        this.speed.setPaintTicks(true);
        this.speed.setMajorTickSpacing(100);
        this.speed.setMinorTickSpacing(20);
        this.speed.setPaintLabels(true);
        p.add(new JLabel("P1:", 4));
        this.p1 = new JSlider(0, 0, 100, 0);
        p.add(this.p1);
        this.p1.setPaintTicks(true);
        this.p1.setMajorTickSpacing(50);
        this.p1.setMinorTickSpacing(10);
        this.p1.setPaintLabels(true);
        p.add(new JLabel("P2:", 4));
        this.p2 = new JSlider(0, 0, 100, 0);
        p.add(this.p2);
        this.p2.setPaintTicks(true);
        this.p2.setMajorTickSpacing(50);
        this.p2.setMinorTickSpacing(10);
        this.p2.setPaintLabels(true);
        p.add(new JLabel("P3:", 4));
        this.p3 = new JSlider(0, 0, 100, 0);
        p.add(this.p3);
        this.p3.setPaintTicks(true);
        this.p3.setMajorTickSpacing(50);
        this.p3.setMinorTickSpacing(10);
        this.p3.setPaintLabels(true);
        p.add(new JLabel("Iterations:", 4));
        this.iterations = new JSlider(0, 0, 1000, 0);
        p.add(this.iterations);
        this.iterations.setPaintTicks(true);
        this.iterations.setMajorTickSpacing(500);
        this.iterations.setMinorTickSpacing(200);
        this.iterations.setPaintLabels(true);
        this.spots.addItemListener(this);
        this.speed.addChangeListener(this);
        this.p1.addChangeListener(this);
        this.p2.addChangeListener(this);
        this.p3.addChangeListener(this);
        this.iterations.addChangeListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        ReactDiffuse filter = (ReactDiffuse)o;
        this.spots.setSelected(filter.spots);
        this.speed.setValue((int)(filter.getSpeed() * 100.0f));
        this.p1.setValue((int)(filter.p1 * 100.0f));
        this.p2.setValue((int)(filter.p2 * 100.0f));
        this.p3.setValue((int)(filter.p3 * 100.0f));
        this.iterations.setValue(filter.iterations);
        this.filter = filter;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.filter != null) {
            this.filter.spots = this.spots.isSelected();
            this.preview();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.speed) {
                this.filter.setSpeed((float)this.speed.getValue() / 200.0f);
            } else if (source == this.p1) {
                this.filter.p1 = (float)this.p1.getValue() / 100.0f;
            } else if (source == this.p2) {
                this.filter.p2 = (float)this.p2.getValue() / 100.0f;
            } else if (source == this.p3) {
                this.filter.p3 = (float)this.p3.getValue() / 100.0f;
            } else if (source == this.iterations) {
                this.filter.iterations = this.iterations.getValue();
            }
            this.preview();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("colormap".equals(event.getPropertyName())) {
            Object source = event.getSource();
            this.filter.setColormap((Colormap)event.getNewValue());
            this.preview();
        }
    }
}

