/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;

class ImageSample
extends JComponent {
    private Image backgroundImage;
    private Image image;

    public ImageSample() {
        this.setDoubleBuffered(true);
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            if (PreviewFilterCustomizer.previewWholeImage) {
                return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            }
            return new Dimension(Math.min(256, this.image.getWidth(this)), Math.min(128, this.image.getHeight(this)));
        }
        return new Dimension(256, 128);
    }

    public void paint(Graphics g) {
        int y;
        Dimension size = this.getSize();
        if (this.backgroundImage != null) {
            Rectangle r;
            if (this.image != null) {
                int x = (size.width - this.image.getWidth(this)) / 2;
                y = (size.height - this.image.getHeight(this)) / 2;
                g.clipRect(x, y, this.image.getWidth(this), this.image.getHeight(this));
            }
            if ((r = g.getClipBounds()) == null) {
                r = new Rectangle(this.getSize());
            }
            int w = this.backgroundImage.getWidth(this);
            int h = this.backgroundImage.getHeight(this);
            if (w != -1 && h != -1) {
                int x1 = r.x / w * w;
                int y1 = r.y / h * h;
                int x2 = (r.x + r.width + w - 1) / w * w;
                int y2 = (r.y + r.height + h - 1) / h * h;
                for (int y3 = y1; y3 < y2; y3 += h) {
                    for (int x = x1; x < x2; x += w) {
                        g.drawImage(this.backgroundImage, x, y3, this);
                    }
                }
            }
        } else {
            ImageUtils.paintCheckedBackground(this, g, 0, 0, size.width, size.height);
        }
        if (this.image != null) {
            int x = (size.width - this.image.getWidth(this)) / 2;
            y = (size.height - this.image.getHeight(this)) / 2;
            g.drawImage(this.image, x, y, this);
        }
    }
}

