/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.CompositionApplication;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class GeneralPanel
extends JPanel
implements ItemListener {
    private CompositionApplication application;
    private JComboBox ui;
    private UIManager.LookAndFeelInfo[] lookAndFeelInfo;
    private Preferences preferences = Preferences.userNodeForPackage(this.getClass());

    public GeneralPanel(CompositionApplication application) {
        this.application = application;
        this.setLayout(new SuperGridLayout(2, 2, 10, 10, 10, 10));
        this.add(new JLabel("Look and Feel:"));
        this.ui = new JComboBox();
        this.add(this.ui);
        this.lookAndFeelInfo = UIManager.getInstalledLookAndFeels();
        int current = 0;
        String currentLaf = UIManager.getLookAndFeel().getClass().getName();
        for (int i = 0; i < this.lookAndFeelInfo.length; ++i) {
            this.ui.addItem(this.lookAndFeelInfo[i].getName());
            if (!this.lookAndFeelInfo[i].getClassName().equals(currentLaf)) continue;
            current = i;
        }
        this.ui.setSelectedIndex(current);
        this.ui.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.ui) {
            int index = this.ui.getSelectedIndex();
            try {
                String osName = System.getProperty("os.name");
                if (this.lookAndFeelInfo[index].getClassName().indexOf("Windows") != -1) {
                    System.getProperties().put("os.name", "Windows");
                } else if (this.lookAndFeelInfo[index].getClassName().indexOf("Mac") != -1) {
                    System.getProperties().put("os.name", "Mac OS");
                }
                UIManager.setLookAndFeel(this.lookAndFeelInfo[index].getClassName());
                SwingUtilities.updateComponentTreeUI(this.application.getFrame());
                System.getProperties().put("os.name", osName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void getPreferences() {
    }

    public void setPreferences() {
        int index = this.ui.getSelectedIndex();
        if (index != -1) {
            this.preferences.put("lookAndFeel", this.lookAndFeelInfo[index].getClassName());
        }
    }
}

