/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionView;
import com.jhlabs.ie.GrabHandle;
import com.jhlabs.ie.ImageTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.FilterCustomizer;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.WarpFilter;
import com.jhlabs.image.WarpGrid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.BitSet;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WarpTool
extends ImageTool
implements ActionListener {
    private static final int SOURCE = 0;
    private static final int DEST = 1;
    private WarpGrid[] grids = new WarpGrid[2];
    private BitSet[] selection = new BitSet[2];
    private WarpGrid dragGrid;
    private int dragRow = -1;
    private int dragCol = -1;
    private int dragX = -1;
    private int dragY = -1;
    private boolean dragBoth;
    private boolean[] showGrid = new boolean[2];
    private WarpFilter filter = new WarpFilter();
    private JPopupMenu menu = new JPopupMenu("Grid");
    private JMenuItem addRowItem = new JMenuItem("Add Row");
    private JMenuItem addColItem;
    private JMenuItem removeRowItem;
    private JMenuItem removeColItem;
    private Rectangle bounds;

    public WarpTool() {
        this.menu.add(this.addRowItem);
        this.addColItem = new JMenuItem("Add Column");
        this.menu.add(this.addColItem);
        this.removeRowItem = new JMenuItem("Remove Row");
        this.menu.add(this.removeRowItem);
        this.removeColItem = new JMenuItem("Remove Column");
        this.menu.add(this.removeColItem);
        this.addRowItem.addActionListener(this);
        this.addColItem.addActionListener(this);
        this.removeRowItem.addActionListener(this);
        this.removeColItem.addActionListener(this);
        this.showGrid[0] = false;
        this.showGrid[1] = true;
    }

    public boolean usesFloatingSelection() {
        return true;
    }

    public boolean doStartDrag() {
        int x = this.view.XTox(this.currX);
        int y = this.view.YToy(this.currY);
        this.dragBoth = this.event.isMetaDown();
        if (this.showGrid[1] && this.checkHit(1, x, y)) {
            if (this.event.isPopupTrigger()) {
                return this.showPopup();
            }
            return true;
        }
        if (this.showGrid[0] && this.checkHit(0, x, y)) {
            if (this.event.isPopupTrigger()) {
                return this.showPopup();
            }
            return true;
        }
        if (this.event.isPopupTrigger()) {
            return this.showPopup();
        }
        if (!this.event.isShiftDown()) {
            this.selection[0].clear();
            this.selection[1].clear();
        }
        this.view.repaint();
        return true;
    }

    private boolean checkHit(int which, int x, int y) {
        int xoffset = this.bounds.x;
        int yoffset = this.bounds.y;
        WarpGrid warpGrid = this.grids[which];
        Composition composition = this.getComposition();
        this.dragGrid = null;
        for (int row = 1; row < warpGrid.rows - 1; ++row) {
            int index = row * warpGrid.cols + 1;
            for (int col = 1; col < warpGrid.cols - 1; ++col) {
                int wx = xoffset + (int)warpGrid.xGrid[index];
                int wy = yoffset + (int)warpGrid.yGrid[index];
                if (GrabHandle.inHandle(x, y, wx, wy)) {
                    this.dragGrid = warpGrid;
                    this.dragX = x;
                    this.dragY = y;
                    this.dragRow = row;
                    this.dragCol = col;
                    if (!this.selection[which].get(index) && !this.event.isShiftDown()) {
                        this.selection[0].clear();
                        this.selection[1].clear();
                    }
                    this.selection[which].set(index);
                    if (this.dragBoth) {
                        this.selection[1 - which].set(index);
                    }
                    if (composition.getFloatingLayer() == null) {
                        CompositionDocument document = this.view.getDocument();
                        WarpTask task = new WarpTask(composition);
                        document.setPendingTask(task);
                        task.saveArea(composition.getActiveLayer().getBounds());
                        composition.floatSelection(this.event.isControlDown());
                        composition.setPreviewFilter(composition.getFloatingLayer(), this.filter, 0.0f, 0.0f);
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public void doDrag(boolean erase) {
        int y;
        int x;
        Composition composition = this.getComposition();
        Layer layer = composition.getActiveLayer();
        if (!erase && this.dragGrid != null) {
            x = this.view.XTox(this.currX);
            y = this.view.YToy(this.currY);
            BufferedImage image = layer.getImage();
            x = ImageMath.clamp(x, 0, image.getWidth());
            y = ImageMath.clamp(y, 0, image.getHeight());
            int lx = this.view.XTox(this.lastX);
            int ly = this.view.YToy(this.lastY);
            for (int i = 0; i <= 1; ++i) {
                int index = 0;
                WarpGrid grid = this.grids[i];
                for (int row = 0; row < grid.rows; ++row) {
                    for (int col = 0; col < grid.cols; ++col) {
                        if (this.selection[i].get(index)) {
                            if (col != 0 && col != grid.cols - 1) {
                                int n = index;
                                grid.xGrid[n] = grid.xGrid[n] + (float)(x - lx);
                            }
                            if (row != 0 && row != grid.rows - 1) {
                                int n = index;
                                grid.yGrid[n] = grid.yGrid[n] + (float)(y - ly);
                            }
                        }
                        ++index;
                    }
                }
            }
            this.view.repaint();
        }
        if (this.dragGrid == null) {
            x = Math.min(this.startX, this.currX);
            y = Math.min(this.startY, this.currY);
            int w = Math.abs(this.startX - this.currX);
            int h = Math.abs(this.startY - this.currY);
            this.graphics.drawRect(x, y, w, h);
        }
    }

    public void doEndDrag() {
        if (this.event.isPopupTrigger()) {
            this.showPopup();
        }
        if (this.dragGrid != null) {
            Composition composition = this.getComposition();
            this.filter.setSourceGrid(this.grids[0]);
            this.filter.setDestGrid(this.grids[1]);
            composition.setPreviewFilter(composition.getFloatingLayer(), this.filter, 0.0f, 0.0f);
            composition.startUpdate();
            composition.updateAll();
            composition.endUpdate();
            this.view.repaint();
        } else {
            Rectangle r = this.getRectangle();
            for (int i = 0; i <= 1; ++i) {
                boolean show = this.showGrid[i];
                int index = 0;
                for (int row = 0; row < this.grids[i].rows; ++row) {
                    for (int col = 0; col < this.grids[i].cols; ++col) {
                        float gx = this.grids[i].xGrid[index];
                        float gy = this.grids[i].yGrid[index];
                        if (show && r.contains((int)gx, (int)gy)) {
                            this.selection[i].set(index);
                        }
                        ++index;
                    }
                }
            }
            this.view.repaint();
        }
    }

    private boolean showPopup() {
        boolean b = this.dragGrid != null;
        this.view.add(this.menu);
        this.addRowItem.setEnabled(b && this.dragRow != 0);
        this.addColItem.setEnabled(b && this.dragRow != 0);
        this.removeRowItem.setEnabled(b && this.dragRow != 0 && this.dragRow != this.dragGrid.rows - 1);
        this.removeColItem.setEnabled(b && this.dragCol != 0 && this.dragCol != this.dragGrid.cols - 1);
        this.menu.show(this.view, this.event.getX(), this.event.getY());
        this.view.remove(this.menu);
        return false;
    }

    public void setView(CompositionView view) {
        super.setView(view);
        Composition composition = this.getComposition();
        if (view != null && composition.getFloatingLayer() == null) {
            this.bounds = composition.getSelectedBounds();
            if (this.bounds == null) {
                this.bounds = composition.getBounds();
            }
            if (this.bounds != null) {
                this.grids[0] = new WarpGrid(7, 7, this.bounds.width, this.bounds.height);
                this.grids[1] = new WarpGrid(7, 7, this.bounds.width, this.bounds.height);
                this.resetSelection();
            }
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.view != null && !active) {
            CompositionDocument document = this.view.getDocument();
            Composition composition = this.getComposition();
            if (composition != null) {
                composition.dropFloatingSelection();
            }
            if (document != null) {
                document.performPendingTask();
            }
            if (composition != null) {
                composition.setPreviewFilter(null, null, 0.0f, 0.0f);
            }
        }
    }

    public void paint(Graphics2D g) {
        if (this.showGrid[0]) {
            g.setColor(Color.red);
            this.paintGrid(g, this.grids[0], this.selection[0]);
        }
        if (this.showGrid[1]) {
            g.setColor(Color.green);
            this.paintGrid(g, this.grids[1], this.selection[1]);
        }
    }

    private void paintGrid(Graphics2D g, WarpGrid warpGrid, BitSet selection) {
        Composition composition = this.getComposition();
        int xoffset = this.bounds.x;
        int yoffset = this.bounds.y;
        int index = 0;
        for (int row = 0; row < warpGrid.rows; ++row) {
            for (int col = 0; col < warpGrid.cols; ++col) {
                int x = this.view.xToX(xoffset + (int)warpGrid.xGrid[index]);
                int y = this.view.yToY(yoffset + (int)warpGrid.yGrid[index]);
                if (row > 0) {
                    g.drawLine(x, y, this.view.xToX(xoffset + (int)warpGrid.xGrid[index - warpGrid.cols]), this.view.yToY(yoffset + (int)warpGrid.yGrid[index - warpGrid.cols]));
                }
                if (col > 0) {
                    g.drawLine(x, y, this.view.xToX(xoffset + (int)warpGrid.xGrid[index - 1]), this.view.yToY(yoffset + (int)warpGrid.yGrid[index - 1]));
                }
                if (row != 0 && col != 0 && row != warpGrid.rows - 1 && col != warpGrid.cols - 1) {
                    if (selection.get(row * warpGrid.cols + col)) {
                        g.fillRect(x - 4, y - 4, 8, 8);
                    } else {
                        g.fillRect(x - 2, y - 2, 4, 4);
                    }
                }
                ++index;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addRowItem) {
            this.addRow();
        } else if (source == this.addColItem) {
            this.addCol();
        } else if (source == this.removeRowItem) {
            this.removeRow();
        } else if (source == this.removeColItem) {
            this.removeCol();
        }
        this.view.repaint();
    }

    private void addRow() {
        this.grids[0].addRow(this.dragRow);
        this.grids[1].addRow(this.dragRow);
        this.resetSelection();
    }

    private void addCol() {
        this.grids[0].addCol(this.dragCol);
        this.grids[1].addCol(this.dragCol);
        this.resetSelection();
    }

    private void removeRow() {
        if (this.grids[0].rows > 2) {
            this.grids[0].removeRow(this.dragRow);
            this.grids[1].removeRow(this.dragRow);
            this.resetSelection();
        }
    }

    private void removeCol() {
        if (this.grids[0].cols > 2) {
            this.grids[0].removeCol(this.dragCol);
            this.grids[1].removeCol(this.dragCol);
            this.resetSelection();
        }
    }

    private void resetSelection() {
        this.selection[0] = new BitSet(this.grids[0].rows * this.grids[0].cols);
        this.selection[1] = new BitSet(this.grids[1].rows * this.grids[1].cols);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new WarpToolCustomizer();
    }

    public String getToolTipText() {
        return "Warp Tool";
    }

    public String getHelpText() {
        return "Warp Tool";
    }

    class WarpToolCustomizer
    extends FilterCustomizer
    implements ChangeListener {
        private WarpTool tool;
        private JCheckBox showSourceCheck;
        private JCheckBox showDestCheck;
        private JSlider timeSlider;

        public WarpToolCustomizer() {
            this.setLayout(new SuperGridLayout(1, 0));
            this.showSourceCheck = new JCheckBox("Show Source");
            this.add(this.showSourceCheck);
            this.showSourceCheck.addChangeListener(this);
            this.showDestCheck = new JCheckBox("Show Destination");
            this.add(this.showDestCheck);
            this.showDestCheck.addChangeListener(this);
        }

        public void setObject(Object o) {
            this.tool = (WarpTool)o;
            this.showSourceCheck.setSelected(this.tool.showGrid[0]);
            this.showDestCheck.setSelected(this.tool.showGrid[1]);
        }

        public void stateChanged(ChangeEvent e) {
            if (this.tool != null) {
                Object source = e.getSource();
                if (source == this.showSourceCheck) {
                    ((WarpTool)this.tool).showGrid[0] = this.showSourceCheck.isSelected();
                } else if (source == this.showDestCheck) {
                    ((WarpTool)this.tool).showGrid[1] = this.showDestCheck.isSelected();
                } else if (source == this.timeSlider) {
                    WarpTool.this.filter.setTime((float)this.timeSlider.getValue() / 100.0f);
                    Composition composition = WarpTool.this.getComposition();
                    composition.startUpdate();
                    composition.updateAll();
                    composition.endUpdate();
                }
                WarpTool.this.view.repaint();
            }
        }
    }

    class WarpTask
    extends ImageTask {
        public WarpTask(Composition composition) {
            super(composition);
        }

        public void doTask() {
            Composition composition = this.getComposition();
            super.doTask();
            composition.simplifyActiveLayer();
            composition.startUpdate();
            composition.dropFloatingSelection();
            composition.endUpdate();
        }

        public String getPresentationName() {
            return "Warp";
        }
    }
}

