/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.CompositionView;
import com.jhlabs.ie.GrabHandle;
import com.jhlabs.ie.ImageTask;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PerspectiveFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class PerspectiveTool
extends ImageTool {
    private float xOrigin;
    private float yOrigin;
    private float[] xPoints = new float[4];
    private float[] yPoints = new float[4];
    private int handle = -1;
    private PerspectiveFilter filter = new PerspectiveFilter();

    public boolean usesFloatingSelection() {
        return true;
    }

    public boolean doStartDrag() {
        int x = this.view.XTox(this.currX);
        int y = this.view.YToy(this.currY);
        this.handle = -1;
        this.handle = 5;
        for (int i = 0; i < 4; ++i) {
            if (!GrabHandle.inHandle(x, y, (int)this.xPoints[i], (int)this.yPoints[i])) continue;
            this.handle = i;
            break;
        }
        if (this.handle != -1) {
            Composition composition = this.getComposition();
            if (composition.getFloatingLayer() == null) {
                CompositionDocument document = this.view.getDocument();
                ImageTask task = new ImageTask(composition);
                document.setPendingTask(task);
                task.saveArea(composition.getActiveLayer().getBounds());
                composition.floatSelection(this.event.isControlDown());
                composition.setPreviewFilter(composition.getFloatingLayer(), this.filter, 0.0f, 0.0f);
            }
            return true;
        }
        return false;
    }

    public void doDrag(boolean erase) {
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        if (!erase && this.handle != -1) {
            int x = this.view.XTox(this.currX);
            int y = this.view.YToy(this.currY);
            if (this.handle == 5) {
                int i = 0;
                while (i < 4) {
                    int n = i;
                    this.xPoints[n] = this.xPoints[n] + (float)(x - this.view.XTox(this.lastX));
                    int n2 = i++;
                    this.yPoints[n2] = this.yPoints[n2] + (float)(y - this.view.YToy(this.lastY));
                }
            } else {
                this.xPoints[this.handle] = x;
                this.yPoints[this.handle] = y;
            }
        }
        this.paint(this.graphics);
    }

    public void doEndDrag() {
        Composition composition = this.getComposition();
        this.filter.setCorners(this.xPoints[0] - this.xOrigin, this.yPoints[0] - this.yOrigin, this.xPoints[1] - this.xOrigin, this.yPoints[1] - this.yOrigin, this.xPoints[2] - this.xOrigin, this.yPoints[2] - this.yOrigin, this.xPoints[3] - this.xOrigin, this.yPoints[3] - this.yOrigin);
        composition.setPreviewFilter(composition.getFloatingLayer(), this.filter, this.xPoints[0] - this.xOrigin - this.filter.getOriginX(), this.yPoints[0] - this.yOrigin - this.filter.getOriginY());
        composition.startUpdate();
        composition.updateAll();
        composition.endUpdate();
        this.view.repaint();
    }

    public void setView(CompositionView view) {
        super.setView(view);
        Composition composition = this.getComposition();
        if (view != null && composition.getFloatingLayer() == null && composition.getActiveLayer() != null) {
            Rectangle r = composition.getSelectedBounds();
            if (r == null) {
                r = ImageUtils.getSelectedBounds(composition.getActiveLayer().getImage());
            }
            if (r != null) {
                this.xOrigin = r.x;
                this.yOrigin = r.y;
                this.xPoints[0] = this.xPoints[3] = (float)r.x;
                this.yPoints[0] = this.yPoints[1] = (float)r.y;
                this.xPoints[1] = this.xPoints[2] = (float)(r.x + r.width);
                this.yPoints[2] = this.yPoints[3] = (float)(r.y + r.height);
            }
        }
    }

    public void paint(Graphics2D g) {
        int y;
        int x;
        int i;
        Composition composition = this.getComposition();
        g.setColor(Color.white);
        GeneralPath p = new GeneralPath();
        for (i = 0; i < 4; ++i) {
            x = this.view.xToX((int)this.xPoints[i]);
            y = this.view.yToY((int)this.yPoints[i]);
            if (i == 0) {
                p.moveTo(x, y);
                continue;
            }
            p.lineTo(x, y);
        }
        p.closePath();
        g.draw(p);
        for (i = 0; i < 4; ++i) {
            x = this.view.xToX((int)this.xPoints[i]);
            y = this.view.yToY((int)this.yPoints[i]);
            GrabHandle.drawHandle(x, y, g);
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (!active && this.view != null) {
            CompositionDocument document = this.view.getDocument();
            Composition composition = this.getComposition();
            if (composition != null) {
                composition.dropFloatingSelection();
            }
            if (document != null) {
                document.performPendingTask();
            }
            if (composition != null) {
                composition.setPreviewFilter(null, null, 0.0f, 0.0f);
            }
        }
    }

    public String getToolTipText() {
        return "Perspective Transform Tool";
    }

    public String getHelpText() {
        return "Perspective Transform Tool";
    }
}

