/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.beans.AbstractPropertyEditor;
import com.jhlabs.beans.AnglePropertyEditor;
import com.jhlabs.beans.BeanUtils;
import com.jhlabs.beans.Point2DPropertyEditor;
import com.jhlabs.beans.RadiusPropertyEditor;
import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionView;
import com.jhlabs.ie.GrabHandle;
import com.jhlabs.ie.ImageTool;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ImageMath;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;

public class FilterTool
extends ImageTool {
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;
    private Object filter;
    private Vector tools = new Vector();
    private Handle dragTool;
    private Rectangle bounds;

    public void addProperty(Object filter, AbstractPropertyEditor p) {
        this.filter = filter;
        try {
            Handle handle = new Handle();
            handle.type = -1;
            if (p instanceof Point2DPropertyEditor) {
                handle.type = 0;
            } else if (p instanceof RadiusPropertyEditor) {
                handle.type = 1;
            } else if (p instanceof AnglePropertyEditor) {
                handle.type = 2;
            }
            if (handle.type != -1) {
                handle.property = BeanUtils.getPropertyDescriptor(filter, p.getProperty());
                handle.centreProperty = BeanUtils.getPropertyDescriptor(filter, p.getCentreProperty());
                handle.getValues(filter);
                this.tools.add(handle);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void update() {
        Iterator it = this.tools.iterator();
        while (it.hasNext()) {
            Handle handle = (Handle)it.next();
            handle.getValues(this.filter);
        }
    }

    public boolean doStartDrag() {
        int xoffset = this.bounds.x;
        int yoffset = this.bounds.y;
        Composition composition = this.getComposition();
        this.dragTool = null;
        Iterator it = this.tools.iterator();
        while (it.hasNext()) {
            Handle tool = (Handle)it.next();
            int x = xoffset + (int)(tool.centreValue.x * (float)this.bounds.width);
            int y = yoffset + (int)(tool.centreValue.y * (float)this.bounds.height);
            int vx = this.view.xToX(x);
            int vy = this.view.yToY(y);
            float dx = this.currX - vx;
            float dy = this.currY - vy;
            float d2 = dx * dx + dy * dy;
            float r = tool.value;
            switch (tool.type) {
                case 0: {
                    if (!GrabHandle.inHandle(this.currX, this.currY, vx, vy)) break;
                    this.dragTool = tool;
                    break;
                }
                case 1: {
                    r = this.view.xToX((int)((float)x + r)) - vx;
                    if (!(Math.abs(Math.sqrt(d2) - (double)r) < 5.0)) break;
                    this.dragTool = tool;
                    break;
                }
                case 2: {
                    if (!GrabHandle.inHandle(this.currX, this.currY, vx + (int)(100.0 * Math.cos(r)), vy - (int)(100.0 * Math.sin(r)))) break;
                    this.dragTool = tool;
                }
            }
        }
        return this.dragTool != null;
    }

    public void doDrag(boolean erase) {
        int xoffset = this.bounds.x;
        int yoffset = this.bounds.y;
        Composition composition = this.getComposition();
        Layer layer = composition.getFloatingLayer();
        if (!erase) {
            int mx = this.view.XTox(this.currX);
            int my = this.view.YToy(this.currY);
            if (this.dragTool != null) {
                Handle tool = this.dragTool;
                int x = xoffset + (int)(tool.centreValue.x * (float)this.bounds.width);
                int y = yoffset + (int)(tool.centreValue.y * (float)this.bounds.height);
                float dx = mx - x;
                float dy = my - y;
                switch (tool.type) {
                    case 0: {
                        tool.centreValue.x = (float)(mx - xoffset) / (float)this.bounds.width;
                        tool.centreValue.y = (float)(my - yoffset) / (float)this.bounds.height;
                        break;
                    }
                    case 1: {
                        tool.value = (float)Math.sqrt(dx * dx + dy * dy);
                        break;
                    }
                    case 2: {
                        float newAngle = (float)Math.atan2(-dy, dx);
                        if (this.event.isShiftDown()) {
                            newAngle = 24.0f * newAngle / ((float)Math.PI * 2);
                            newAngle = Math.round(newAngle);
                            newAngle = (float)Math.PI * 2 * newAngle / 24.0f;
                        }
                        if (newAngle < 0.0f) {
                            newAngle += (float)Math.PI * 2;
                        }
                        int turns = (int)Math.floor(tool.value / ((float)Math.PI * 2));
                        float last = ImageMath.mod(tool.value, (float)Math.PI * 2);
                        if (dx > 0.0f && Math.abs(newAngle - last) > (float)Math.PI) {
                            newAngle = newAngle < (float)Math.PI ? (newAngle += (float)Math.PI * 2) : (newAngle -= (float)Math.PI * 2);
                        }
                        tool.value = newAngle += (float)turns * ((float)Math.PI * 2);
                    }
                }
            }
        }
        if (this.dragTool != null) {
            this.dragTool.setValues(this.filter);
            this.update();
        }
        this.paint(this.graphics);
    }

    public void doEndDrag() {
        Composition composition = this.getComposition();
        if (this.dragTool != null) {
            this.dragTool.setValues(this.filter);
            this.update();
        }
        composition.startUpdate();
        composition.updateAll();
        composition.endUpdate();
        this.view.repaint();
    }

    public void setView(CompositionView view) {
        super.setView(view);
        Composition composition = this.getComposition();
        if (view != null) {
            this.bounds = composition.getSelectedBounds();
            if (this.bounds == null) {
                this.bounds = composition.getActiveLayer().getBounds();
            }
        }
    }

    public void paint(Graphics2D g) {
        if (this.bounds == null) {
            return;
        }
        int xoffset = this.bounds.x;
        int yoffset = this.bounds.y;
        Composition composition = this.getComposition();
        Iterator it = this.tools.iterator();
        while (it.hasNext()) {
            Handle tool = (Handle)it.next();
            int x = xoffset + (int)(tool.centreValue.x * (float)this.bounds.width);
            int y = yoffset + (int)(tool.centreValue.y * (float)this.bounds.height);
            int vx = this.view.xToX(x);
            int vy = this.view.yToY(y);
            float r = tool.value;
            switch (tool.type) {
                case 0: {
                    GrabHandle.drawHandle(vx, vy, g, 0, false);
                    break;
                }
                case 1: {
                    r = this.view.xToX((int)((float)x + r)) - vx;
                    g.drawOval((int)((float)vx - r), (int)((float)vy - r), (int)(r * 2.0f), (int)(r * 2.0f));
                    break;
                }
                case 2: {
                    int hx = vx + (int)(100.0 * Math.cos(r));
                    int hy = vy - (int)(100.0 * Math.sin(r));
                    g.drawLine(vx, vy, hx, hy);
                    GrabHandle.drawHandle(hx, hy, g, 0, false);
                }
            }
        }
    }

    public String getToolTipText() {
        return "Position Tool";
    }

    public String getHelpText() {
        return "Position Tool";
    }

    static class Handle {
        public static final int NONE = -1;
        public static final int POSITION = 0;
        public static final int RADIUS = 1;
        public static final int ANGLE = 2;
        int type;
        PropertyDescriptor property;
        PropertyDescriptor centreProperty;
        float value;
        Point2D.Float centreValue;

        Handle() {
        }

        public void getValues(Object object) {
            try {
                Method method = this.property.getReadMethod();
                Object result = method.invoke(object, new Object[0]);
                this.value = this.type != 0 ? ((Float)result).floatValue() : 0.0f;
                method = this.centreProperty.getReadMethod();
                result = method.invoke(object, new Object[0]);
                this.centreValue = (Point2D.Float)result;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void setValues(Object object) {
            try {
                Method method = this.property.getWriteMethod();
                if (this.type == 0) {
                    method.invoke(object, new Point2D.Float(this.centreValue.x, this.centreValue.y));
                } else {
                    method.invoke(object, new Float(this.value));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

