/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.layer;

import com.jhlabs.ie.layer.Layer;
import com.jhlabs.util.Memento;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;

public class ImageLayer
extends Layer {
    public ImageLayer(BufferedImage image) {
        super(image);
    }

    public ImageLayer(String name, BufferedImage image) {
        super(name, image);
    }

    public boolean isPaintable() {
        return true;
    }

    public void resize(int width, int height, BufferedImageOp scaleFilter) {
        this.image = scaleFilter.filter(this.image, null);
    }

    public Layer simplify() {
        return this;
    }

    public Graphics2D getGraphics() {
        Graphics2D g = this.getImage().createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g;
    }

    public Memento getLayerContentsMemento() {
        return new LayerContentsMemento();
    }

    public class LayerContentsMemento
    implements Memento {
        private BufferedImage image;

        public LayerContentsMemento() {
            this.image = ImageLayer.this.getImage();
        }

        public void restore() {
            BufferedImage t = this.image;
            this.image = ImageLayer.this.getImage();
            ImageLayer.this.setImage(t);
        }
    }
}

