/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.carbon;

import com.apple.mrj.macos.carbon.EventLoopTimerClosureUPP;
import com.apple.mrj.macos.carbon.EventLoopTimerInterface;
import com.apple.mrj.macos.carbon.HIToolBoxFunctions;

public class Timer
implements Runnable,
EventLoopTimerInterface {
    private static final boolean DEBUG = false;
    private EventLoopTimerClosureUPP fProc;
    private int fRef;
    private double fInterval;
    private Runnable fTarget;

    public Timer(double d, Runnable runnable) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative Timer interval " + d);
        }
        this.fProc = new EventLoopTimerClosureUPP(this);
        this.fInterval = d;
        this.setTarget(runnable);
    }

    public static void startOneShot(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException();
        }
        class Deferrer
        extends Timer {
            private final /* synthetic */ Runnable val$target;

            Deferrer(Runnable runnable) {
                super(0.0, null);
                this.val$target = runnable;
            }

            public void run() {
                this.val$target.run();
                this.stop();
                this.dispose();
            }
        }
        Deferrer deferrer = new Deferrer(runnable);
        deferrer.start(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startOneShotAndBlock(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException();
        }
        Object object = new Object();
        class Deferrer
        extends Timer {
            private final /* synthetic */ Runnable val$target;
            private final /* synthetic */ Object val$sync;

            Deferrer(Runnable runnable, Object object) {
                super(0.0, null);
                this.val$target = runnable;
                this.val$sync = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                try {
                    this.val$target.run();
                    Object var2_1 = null;
                    object = this.val$sync;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    Object object2 = this.val$sync;
                    synchronized (object2) {
                        this.val$sync.notify();
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.val$sync.notify();
                }
            }
        }
        Deferrer deferrer = new Deferrer(runnable, object);
        Object object2 = object;
        synchronized (object2) {
            deferrer.start(0.0);
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            deferrer.stop();
            deferrer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.fProc != null) {
            this.stop();
            this.fProc.dispose();
            this.fProc = null;
        }
    }

    public void finalize() {
        this.dispose();
    }

    public void setTarget(Runnable runnable) {
        this.fTarget = runnable != null ? runnable : this;
    }

    public Runnable getTarget() {
        return this.fTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(double d) {
        int[] nArray = new int[1];
        if (this.fRef != 0) {
            HIToolBoxFunctions.SetEventLoopTimerNextFireTime(this.fRef, d);
        } else {
            int n = HIToolBoxFunctions.InstallEventLoopTimer(HIToolBoxFunctions.GetMainEventLoop(), d, this.fInterval, this.fProc.getClosure(), 0, nArray);
            this.fRef = nArray[0];
            if (this.fRef == 0) {
                throw new Error("Couldn't start Timer -- InstallEventLoopTimer failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.fRef != 0) {
            HIToolBoxFunctions.RemoveEventLoopTimer(this.fRef);
            this.fRef = 0;
        }
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EventLoopTimer(int n, int n2) {
        try {
            this.fTarget.run();
        }
        catch (Throwable throwable) {
            System.err.println("A Buckyball Timer threw an exception:");
            throwable.printStackTrace();
        }
    }
}

