/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class QuaquaSplitPaneDivider
extends BasicSplitPaneDivider {
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    protected static final int ONE_TOUCH_SIZE_ = 4;
    protected static final int ONE_TOUCH_OFFSET_ = 2;

    public QuaquaSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new QuaquaDividerLayout());
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = newUI;
        if (newUI != null) {
            this.splitPane = newUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new QuaquaMouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    public void paint(Graphics g) {
        boolean drawDimple;
        Icon dimple;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        boolean isHorizontal = this.splitPane.getOrientation() == 1;
        String style = (String)this.splitPane.getClientProperty("Quaqua.SplitPane.style");
        if (style == null) {
            style = "thumb";
        }
        if (style.equals("bar")) {
            Border border = UIManager.getBorder(isHorizontal ? "SplitPane.vBar" : "SplitPane.hBar");
            border.paintBorder(this.splitPane, g, insets.left, insets.top, size.width - insets.right - insets.left, size.height - insets.top - insets.bottom);
        }
        if (style.equals("thumb")) {
            dimple = UIManager.getIcon("SplitPane.thumbDimple");
            drawDimple = true;
        } else {
            dimple = UIManager.getIcon("SplitPane.barDimple");
            boolean bl = drawDimple = size.width >= dimple.getIconWidth() && size.height >= dimple.getIconHeight();
        }
        if (drawDimple) {
            int x = (size.width - dimple.getIconWidth()) / 2;
            int y = (size.height - dimple.getIconHeight()) / 2;
            if (this.splitPane.isOneTouchExpandable()) {
                if (isHorizontal) {
                    y = Math.min(y, this.leftButton.getY() - dimple.getIconHeight() - 2);
                } else {
                    x = Math.min(x, this.leftButton.getX() - dimple.getIconWidth() - 2);
                }
            }
            dimple.paintIcon(this.splitPane, g, x, y);
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            public Icon getIcon() {
                return UIManager.getIcon(QuaquaSplitPaneDivider.this.splitPane.getOrientation() == 1 ? "SplitPane.leftArrow" : "SplitPane.upArrow");
            }
        };
        b.setBorder(null);
        b.setMinimumSize(new Dimension(4, 4));
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            public Icon getIcon() {
                return UIManager.getIcon(QuaquaSplitPaneDivider.this.splitPane.getOrientation() == 1 ? "SplitPane.rightArrow" : "SplitPane.downArrow");
            }
        };
        b.setBorder(null);
        b.setMinimumSize(new Dimension(4, 4));
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected class QuaquaMouseHandler
    extends BasicSplitPaneDivider.MouseHandler {
        protected QuaquaMouseHandler() {
            super(QuaquaSplitPaneDivider.this);
        }

        public void mouseReleased(MouseEvent e) {
            int lastLoc = QuaquaSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int currentLoc = QuaquaSplitPaneDivider.this.splitPane.getDividerLocation();
            super.mouseReleased(e);
            if (QuaquaSplitPaneDivider.this.splitPane.getDividerLocation() == currentLoc) {
                QuaquaSplitPaneDivider.this.splitPane.setLastDividerLocation(lastLoc);
            }
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                int currentLoc;
                int maxLoc;
                int minLoc;
                boolean isHorizontal = QuaquaSplitPaneDivider.this.splitPane.getOrientation() == 1;
                Component leftC = QuaquaSplitPaneDivider.this.splitPane.getLeftComponent();
                Component rightC = QuaquaSplitPaneDivider.this.splitPane.getRightComponent();
                if (leftC == null || rightC == null) {
                    return;
                }
                Insets insets = QuaquaSplitPaneDivider.this.splitPane.getInsets();
                if (isHorizontal) {
                    minLoc = leftC.isVisible() ? leftC.getMinimumSize().width + insets.left : insets.left;
                    maxLoc = rightC.isVisible() ? QuaquaSplitPaneDivider.this.splitPane.getWidth() - rightC.getMinimumSize().width - insets.right - QuaquaSplitPaneDivider.this.getSize().width : QuaquaSplitPaneDivider.this.splitPane.getWidth() - insets.right;
                } else {
                    minLoc = leftC.isVisible() ? leftC.getMinimumSize().height + insets.top : insets.top;
                    maxLoc = rightC.isVisible() ? QuaquaSplitPaneDivider.this.splitPane.getHeight() - rightC.getMinimumSize().height - insets.bottom - QuaquaSplitPaneDivider.this.getSize().height : QuaquaSplitPaneDivider.this.splitPane.getHeight() - insets.bottom;
                }
                maxLoc = Math.max(0, maxLoc);
                minLoc = Math.max(0, Math.min(minLoc, maxLoc));
                if (isHorizontal) {
                    int helper = maxLoc;
                    maxLoc = minLoc;
                    minLoc = helper;
                }
                int lastLoc = QuaquaSplitPaneDivider.this.splitPane.getLastDividerLocation();
                int newLoc = (currentLoc = QuaquaSplitPaneDivider.this.splitPaneUI.getDividerLocation(QuaquaSplitPaneDivider.this.splitPane)) == maxLoc ? lastLoc : maxLoc;
                if (currentLoc != newLoc) {
                    QuaquaSplitPaneDivider.this.splitPane.setDividerLocation(newLoc);
                    QuaquaSplitPaneDivider.this.splitPane.setLastDividerLocation(currentLoc);
                }
            }
        }
    }

    protected class QuaquaDividerLayout
    implements LayoutManager {
        protected QuaquaDividerLayout() {
        }

        public void layoutContainer(Container c) {
            if (QuaquaSplitPaneDivider.this.leftButton != null && QuaquaSplitPaneDivider.this.rightButton != null && c == QuaquaSplitPaneDivider.this) {
                if (QuaquaSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = c.getInsets();
                    if (QuaquaSplitPaneDivider.this.orientation == 0) {
                        int blockSize = QuaquaSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, 4);
                        int extraX = c.getSize().width - (insets != null ? insets.right : 0) - 2 - blockSize * 4;
                        int y = (c.getSize().height - blockSize) / 2;
                        QuaquaSplitPaneDivider.this.leftButton.setBounds(extraX, y, blockSize * 2, blockSize);
                        QuaquaSplitPaneDivider.this.rightButton.setBounds(extraX + blockSize * 2, y, blockSize * 2, blockSize);
                    } else {
                        int blockSize = QuaquaSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, 4);
                        int extraY = c.getSize().height - (insets != null ? insets.bottom : 0) - 2 - blockSize * 4;
                        int x = (c.getSize().width - blockSize) / 2;
                        QuaquaSplitPaneDivider.this.leftButton.setBounds(x, extraY, blockSize, blockSize * 2);
                        QuaquaSplitPaneDivider.this.rightButton.setBounds(x, extraY + blockSize * 2, blockSize, blockSize * 2);
                    }
                } else {
                    QuaquaSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    QuaquaSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            int width;
            if (c != QuaquaSplitPaneDivider.this || QuaquaSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension buttonMinSize = null;
            if (QuaquaSplitPaneDivider.this.splitPane.isOneTouchExpandable() && QuaquaSplitPaneDivider.this.leftButton != null) {
                buttonMinSize = QuaquaSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = QuaquaSplitPaneDivider.this.getInsets();
            int height = width = QuaquaSplitPaneDivider.this.getDividerSize();
            if (QuaquaSplitPaneDivider.this.orientation == 0) {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.height;
                    if (insets != null) {
                        size += insets.top + insets.bottom;
                    }
                    height = Math.max(height, size);
                }
                width = 1;
            } else {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.width;
                    if (insets != null) {
                        size += insets.left + insets.right;
                    }
                    width = Math.max(width, size);
                }
                height = 1;
            }
            return new Dimension(width, height);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void addLayoutComponent(String string, Component c) {
        }
    }
}

