/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.util;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.dieslunae.jgraphite.model.ToneCurve;

public class Settings {
    public static final String APP_NAME = "JGraphite";
    public static final String APP_VER = "0.5.8";
    public static final String APP_ADDITIONAL_INFO = "(c)2010-2012 Ireneusz Kulaga";
    public static final String PREF_ROOT = "JGraphite";
    public static final String PREF_CURVES_PATH = "JGraphite/curves";
    public static final String PREF_NODE_LAST_PATH = "lastImagePath";
    public static final int WIND_DEFAULT_WIDTH = 800;
    public static final int WIND_DEFAULT_HEIGHT = 600;
    public static final int BRIGHTNESS_DEFAULT = 0;
    public static final int VIGNETTE_STRENGTH_DEFAULT = 50;
    public static final int THUMB_MAX_SIZE = 480;
    public static final String IMAGE_EXTENSIONS = "jpg jpeg gif";
    public static final String CONFIG_FILE_NAME = "jgraphite.conf";
    public static final String LF_CLASS_NIMBUS = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    public static final String LF_CLASS_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static String TXT_MENU_FILE = "File";
    public static String TXT_MENU_OPEN_IMAGE = "Open image";
    public static String TXT_MENU_SAVE_IMAGE = "Save image";
    public static String TXT_MENU_ABOUT = "About";
    public static String TXT_MENU_EXIT = "Exit";
    public static String TXT_PROCESS = "Process image";
    public static String TXT_GRAYSCALE_CONVERSION_TYPE = "Conversion type";
    public static String TXT_VIGNETTING = "Vignetting [%]";
    public static String TXT_GAMMA = "Brightness";
    public static String TXT_AUTO_BRIGHTNESS = "Auto";
    public static String TXT_TONE_CURVE = "Tone curve";
    public static String TXT_MOUSE_USAGE = "Use mouse to modify points:";
    public static String TXT_IMAGE_FILTER = "Image Files";
    public static String TXT_TC_NO_CHANGE = "No change";
    public static String TXT_TC_PORTRAIT = "Portrait";
    public static String TXT_TC_DEFAULT_CONTRAST = "Default contrast";
    public static String TXT_TC_STRONG_CONSTRAST = "Strong contrast";
    public static String TXT_TC_HIGH_KEY = "High key";
    public static String TXT_TC_LOW_KEY = "Low key";
    public static String TXT_TC_CUSTOM = "Custom";
    public static String TXT_MENU_SETTINGS = "Settings";
    public static String TXT_MENU_JPG_QUALITY = "Output JPG quality";
    public static String TXT_MENU_QUALITY_LOW = "Low (0.85)";
    public static String TXT_MENU_QUALITY_AVERAGE = "Average (0.90)";
    public static String TXT_MENU_QUALITY_FINE = "Fine (0.97)";
    public static String TXT_MENU_PREVIEW = "Full screen preview";
    public static String TXT_SAVE_CURVE = "Save curve";
    public static String TXT_NAME = "Name";
    public static int VIGNETTE_STRENGTH_IN_PERCENT = 50;
    public static int BRIGHTNESS = 0;
    public static boolean PROCESS_IMAGE = true;
    public static boolean AUTO_BRIGHTNESS = true;
    public static final float OUTPUT_JPG_QUALITY_LOW = 0.85f;
    public static final float OUTPUT_JPG_QUALITY_AVERAGE = 0.9f;
    public static final float OUTPUT_JPG_QUALITY_FINE = 0.97f;
    public static float OUTPUT_JPG_QUALITY = 0.97f;
    public static String TXT_CONVERSION_GRAYSCALE = "Grayscale";
    public static String TXT_CONVERSION_SEPIA = "Sepia";
    public static String TXT_CONVERSION_CYANOTYPE = "Cyanotype";
    public static String TXT_CONVERSION_NONE = "None";
    public static String TXT_CONVERSION_KEEP_RED = "Keep Red";
    public static String TXT_CONVERSION_KEEP_GREEN = "Keep Green";
    public static String TXT_CONVERSION_KEEP_BLUE = "Keep Blue";
    public static String TXT_CONVERSION_EXP_RED = "Experimental Red";
    public static String TXT_CONVERSION_EXP_GREEN = "Experimental Green";
    public static String TXT_CONVERSION_EXP_BLUE = "Experimental Blue";
    public static ConversionType CONVERTSION_TYPE = ConversionType.GRAYSCALE;
    public static final ToneCurve TONE_CURVE_NO_CHANGE = new ToneCurve(TXT_TC_NO_CHANGE, new Point(0, 0), new Point(255, 255));
    public static final ToneCurve TONE_CURVE_PORTRAIT = new ToneCurve(TXT_TC_PORTRAIT, new Point(0, 0), new Point(24, 10), new Point(38, 22), new Point(50, 37), new Point(101, 128), new Point(119, 159), new Point(146, 195), new Point(166, 217), new Point(184, 232), new Point(200, 241), new Point(214, 248), new Point(255, 255));
    public static final ToneCurve TONE_CURVE_DEFAULT_CONTRAST = new ToneCurve(TXT_TC_DEFAULT_CONTRAST, new Point(0, 0), new Point(24, 12), new Point(39, 22), new Point(50, 38), new Point(186, 230), new Point(200, 241), new Point(214, 248), new Point(255, 255));
    public static final ToneCurve TONE_CURVE_STRONG_CONTRAST = new ToneCurve(TXT_TC_STRONG_CONSTRAST, new Point(0, 0), new Point(44, 22), new Point(59, 32), new Point(70, 48), new Point(166, 220), new Point(180, 231), new Point(194, 238), new Point(255, 255));
    public static ToneCurve TONE_CURVE_HIGH_KEY = new ToneCurve(TXT_TC_HIGH_KEY, new Point(0, 0), new Point(9, 40), new Point(26, 83), new Point(57, 134), new Point(96, 180), new Point(141, 214), new Point(192, 238), new Point(255, 255));
    public static ToneCurve TONE_CURVE_HIGH_KEY_2 = new ToneCurve(String.valueOf(TXT_TC_HIGH_KEY) + " 2", new Point(0, 0), new Point(13, 13), new Point(31, 77), new Point(49, 134), new Point(88, 180), new Point(134, 214), new Point(184, 238), new Point(255, 255));
    public static ToneCurve TONE_CURVE_LOW_KEY = new ToneCurve(TXT_TC_LOW_KEY, new Point(0, 0), new Point(24, 10), new Point(63, 32), new Point(110, 66), new Point(158, 120), new Point(193, 169), new Point(226, 216), new Point(255, 255));
    public static ToneCurve TONE_CURVE_CUSTOM = new ToneCurve(TXT_TC_CUSTOM, new Point(0, 0), new Point(255, 255));
    public static int TONE_CURVE = 1;
    public static int TONE_CURVE_INDEX_OF_CUSTOM = 7;
    public static List<ToneCurve> TONE_CURVES = new ArrayList<ToneCurve>();

    static {
        TONE_CURVES.addAll(Arrays.asList(TONE_CURVE_NO_CHANGE, TONE_CURVE_PORTRAIT, TONE_CURVE_DEFAULT_CONTRAST, TONE_CURVE_STRONG_CONTRAST, TONE_CURVE_HIGH_KEY, TONE_CURVE_HIGH_KEY_2, TONE_CURVE_LOW_KEY, TONE_CURVE_CUSTOM));
        Preferences pCurvesNode = Preferences.userRoot().node(PREF_CURVES_PATH);
        try {
            String[] stringArray = pCurvesNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cName = stringArray[n2];
                String points = pCurvesNode.get(cName, null);
                ToneCurve tc = ToneCurve.fromPoints(points);
                tc.setName(cName);
                TONE_CURVES.add(tc);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static List<ToneCurve> getToneCurves() {
        return TONE_CURVES;
    }

    public static void setCustomToneCurve(ToneCurve tc) {
        TONE_CURVES.set(TONE_CURVE_INDEX_OF_CUSTOM, tc);
    }

    public static int addToneCurve(ToneCurve tc) {
        int index = -1;
        int i = TONE_CURVE_INDEX_OF_CUSTOM + 1;
        while (i < TONE_CURVES.size()) {
            if (TONE_CURVES.get(i).getName().equals(tc.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > 0) {
            TONE_CURVES.set(index, tc);
        } else {
            TONE_CURVES.add(tc);
            index = TONE_CURVES.size() - 1;
        }
        Preferences pCurvesNode = Preferences.userRoot().node(PREF_CURVES_PATH);
        pCurvesNode.put(tc.getName(), tc.pointsToString());
        return index;
    }

    public static String getLastImagePath() {
        Preferences pNode = Preferences.userRoot().node("JGraphite");
        return pNode.get(PREF_NODE_LAST_PATH, "");
    }

    public static void setLastImagePath(String path) {
        Preferences pNode = Preferences.userRoot().node("JGraphite");
        pNode.put(PREF_NODE_LAST_PATH, path);
    }

    public static enum ConversionType {
        GRAYSCALE(TXT_CONVERSION_GRAYSCALE),
        SEPIA(TXT_CONVERSION_SEPIA),
        CYANOTYPE(TXT_CONVERSION_CYANOTYPE),
        NONE(TXT_CONVERSION_NONE),
        KEEP_RED(TXT_CONVERSION_KEEP_RED),
        KEEP_GREEN(TXT_CONVERSION_KEEP_GREEN),
        KEEP_BLUE(TXT_CONVERSION_KEEP_BLUE),
        EXPERIMENTAL_RED(TXT_CONVERSION_EXP_RED),
        EXPERIMENTAL_GREEN(TXT_CONVERSION_EXP_GREEN),
        EXPERIMENTAL_BLUE(TXT_CONVERSION_EXP_BLUE);

        private String label;

        private ConversionType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

