/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ToneCurve
implements Cloneable {
    private String name = null;
    private List<Point> points = new ArrayList<Point>();
    private int[] mappingTable = new int[256];

    public ToneCurve() {
    }

    public ToneCurve(String name) {
        this.name = name;
    }

    public ToneCurve(String name, Point ... points) {
        this.name = name;
        this.setPoints(points);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
        this.createMappingTable();
    }

    public void setPoints(Point[] points) {
        this.points.clear();
        Collections.addAll(this.points, points);
        this.createMappingTable();
    }

    public int[] getMappingTable() {
        return this.mappingTable;
    }

    public Point getPoint(int index) {
        return this.points.get(index);
    }

    public int getPointsCount() {
        return this.points.size();
    }

    private void createMappingTable() {
        int p = 0;
        while (p < this.points.size() - 1) {
            Point p0 = this.points.get(p);
            Point p1 = this.points.get(p + 1);
            float dy = ((float)p1.y - (float)p0.y) / (float)(p1.x - p0.x);
            int x = p0.x;
            while (x <= p1.x) {
                this.mappingTable[x] = p0.y + (int)((float)(x - p0.x) * dy);
                ++x;
            }
            ++p;
        }
    }

    public String pointsToString() {
        StringBuilder s = new StringBuilder();
        int p = 0;
        while (p < this.points.size()) {
            s.append('(');
            s.append(this.points.get((int)p).x);
            s.append(';');
            s.append(this.points.get((int)p).y);
            s.append(')');
            if (p < this.points.size() - 1) {
                s.append(',');
            }
            ++p;
        }
        return s.toString();
    }

    public static ToneCurve fromPoints(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException();
        }
        StringTokenizer st = new StringTokenizer(s, ",;()");
        int tokenCount = st.countTokens();
        if (tokenCount % 2 == 1) {
            throw new IllegalArgumentException();
        }
        if (tokenCount / 2 < 2) {
            throw new IllegalArgumentException();
        }
        ArrayList<Point> points = new ArrayList<Point>();
        int i = 0;
        while (i < tokenCount / 2) {
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            x = x < 0 ? 0 : x;
            x = x > 255 ? 255 : x;
            y = y < 0 ? 0 : y;
            y = y > 255 ? 255 : y;
            points.add(new Point(x, y));
            ++i;
        }
        ToneCurve tc = new ToneCurve();
        tc.setPoints(points);
        return tc;
    }
}

