/*
 * Decompiled with CFR 0.152.
 */
package net.dieslunae.jgraphite.model;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import net.dieslunae.jgraphite.ctrl.JGraphiteController;
import net.dieslunae.jgraphite.util.Settings;

public class ImageModel {
    private BufferedImage image = null;
    private BufferedImage scaledImage = null;
    private BufferedImage convertedImage = null;
    private JGraphiteController controller;
    private int autoBrightnessLevel = 0;

    public ImageModel(JGraphiteController c) {
        this.controller = c;
    }

    public boolean isImageAvailable() {
        return this.image != null;
    }

    public BufferedImage getScaledImage() {
        return this.scaledImage;
    }

    public BufferedImage getConvertedImage() {
        return this.convertedImage;
    }

    public void loadImage(String path) throws IOException {
        double aspectRatio;
        File imgFile = new File(path);
        BufferedImage newImage = null;
        newImage = ImageIO.read(imgFile);
        if (newImage == null) {
            throw new IOException("Image has not been loaded correctly");
        }
        this.image = newImage;
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        int newWidht = 0;
        int newHeight = 0;
        if (width > height) {
            aspectRatio = (double)height / (double)width;
            newWidht = 480;
            newHeight = (int)(480.0 * aspectRatio);
        } else {
            aspectRatio = (double)width / (double)height;
            newHeight = 480;
            newWidht = (int)(480.0 * aspectRatio);
        }
        Image img = this.image.getScaledInstance(newWidht, newHeight, 4);
        this.scaledImage = this.toBufferedImage(img);
        this.convertedImage = new BufferedImage(newWidht, newHeight, 1);
        this.autoBrightnessLevel = this.calculateAutoBrightnessLevel(this.scaledImage);
    }

    public void saveImage(String path) throws IOException {
        if (this.image == null) {
            return;
        }
        BufferedImage dstImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 1);
        this.convertImage(this.image, dstImage);
        this.saveImage(dstImage, path);
    }

    public void convertImage() {
        if (this.scaledImage == null || this.convertedImage == null) {
            return;
        }
        this.convertImage(this.scaledImage, this.convertedImage);
    }

    private void convertImage(BufferedImage src, BufferedImage dst) {
        if (src == null || dst == null) {
            return;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        WritableRaster destRast = dst.getRaster();
        int[] mapping = Settings.getToneCurves().get(Settings.TONE_CURVE).getMappingTable();
        WritableRaster srcRast = src.getRaster();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int rMax = (int)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        if (srcRast.getNumBands() != 3) {
            System.out.println("Num of bands != 3");
            return;
        }
        double vk1 = 0.002 * (double)Settings.VIGNETTE_STRENGTH_IN_PERCENT;
        double vk2 = 0.005 * (double)Settings.VIGNETTE_STRENGTH_IN_PERCENT;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int r = srcRast.getSample(x, y, 0);
                int g = srcRast.getSample(x, y, 1);
                int b = srcRast.getSample(x, y, 2);
                int gray = (r + g + b) / 3;
                int gamma = Settings.AUTO_BRIGHTNESS ? this.autoBrightnessLevel : Settings.BRIGHTNESS;
                r = (gamma + 100) * r / 100;
                if (r > 255) {
                    r = 255;
                }
                if (r < 0) {
                    r = 0;
                }
                if ((g = (gamma + 100) * g / 100) > 255) {
                    g = 255;
                }
                if (g < 0) {
                    g = 0;
                }
                if ((b = (gamma + 100) * b / 100) > 255) {
                    b = 255;
                }
                if (b < 0) {
                    b = 0;
                }
                if ((gray = (gamma + 100) * gray / 100) > 255) {
                    gray = 255;
                }
                if (gray < 0) {
                    gray = 0;
                }
                r = r > 0 ? r * mapping[r] / r : 0;
                g = g > 0 ? g * mapping[g] / g : 0;
                b = b > 0 ? b * mapping[b] / b : 0;
                gray = mapping[gray];
                double rad = Math.sqrt((halfWidth - x) * (halfWidth - x) + (halfHeight - y) * (halfHeight - y));
                double f = rad / (double)rMax;
                int vVal = (int)((1.0 - vk1 * (f * f * f * f) - vk2 * (f * f * f * f * f * f * f * f)) * 255.0);
                r = vVal * r / 255;
                g = vVal * g / 255;
                b = vVal * b / 255;
                gray = vVal * gray / 255;
                switch (Settings.CONVERTSION_TYPE) {
                    case GRAYSCALE: {
                        destRast.setSample(x, y, 0, gray);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, gray);
                        break;
                    }
                    case SEPIA: {
                        r = gray + 20;
                        if (r > 255) {
                            r = 255;
                        }
                        if ((b = gray - 20) < 0) {
                            b = 0;
                        }
                        destRast.setSample(x, y, 0, r);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, b);
                        break;
                    }
                    case CYANOTYPE: {
                        b = gray + 20;
                        if (b > 255) {
                            b = 255;
                        }
                        if ((r = gray - 20) < 0) {
                            r = 0;
                        }
                        destRast.setSample(x, y, 0, r);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, b);
                        break;
                    }
                    case KEEP_RED: {
                        if (r < gray) {
                            r = gray;
                        }
                        destRast.setSample(x, y, 0, r);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, gray);
                        break;
                    }
                    case KEEP_GREEN: {
                        if (g < gray) {
                            g = gray;
                        }
                        destRast.setSample(x, y, 0, gray);
                        destRast.setSample(x, y, 1, g);
                        destRast.setSample(x, y, 2, gray);
                        break;
                    }
                    case KEEP_BLUE: {
                        if (b < gray) {
                            b = gray;
                        }
                        destRast.setSample(x, y, 0, gray);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, b);
                        break;
                    }
                    case EXPERIMENTAL_RED: {
                        destRast.setSample(x, y, 0, r);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, gray);
                        break;
                    }
                    case EXPERIMENTAL_GREEN: {
                        destRast.setSample(x, y, 0, gray);
                        destRast.setSample(x, y, 1, g);
                        destRast.setSample(x, y, 2, gray);
                        break;
                    }
                    case EXPERIMENTAL_BLUE: {
                        destRast.setSample(x, y, 0, gray);
                        destRast.setSample(x, y, 1, gray);
                        destRast.setSample(x, y, 2, b);
                        break;
                    }
                    default: {
                        destRast.setSample(x, y, 0, r);
                        destRast.setSample(x, y, 1, g);
                        destRast.setSample(x, y, 2, b);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void saveImage(BufferedImage img, String path) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(Settings.OUTPUT_JPG_QUALITY);
        File file = new File(path);
        try {
            FileImageOutputStream output = new FileImageOutputStream(file);
            writer.setOutput(output);
            IIOImage image = new IIOImage(img, null, null);
            writer.write(null, image, iwp);
            output.close();
        }
        finally {
            writer.dispose();
        }
    }

    private BufferedImage toBufferedImage(Image src) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        int type = 1;
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public BufferedImage getScaledConvertedImage(int maxWidth, int maxHeight) {
        if (this.image == null) {
            return null;
        }
        int imgWidth = this.image.getWidth();
        int imgHeight = this.image.getHeight();
        double scaleW = 1.0;
        double scaleH = 1.0;
        if (imgWidth > maxWidth) {
            scaleW = (double)maxWidth / (double)imgWidth;
        }
        if (imgHeight > maxHeight) {
            scaleH = (double)maxHeight / (double)imgHeight;
        }
        double scale = 1.0;
        if (scaleW < 1.0 || scaleH < 1.0) {
            scale = scaleW < scaleH ? scaleW : scaleH;
        }
        int newWidth = (int)((double)imgWidth * scale);
        int newHeight = (int)((double)imgHeight * scale);
        BufferedImage scaledConvertedImage = null;
        Image scaledImage = this.image.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage scaledBufferedImage = this.toBufferedImage(scaledImage);
        scaledConvertedImage = new BufferedImage(newWidth, newHeight, 4);
        this.convertImage(scaledBufferedImage, scaledConvertedImage);
        return scaledConvertedImage;
    }

    private int calculateAutoBrightnessLevel(BufferedImage img) {
        int[] histoData = new int[256];
        WritableRaster imgRast = img.getRaster();
        int width = img.getWidth();
        int height = img.getHeight();
        int bands = imgRast.getNumBands();
        if (bands != 1 && bands != 3) {
            System.out.println("Wrong no of bands: " + bands);
            throw new IllegalArgumentException();
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int value = 0;
                if (bands == 1) {
                    value = imgRast.getSample(x, y, 0);
                } else {
                    int r = imgRast.getSample(x, y, 0);
                    int g = imgRast.getSample(x, y, 1);
                    int b = imgRast.getSample(x, y, 2);
                    value = (r + g + b) / 3;
                }
                if (value < 0) {
                    value = 0;
                }
                if (value > 255) {
                    value = 255;
                }
                int n = value;
                histoData[n] = histoData[n] + 1;
                ++x;
            }
            ++y;
        }
        int i = 255;
        while (i >= 0) {
            if (histoData[i] > 0) break;
            --i;
        }
        if (i == 255 || i < 50) {
            return 0;
        }
        return 25500 / i - 100;
    }

    public int getAutoBrightnessLevel() {
        return this.autoBrightnessLevel;
    }
}

