/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class IconEdit1Icon
extends JPanel
implements ActionListener,
ChangeListener,
Transferable {
    final Color[] backColors = new Color[]{IconEdit1.BACKGROUND, Color.BLACK, Color.RED, Color.BLUE, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.YELLOW, Color.WHITE};
    static Color[][] clipColors;
    static int clipDepth;
    static BufferedImage clipImage;
    static boolean[][] clipOpaque;
    JSlider backSlider;
    IconEdit1Draw bigIcon;
    IconEdit1Draw smallIcon;
    int colorDepth = 8;
    Color[][] colors;
    JRadioButton depthBit4;
    JRadioButton depthBit8;
    JRadioButton depthBit24;
    ButtonGroup depthGroup;
    boolean depthWarning = false;
    Color iconBackground = this.backColors[0];
    JButton iconClear;
    JButton iconCopy;
    JButton iconPaste;
    boolean[][] isOpaque;
    int size;

    public IconEdit1Icon(int n) {
        this.size = n;
        this.colors = new Color[this.size][this.size];
        this.isOpaque = new boolean[this.size][this.size];
        Box box = Box.createVerticalBox();
        box.setBackground(IconEdit1.BACKGROUND);
        box.add(Box.createVerticalStrut(10));
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 0));
        jPanel.setBackground(IconEdit1.BACKGROUND);
        this.iconClear = new JButton("Clear");
        this.iconClear.addActionListener(this);
        this.iconClear.setToolTipText("Clear icon, this size only.");
        jPanel.add(this.iconClear);
        this.iconCopy = new JButton("Copy");
        this.iconCopy.addActionListener(this);
        this.iconCopy.setToolTipText("Copy icon to clipboard, this size only.");
        jPanel.add(this.iconCopy);
        this.iconPaste = new JButton("Paste");
        this.iconPaste.addActionListener(this);
        this.iconPaste.setToolTipText("Paste icon from clipboard, this size only.");
        jPanel.add(this.iconPaste);
        box.add(jPanel);
        box.add(Box.createVerticalStrut(15));
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 0));
        jPanel2.setBackground(IconEdit1.BACKGROUND);
        JLabel jLabel = new JLabel("colors:");
        jLabel.setToolTipText("Color depth for icon sample and when saving file.");
        jPanel2.add(jLabel);
        this.depthGroup = new ButtonGroup();
        this.depthBit4 = new JRadioButton("16", false);
        this.depthBit4.addActionListener(this);
        this.depthBit4.setBackground(IconEdit1.BACKGROUND);
        this.depthBit4.setToolTipText("Windows 4-bit palette (16 colors)");
        this.depthGroup.add(this.depthBit4);
        jPanel2.add(this.depthBit4);
        this.depthBit8 = new JRadioButton("256", true);
        this.depthBit8.addActionListener(this);
        this.depthBit8.setBackground(IconEdit1.BACKGROUND);
        this.depthBit8.setToolTipText("web safe 8-bit palette (256 colors)");
        this.depthGroup.add(this.depthBit8);
        jPanel2.add(this.depthBit8);
        this.depthBit24 = new JRadioButton("RGB", false);
        this.depthBit24.addActionListener(this);
        this.depthBit24.setBackground(IconEdit1.BACKGROUND);
        this.depthBit24.setToolTipText("RGB 24-bit color (millions)");
        this.depthGroup.add(this.depthBit24);
        jPanel2.add(this.depthBit24);
        box.add(jPanel2);
        box.add(Box.createVerticalStrut(15));
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel3.setBackground(IconEdit1.BACKGROUND);
        jPanel3.add(Box.createHorizontalStrut(12));
        this.backSlider = new JSlider(0, this.backColors.length - 1, 0);
        this.backSlider.addChangeListener(this);
        this.backSlider.setBackground(IconEdit1.BACKGROUND);
        this.backSlider.setMajorTickSpacing(1);
        this.backSlider.setPaintTicks(false);
        this.backSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("A", 0));
        hashtable.put(new Integer(1), new JLabel("K", 0));
        hashtable.put(new Integer(2), new JLabel("R", 0));
        hashtable.put(new Integer(3), new JLabel("B", 0));
        hashtable.put(new Integer(4), new JLabel("M", 0));
        hashtable.put(new Integer(5), new JLabel("G", 0));
        hashtable.put(new Integer(6), new JLabel("C", 0));
        hashtable.put(new Integer(7), new JLabel("Y", 0));
        hashtable.put(new Integer(8), new JLabel("W", 0));
        this.backSlider.setLabelTable(hashtable);
        this.backSlider.setPaintLabels(true);
        jPanel3.add(this.backSlider);
        jPanel3.add(Box.createHorizontalStrut(10));
        box.add(jPanel3);
        box.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel4.setBackground(IconEdit1.BACKGROUND);
        JLabel jLabel2 = new JLabel("transparency background", 0);
        jLabel2.setToolTipText("Change background color to view transparent icons.");
        jPanel4.add(jLabel2);
        box.add(jPanel4);
        box.add(Box.createVerticalStrut(20));
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 0));
        jPanel5.setBackground(IconEdit1.BACKGROUND);
        jPanel5.add(Box.createHorizontalStrut(this.size + 6), "North");
        jPanel5.add(Box.createVerticalStrut(this.size + 6), "West");
        this.smallIcon = new IconEdit1Draw(this, false);
        jPanel5.add((Component)this.smallIcon, "Center");
        JPanel jPanel6 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel6.setBackground(IconEdit1.BACKGROUND);
        jPanel6.add(jPanel5);
        box.add(jPanel6);
        box.add(Box.createVerticalStrut(8));
        JPanel jPanel7 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel7.setBackground(IconEdit1.BACKGROUND);
        jPanel7.add(new JLabel("icon sample, actual size", 0));
        box.add(jPanel7);
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 0));
        jPanel8.setBackground(IconEdit1.BACKGROUND);
        jPanel8.add((Component)box, "North");
        this.setBackground(IconEdit1.BACKGROUND);
        this.setLayout(new BorderLayout(5, 5));
        this.add(Box.createVerticalStrut(5), "North");
        this.add(Box.createHorizontalStrut(5), "West");
        this.bigIcon = new IconEdit1Draw(this, true);
        this.add((Component)this.bigIcon, "Center");
        this.add((Component)jPanel8, "East");
        this.add(Box.createVerticalStrut(3), "South");
        this.clearThisIcon();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.depthBit4) {
            this.colorDepth = 4;
            this.repaint();
        } else if (object == this.depthBit8) {
            this.colorDepth = 8;
            this.repaint();
        } else if (object == this.depthBit24) {
            this.colorDepth = 24;
            this.repaint();
        } else if (object == this.iconClear) {
            IconEdit1.statusDialog.setText("Click to paint.  Right (control) click to erase.  Shift click to select.");
            if (JOptionPane.showConfirmDialog(IconEdit1.mainFrame, "Erase this icon, this size?") == 0) {
                this.clearThisIcon();
                this.repaint();
            }
        } else if (object == this.iconCopy) {
            IconEdit1.statusDialog.setText("Click to paint.  Right (control) click to erase.  Shift click to select.");
            this.copyThisIcon();
        } else if (object == this.iconPaste) {
            IconEdit1.statusDialog.setText("Click to paint.  Right (control) click to erase.  Shift click to select.");
            this.pasteThisIcon();
        } else {
            System.err.println("Error in actionPerformed(): unknown ActionEvent: " + actionEvent);
        }
    }

    void clearThisIcon() {
        this.backSlider.setValue(0);
        this.colorDepth = 8;
        this.depthBit8.setSelected(true);
        this.iconBackground = this.backColors[0];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.colors[i][j] = Color.BLACK;
                this.isOpaque[i][j] = false;
            }
        }
    }

    void copyThisIcon() {
        clipColors = new Color[this.size][this.size];
        clipDepth = this.colorDepth;
        clipImage = new BufferedImage(this.size, this.size, 1);
        clipOpaque = new boolean[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                IconEdit1Icon.clipColors[i][j] = this.colors[i][j];
                IconEdit1Icon.clipOpaque[i][j] = this.isOpaque[i][j];
                if (this.isOpaque[i][j]) {
                    clipImage.setRGB(j, i, this.colors[i][j].getRGB());
                    continue;
                }
                clipImage.setRGB(j, i, this.iconBackground.getRGB());
            }
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this, null);
        }
        catch (IllegalStateException illegalStateException) {
            JOptionPane.showMessageDialog(IconEdit1.mainFrame, "Can't put image on clipboard:\n" + illegalStateException.getMessage());
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        if (clipImage == null) {
            throw new IOException("no clipboard image created");
        }
        if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            return clipImage;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.imageFlavor);
    }

    void pasteThisIcon() {
        BufferedImage bufferedImage;
        try {
            bufferedImage = (BufferedImage)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.imageFlavor);
        }
        catch (IllegalStateException illegalStateException) {
            bufferedImage = null;
        }
        catch (IOException iOException) {
            bufferedImage = null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            bufferedImage = null;
        }
        if (bufferedImage == null) {
            IconEdit1.statusDialog.setText("Sorry, no image found on clipboard.");
            return;
        }
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        if (n != this.size || n2 != this.size) {
            IconEdit1.statusDialog.setText("Sorry, image is " + n2 + " x " + n + " and icon is " + this.size + " x " + this.size + ".  Please resize.");
            return;
        }
        this.clearThisIcon();
        if (clipImage == bufferedImage) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.colors[i][j] = clipColors[i][j];
                    this.isOpaque[i][j] = clipOpaque[i][j];
                }
            }
            this.colorDepth = clipDepth;
            if (this.colorDepth == 4) {
                this.depthBit4.setSelected(true);
            } else if (this.colorDepth == 8) {
                this.depthBit8.setSelected(true);
            } else {
                this.depthBit24.setSelected(true);
            }
        } else {
            clipColors = null;
            clipImage = null;
            clipOpaque = null;
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.colors[i][j] = new Color(bufferedImage.getRGB(j, i));
                    this.isOpaque[i][j] = true;
                }
            }
            if (IconEdit1.colorsAreWindows16(this.colors)) {
                this.colorDepth = 4;
                this.depthBit4.setSelected(true);
            } else if (IconEdit1.colorsAreWebSafe(this.colors)) {
                this.colorDepth = 8;
                this.depthBit8.setSelected(true);
            } else {
                this.colorDepth = 24;
                this.depthBit24.setSelected(true);
            }
        }
        this.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.backSlider) {
            this.iconBackground = this.backColors[this.backSlider.getValue()];
            this.repaint();
        } else {
            System.err.println("Error in stateChanged(): unknown ChangeEvent: " + changeEvent);
        }
    }

    static {
        clipImage = null;
    }
}

