package retypar.converter.helper;

import heuser.simpleLogger.SimpleLogger;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Calendar;

import retypar.retypar;

//@todo change fonstsize instead of picture when scaling
// resulting pic same size as original!

/**
 * The converter itself, used by {@link retypar.converter.MRules} and {@link retypar.converter.Noise}.
 * @author Jens Heuser
 */
public class ImageProcessor extends SimpleLogger implements Runnable{

    /**
     * String representation of the converted image.
     */
    public String[] txtVerMono;

    /**
     * Array of colors, used to assemble HTML page.
     */
    public Color[][] colors;

    private FontRenderer fRender;
    private Image originalImage;

    /**
     * <code>true</code> while an image is being converted. Used by {@link retypar#convertImage}
     * to return the converted image when conversion is over.
     */
    public boolean working;
    BufferedImage converted;

    private boolean uppercase;
    private boolean lowercase;
    private boolean numbers;
    private boolean special;
    public boolean colored;
    private int renderMode;
    private int threshold;


    public Color bgColor;

    /**
     * Thread cancellation.
     */
    public boolean stop;

    private int scale;

    public final int RENDER_MRULES = 0;
    public final int RENDER_NOISE = 1;


    private int destHeight;
    private int destWidth;

    private Letter m;
    private Letter l;

    private BufferedImage bImg;

    public float progress = 0;



    /**
     * Creates an instance of {@link FontRenderer}, {@link ImageProcessor#init} has to be called afterwards.<br>
     * Only one instance of <code>FontRenderer</code> is created. This way the generated lists
     * of <code>Letter</code>s can be reused.
     */
    public ImageProcessor(){
        fRender = new FontRenderer();
    }


    /**
     * Starts the conversion.
     * @param image The image to be converted
     * @param uppercase
     * @param lowercase
     * @param numbers
     * @param special
     * @param colored
     * @param scale The scale factor for the original image.
     */
    public void init(Image image, boolean uppercase, boolean lowercase, boolean numbers, boolean special, boolean colored, Color bgColor, int scale, int renderMode, int threshold){
        this.originalImage = image;
        this.uppercase = uppercase;
        this.lowercase = lowercase;
        this.numbers = numbers;
        this.special = special;
        this.colored = colored;
        this.bgColor = bgColor;
        this.scale = scale;
        this.renderMode = renderMode;
        this.threshold = threshold;

        stop = false;
        progress = 0;
        working = true;
    }


    public void run(){
        prepareConversion();
        //converted = convertImage();
    }


    /**
     * Calls {@link FontRenderer#render} to generate the list of characters used to repaint the image.<br>
     * This method is called from the {@link ImageProcessor#run} method.
      */
    private void prepareConversion(){
            fRender.render(new Font(retypar.font, Font.PLAIN, retypar.fontSize), uppercase, lowercase, numbers, special);
    }


    /**
     * This method converts the image using {@link ImageProcessor#check(int[], java.awt.Color)} and -if needed- {@link ImageProcessor#calcColor(int[])}.
     * @return The converted image.
     */
    public BufferedImage convertImage(){
        BufferedImage file;
        Image image;
        String sign;
        int row = 0;
        Color color;

        file = new BufferedImage(originalImage.getWidth(null), originalImage.getHeight(null), BufferedImage.TYPE_INT_RGB);
        file.getGraphics().drawImage(originalImage, 0, 0, originalImage.getWidth(null), originalImage.getHeight(null), null);

        destWidth = file.getWidth();
        destHeight = file.getHeight();

        if (scale != 100){
            destWidth   = (destWidth * scale / 100);
            destHeight  = (destHeight * scale / 100);
        }

        destWidth = (destWidth / retypar.fontSize) * retypar.fontSize;
        destHeight= (destHeight / retypar.fontSize) * retypar.fontSize;

        txtVerMono = new String[destHeight/retypar.fontSize];
        colors = new Color[destHeight/retypar.fontSize][destWidth/retypar.fontSize];

        if (scale != 100){
            image = file.getScaledInstance(destWidth, destHeight, Image.SCALE_FAST);

            file = new BufferedImage(destWidth, destHeight, BufferedImage.TYPE_INT_RGB);
            file.getGraphics().drawImage(image, 0, 0, null);
        }

        bImg = new BufferedImage(destWidth, destHeight, BufferedImage.TYPE_INT_RGB);


        Graphics2D g = bImg.createGraphics();
        g.setBackground(bgColor);
        g.clearRect(0, 0, destWidth, destHeight);
        g.setColor(Color.BLACK);

        Font font = new Font(retypar.font, Font.PLAIN, retypar.fontSize + 1);
        g.setFont(font);

        float step = 100 / (((float)destWidth / retypar.fontSize) * ((float)destHeight / retypar.fontSize));

        //startTimer();

        //retypar.fontSize += -1;


        int[] data;

        for (int j = 0; j < destHeight; j+= retypar.fontSize){
            row = j/retypar.fontSize;
            txtVerMono[row] = "";


            for (int i = 0; i < destWidth; i+= retypar.fontSize){
                progress += step;

                data = new int[retypar.fontSize * retypar.fontSize];
                for(int c = 0; c < (retypar.fontSize); c++){
                    for(int d = 0; d < (retypar.fontSize); d++){
                        data[c*retypar.fontSize + d] = file.getRGB(i + d, j + c);
                    }
                }

                color = calcColor(data);
                if (colored) {
                    g.setColor(color);
                    colors[row][i/retypar.fontSize] = color;
                }

                sign = check(data, color);
                txtVerMono[row] += sign;
                //data = check(data, calcColor(data));
                //bImg.setRGB(i, j, retypar.fontSize, retypar.fontSize, data, 0, 10);
                g.drawString(sign, i, j + retypar.fontSize);
            }

            if (stop) {
                working = false;
                return bImg;
            }
        }
        working = false;
        progress = 100;

        file.flush();
        g.dispose();
        bImg.flush();

        return bImg;
    }


    public String[] getTxtVerMono(){
        return txtVerMono;
    }

    public BufferedImage getImage(){
        return bImg;
    }



    /**
     * Searches {@link FontRenderer#letters} for the best fitting sign for the given int array of colors.
     * @param block The int array of colors from the original image to be replaced by an ASCII character.
     * @return The best fitting ASCII sign as <code>String</code>.
     */
    private String check(int[] block, Color col){
        int count = FontRenderer.letters.size();
        m = (Letter)FontRenderer.letters.get(count - 1);
        int min = m.fits(block);
        char best = m.name;

        switch(renderMode){
            case RENDER_MRULES: block = renderMRules(block, col, threshold);
                break;
            case RENDER_NOISE: block = renderNoise(block, col, threshold);
        }

        while(count > 0){
            count--;
            l = (Letter)FontRenderer.letters.get(count);
            if(l.fits(block) < min) {
                min = l.fits(block);
                best = l.name;
            }
        }
        return ""+best;
    }


    private int[] renderMRules(int[] block, Color col, int threshold){
        int y;
        for (y = 0; y < block.length; y++){
            //Color cy = new Color(block[y]);

            /*r = cy.getRed() + (col.getRed() / 2);
            g = cy.getGreen() + (col.getGreen() / 2);
            b = cy.getBlue() + (col.getBlue() / 2);

            if (r > 255) r = 255;
            if (g > 255) g = 255;
            if (b > 255) b = 255;*/
            //block[y] = cy.getRGB() + col.getRGB();
            //if (block[y] > 0) block[y] = 0;
            /*if (block[y] < col.getRGB())
                block[y] = -16777216;
            else block[y] = -1;*/
            //block[y] = cy.getRGB();
        }
        return block;
    }


    private int[] renderNoise(int[] block, Color col, int threshold){
        int y, r, g, b;

        for (y = 0; y < block.length; y++){
            Color cy = new Color(block[y]);

            r = cy.getRed() - col.getRed();
            g = cy.getGreen() - col.getGreen();
            b = cy.getBlue() - col.getBlue();

            if ((r < -threshold) || (r > threshold)) r = 0;
                else r = 255;
            if ((g < -threshold) || (g > threshold)) g = 0;
                else g = 255;
            if ((b < -threshold) || (b > threshold)) b = 0;
                else b = 255;

            cy = new Color(r, g, b);
            block[y] = cy.getRGB();
        }
        return block;
    }


    /**
     * Calculates the color of the ASCII sign to be drawn.<br>
     * Only invoked if {@link ImageProcessor#colored} is <code>true</code>. Background color is taken into account.
     * @param data The int array of colors from the current image area.
     * @return The <code>Color</code> to be used.
     */
    private Color calcColor(int[] data){
        int red     = 0;
        int green   = 0;
        int blue    = 0;

        for (int i = 0; i < retypar.fontSize * retypar.fontSize; i++){
            red     = (red  + DirectColorModel.getRGBdefault().getRed(data[i]))     / 2;
            blue    = (blue + DirectColorModel.getRGBdefault().getBlue(data[i]))    / 2;
            green   = (green+ DirectColorModel.getRGBdefault().getGreen(data[i]))   / 2;
        }

        /*red     = (red  + bgColor.getRed())     / 2;
        green   = (green+ bgColor.getGreen())   / 2;
        blue    = (blue + bgColor.getBlue())    / 2;*/



        if (red > 255)  red =255;
        if (green > 255)green = 255;
        if (blue > 255) blue = 255;

        return new Color(red, green, blue);
    }
}
