/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JMCADDocument
extends JPanel {
    public String doc_name = "";
    public String doc_autor = "";
    public String doc_info = "";
    private boolean isDebug = false;
    private boolean isVisual = false;
    private String file_name = null;
    private int x = 0;
    private int y = 0;
    private boolean isCalc = false;
    public long time_from = 0L;
    public long time_to = 0L;
    public long time_sleep = 10L;
    public long time_current = 0L;
    public long time_debug = 500L;
    public int window_x = 0;
    public int window_y = 0;
    public int window_w = 500;
    public int window_h = 400;
    public int window_visual_x = 0;
    public int window_visual_y = 0;
    public int window_visual_w = 0;
    public int window_visual_h = 0;
    public boolean window_max = false;
    public boolean window_visual_max = false;
    private Thread tsolve;
    private Object addObject;
    private Vector<JMCADDocument> sub_doc = new Vector();

    public JMCADDocument() {
        try {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    JMCADDocument.this.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (JMCADDocument.this.addObject != null) {
                        JMCADObject jMCADObject = (JMCADObject)JMCADDocument.this.addObject;
                        jMCADObject.setLocation(mouseEvent.getX(), mouseEvent.getY());
                        jMCADObject.Id = "Object" + new Date().getTime();
                        JMCADDocument.this.add(jMCADObject);
                        JMCADDocument.this.addObject = null;
                        JMCADDocument.this.getJMCAD().b_select.setSelected(true);
                        JMCADDocument.this.getJMCAD().tree_menu.clearSelection();
                        JMCADDocument.this.repaint();
                        JMCADDocument.this.validate();
                    }
                    JMCADDocument.this.x = mouseEvent.getX();
                    JMCADDocument.this.y = mouseEvent.getY();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    JMCADDocument.this.repaint();
                    JMCADDocument.this.validate();
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        JMCADDocument.this.setConfig();
                    }
                }
            });
            if (!JMCAD.isSingle) {
                this.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        Component[] componentArray = JMCADDocument.this.getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            componentArray[i].setLocation(componentArray[i].getLocation().x - JMCADDocument.this.x + mouseEvent.getX(), componentArray[i].getLocation().y - JMCADDocument.this.y + mouseEvent.getY());
                        }
                        JMCADDocument.this.x = mouseEvent.getX();
                        JMCADDocument.this.y = mouseEvent.getY();
                        JMCADDocument.this.repaint();
                        JMCADDocument.this.validate();
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void Document_Add_Object(Object object) {
        this.addObject = object;
    }

    public void Document_Calc_Stop() {
        this.isCalc = false;
    }

    public void Document_Calc() {
        if (this.isCalc) {
            System.out.println("*** Interrupted Calc *** " + (this.file_name == null ? "" : this.file_name));
            this.isCalc = false;
            this.getJMCAD().b_start.setSelected(false);
            this.getJMCAD().reset_menu();
        } else {
            this.isCalc = true;
            this.getJMCAD().b_start.setSelected(true);
            this.getJMCAD().reset_menu();
            this.tsolve = new Thread(){
                Component[] comp;
                Component[] comp_gen;
                int comp_count;
                {
                    this.comp = JMCADDocument.this.getComponents();
                    this.comp_count = 0;
                }

                @Override
                public void run() {
                    int n;
                    for (n = 0; n < this.comp.length; ++n) {
                        if (!((JMCADObject)this.comp[n]).isGeneranor) continue;
                        ++this.comp_count;
                    }
                    this.comp_gen = new Component[this.comp_count];
                    this.comp_count = 0;
                    for (n = 0; n < this.comp.length; ++n) {
                        if (!((JMCADObject)this.comp[n]).isGeneranor) continue;
                        this.comp_gen[this.comp_count] = this.comp[n];
                        ++this.comp_count;
                    }
                    JMCADDocument.this.time_from = System.currentTimeMillis();
                    for (n = 0; n < this.comp.length; ++n) {
                        JMCADObject jMCADObject = (JMCADObject)this.comp[n];
                        for (int i = 0; i < jMCADObject.in.length; ++i) {
                            jMCADObject.in[i] = Double.NaN;
                        }
                        jMCADObject.calc_pre();
                    }
                    while (JMCADDocument.this.isCalc) {
                        if (JMCADDocument.this.time_sleep > 0L) {
                            try {
                                Thread.sleep(JMCADDocument.this.time_sleep);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        JMCADDocument.this.time_current = System.currentTimeMillis();
                        for (int i = 0; i < this.comp_gen.length && JMCADDocument.this.isCalc; ++i) {
                            ((JMCADObject)this.comp_gen[i]).start(JMCADDocument.this.time_from, JMCADDocument.this.time_current, JMCADDocument.this.time_sleep);
                            if (!JMCADDocument.this.Document_isDebug()) continue;
                            ((JMCADObject)this.comp_gen[i]).isSelected = true;
                            ((JMCADObject)this.comp_gen[i]).repaint();
                            try {
                                Thread.sleep(JMCADDocument.this.time_debug);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!JMCADDocument.this.Document_isDebug()) continue;
                        JMCADDocument.this.Document_Clear_Selected();
                        try {
                            Thread.sleep(JMCADDocument.this.time_debug);
                        }
                        catch (Exception exception) {}
                    }
                    for (n = 0; n < this.comp.length; ++n) {
                        ((JMCADObject)this.comp[n]).calc_post();
                    }
                    JMCADDocument.this.getJMCAD().b_start.setSelected(false);
                    JMCADDocument.this.getJMCAD().reset_menu();
                    JMCADDocument.this.time_to = System.currentTimeMillis();
                    System.out.println("Stop Time:\t" + JMCADDocument.this.time_to + " ms (" + (JMCADDocument.this.file_name == null ? "" : JMCADDocument.this.file_name) + ")");
                    System.out.println("Calc Time:\t" + (JMCADDocument.this.time_to - JMCADDocument.this.time_from) + " ms (" + (JMCADDocument.this.file_name == null ? "" : JMCADDocument.this.file_name) + ")");
                    System.out.println("*** End Calc *** " + (JMCADDocument.this.file_name == null ? "" : JMCADDocument.this.file_name));
                    JMCADDocument.this.isCalc = false;
                }
            };
            this.tsolve.setPriority(1);
            this.tsolve.start();
            System.out.println("\n\n*** Start Calc *** " + (this.file_name == null ? "" : this.file_name));
            System.out.println("Start Time:\t" + this.time_from + " ms (" + (this.file_name == null ? "" : this.file_name) + ")");
        }
    }

    public void Document_Clear_Selected() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMCADObject jMCADObject = (JMCADObject)componentArray[i];
            jMCADObject.isSelected = false;
            jMCADObject.clear_in();
            jMCADObject.clear_out();
            jMCADObject.repaint();
        }
        this.repaint();
    }

    public boolean Document_isCalc() {
        return this.isCalc;
    }

    public boolean Document_isDebug() {
        return this.isDebug;
    }

    public void Document_setDebug(boolean bl) {
        this.isDebug = bl;
        this.Document_Clear_Selected();
    }

    public boolean Document_isVisual() {
        return this.isVisual;
    }

    public void Document_setVisual(boolean bl) {
        this.isVisual = bl;
        Component[] componentArray = this.getComponents();
        Color color = new JPanel().getBackground();
        for (int i = 0; i < componentArray.length; ++i) {
            int n;
            JMCADObject jMCADObject = (JMCADObject)componentArray[i];
            if (!jMCADObject.isVisual) {
                jMCADObject.setVisible(!bl);
                continue;
            }
            int n2 = 0;
            if (jMCADObject.in.length > 0) {
                n2 += 10;
            }
            if (jMCADObject.out.length > 0) {
                n2 += 10;
            }
            jMCADObject.panel_in.removeAll();
            jMCADObject.panel_out.removeAll();
            jMCADObject.panel_in.setBackground(color);
            jMCADObject.panel_out.setBackground(color);
            jMCADObject.panel_c.setBackground(color);
            Component[] componentArray2 = jMCADObject.panel_c.getComponents();
            for (n = 0; n < componentArray2.length; ++n) {
                componentArray2[n].setBackground(color);
            }
            componentArray2 = jMCADObject.getComponents();
            for (n = 0; n < componentArray2.length; ++n) {
                componentArray2[n].setBackground(color);
            }
            jMCADObject.setBackground(color);
            jMCADObject.setLocation(jMCADObject.position_visual_x, jMCADObject.position_visual_y);
            jMCADObject.w = jMCADObject.size_visual_w;
            jMCADObject.h = jMCADObject.size_visual_h;
            jMCADObject.setSize(jMCADObject.size_visual_w + n2, jMCADObject.size_visual_h);
        }
        this.setBackground(color);
        this.Document_Clear_Selected();
    }

    public String Document_Save() {
        return this.Document_Save(this.getFileName());
    }

    public String Document_Save(String string) {
        if (!string.endsWith(".jmcad")) {
            string = string + ".jmcad";
        }
        File file = new File(string);
        System.out.println("Save model - " + file.getAbsolutePath());
        file.delete();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.setLength(0L);
            Component[] componentArray = this.getComponents();
            randomAccessFile.writeBytes("time_sleep = " + this.time_sleep + "\n");
            randomAccessFile.writeBytes("window_bounds = " + this.window_x + " " + this.window_y + " " + this.window_w + " " + this.window_h + "\n");
            randomAccessFile.writeBytes("window_visual_bounds = " + this.window_visual_x + " " + this.window_visual_y + " " + this.window_visual_w + " " + this.window_visual_h + "\n");
            randomAccessFile.writeBytes("window_maximum = " + this.window_max + "\n");
            randomAccessFile.writeBytes("window_visual_maximum = " + this.window_max + "\n");
            randomAccessFile.writeBytes("debug = " + this.Document_isDebug() + "\n");
            randomAccessFile.writeBytes("time_debug = " + this.time_debug + "\n");
            randomAccessFile.writeBytes("name = " + new String(this.doc_name.getBytes("Cp1251"), "ISO8859_1") + "\n");
            randomAccessFile.writeBytes("autor = " + new String(this.doc_autor.getBytes("Cp1251"), "ISO8859_1") + "\n");
            randomAccessFile.writeBytes("info = " + new String(this.doc_info.replace('\n', ' ').getBytes("Cp1251"), "ISO8859_1") + "\n\n");
            for (int i = 0; i < componentArray.length; ++i) {
                ((JMCADObject)componentArray[i]).write(randomAccessFile);
                randomAccessFile.writeBytes("\n");
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            this.error(exception);
        }
        this.setFileName(string);
        return this.getFileName();
    }

    public static JMCADDocument Document_Open(String string) {
        JMCADDocument jMCADDocument = new JMCADDocument();
        jMCADDocument.sub_doc.removeAllElements();
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            StringTokenizer stringTokenizer;
            String string2;
            string = JMCADSystemProperties.findFile(string);
            if (string == null) {
                return jMCADDocument;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            String string3 = null;
            jMCADDocument.doc_name = "";
            jMCADDocument.file_name = string;
            while ((string2 = randomAccessFile.readLine()) != null) {
                if (string2.startsWith("[")) {
                    if (string3 != null && string3.startsWith("[")) {
                        stringTokenizer = new StringTokenizer(string3, "[] =\t");
                        object3 = stringTokenizer.nextToken();
                        object2 = stringTokenizer.nextToken();
                        object = (JMCADObject)Class.forName((String)object2).newInstance();
                        ((JMCADObject)object).Id = object3;
                        if (jMCADDocument.Document_isVisual()) {
                            ((JComponent)object).setVisible(((JMCADObject)object).isVisual);
                        }
                        ((JMCADObject)object).parse(string3);
                        jMCADDocument.add((Component)object);
                        if (((String)object2).equals("_doc")) {
                            jMCADDocument.sub_doc.add(JMCADDocument.Document_Open(((_doc)object).file_name));
                        }
                    } else if (string3 != null) {
                        stringTokenizer = new StringTokenizer(string3, "\n");
                        while (stringTokenizer.hasMoreTokens()) {
                            try {
                                object3 = stringTokenizer.nextToken();
                                if (((String)(object3 = ((String)object3).trim())).length() == 0) continue;
                                object2 = new StringTokenizer((String)object3, " =\t");
                                object = ((StringTokenizer)object2).nextToken();
                                if (((String)object).equalsIgnoreCase("TIME_SLEEP")) {
                                    jMCADDocument.time_sleep = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("WINDOW_BOUNDS")) {
                                    jMCADDocument.window_x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    jMCADDocument.window_y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    jMCADDocument.window_w = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    jMCADDocument.window_h = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("WINDOW_VISUAL_BOUNDS")) {
                                    jMCADDocument.window_visual_x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    jMCADDocument.window_visual_y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    jMCADDocument.window_visual_w = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    jMCADDocument.window_visual_h = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("DEBUG")) {
                                    jMCADDocument.Document_setDebug(Boolean.parseBoolean(((StringTokenizer)object2).nextToken()));
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("TIME_DEBUG")) {
                                    jMCADDocument.time_debug = Integer.parseInt(((StringTokenizer)object2).nextToken());
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("WINDOW_MAXIMUM")) {
                                    jMCADDocument.window_max = Boolean.parseBoolean(((StringTokenizer)object2).nextToken());
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("WINDOW_VISUAL_MAXIMUM")) {
                                    jMCADDocument.window_visual_max = Boolean.parseBoolean(((StringTokenizer)object2).nextToken());
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("NAME")) {
                                    jMCADDocument.doc_name = "";
                                    jMCADDocument.doc_name = ((StringTokenizer)object2).nextToken("");
                                    jMCADDocument.doc_name = new String(jMCADDocument.doc_name.substring(jMCADDocument.doc_name.indexOf("=") + 1).trim().getBytes("ISO8859_1"), "Cp1251");
                                    continue;
                                }
                                if (((String)object).equalsIgnoreCase("AUTOR")) {
                                    jMCADDocument.doc_autor = ((StringTokenizer)object2).nextToken("");
                                    jMCADDocument.doc_autor = new String(jMCADDocument.doc_autor.substring(jMCADDocument.doc_autor.indexOf("=") + 1).trim().getBytes("ISO8859_1"), "Cp1251");
                                    continue;
                                }
                                if (!((String)object).equalsIgnoreCase("INFO")) continue;
                                jMCADDocument.doc_info = ((StringTokenizer)object2).nextToken("");
                                jMCADDocument.doc_info = new String(jMCADDocument.doc_info.substring(jMCADDocument.doc_info.indexOf("=") + 1).trim().getBytes("ISO8859_1"), "Cp1251");
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                    }
                    string3 = string2;
                    continue;
                }
                string3 = string3 + "\n" + string2;
            }
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, "[] =\t");
                object3 = stringTokenizer.nextToken();
                object2 = stringTokenizer.nextToken();
                object = (JMCADObject)Class.forName((String)object2).newInstance();
                ((JMCADObject)object).Id = object3;
                if (jMCADDocument.Document_isVisual()) {
                    ((JComponent)object).setVisible(((JMCADObject)object).isVisual);
                }
                ((JMCADObject)object).parse(string3);
                jMCADDocument.add((Component)object);
                if (((String)object2).equals("_doc")) {
                    jMCADDocument.sub_doc.add(JMCADDocument.Document_Open(((_doc)object).file_name));
                }
            } else if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        object3 = stringTokenizer.nextToken();
                        if (((String)(object3 = ((String)object3).trim())).length() == 0) continue;
                        object2 = new StringTokenizer((String)object3, " =\t");
                        object = ((StringTokenizer)object2).nextToken();
                        if (((String)object).equalsIgnoreCase("TIME_SLEEP")) {
                            jMCADDocument.time_sleep = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("WINDOW_BOUNDS")) {
                            jMCADDocument.window_x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            jMCADDocument.window_y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            jMCADDocument.window_w = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            jMCADDocument.window_h = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("WINDOW_VISUAL_BOUNDS")) {
                            jMCADDocument.window_visual_x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            jMCADDocument.window_visual_y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            jMCADDocument.window_visual_w = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            jMCADDocument.window_visual_h = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("DEBUG")) {
                            jMCADDocument.Document_setDebug(Boolean.parseBoolean(((StringTokenizer)object2).nextToken()));
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("TIME_DEBUG")) {
                            jMCADDocument.time_debug = Integer.parseInt(((StringTokenizer)object2).nextToken());
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("WINDOW_MAXIMUM")) {
                            jMCADDocument.window_max = Boolean.parseBoolean(((StringTokenizer)object2).nextToken());
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("NAME")) {
                            jMCADDocument.doc_name = "";
                            jMCADDocument.doc_name = ((StringTokenizer)object2).nextToken("");
                            jMCADDocument.doc_name = new String(jMCADDocument.doc_name.substring(jMCADDocument.doc_name.indexOf("=") + 1).trim().getBytes("ISO8859_1"), "Cp1251");
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("AUTOR")) {
                            jMCADDocument.doc_autor = ((StringTokenizer)object2).nextToken("");
                            jMCADDocument.doc_autor = new String(jMCADDocument.doc_autor.substring(jMCADDocument.doc_autor.indexOf("=") + 1).trim().getBytes("ISO8859_1"), "Cp1251");
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase("INFO")) continue;
                        jMCADDocument.doc_info = ((StringTokenizer)object2).nextToken("");
                        jMCADDocument.doc_info = new String(jMCADDocument.doc_info.substring(jMCADDocument.doc_info.indexOf("=") + 1).trim().getBytes("ISO8859_1"), "Cp1251");
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            for (int i = 0; i < jMCADDocument.sub_doc.size(); ++i) {
                System.out.println("---" + i + "---");
                System.out.println("Doc = " + jMCADDocument.file_name);
                System.out.println("Doc Sub = " + jMCADDocument.sub_doc.elementAt((int)i).file_name);
                System.out.println("Doc Sub Length = " + jMCADDocument.sub_doc.elementAt(i).getComponents().length);
                System.out.println("---" + i + "---");
            }
            Component[] componentArray = jMCADDocument.getComponents();
            object3 = new JMCADObject[componentArray.length];
            for (n = 0; n < componentArray.length; ++n) {
                object3[n] = (JMCADObject)componentArray[n];
            }
            for (n = 0; n < ((Object)object3).length; ++n) {
                object = ((JMCADObject)object3[n]).out_obj;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    try {
                        if (object[i] == null) continue;
                        Object object4 = null;
                        int n2 = -1;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(object[i] + "", " ");
                        String string4 = stringTokenizer2.nextToken();
                        String string5 = stringTokenizer2.nextToken();
                        for (int j = 0; j < ((Object)object3).length; ++j) {
                            if (!((JMCADObject)object3[j]).Id.toUpperCase().equals(string4)) continue;
                            object4 = object3[j];
                        }
                        String[] stringArray = ((JMCADObject)object4).in_text;
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (!stringArray[j].equals(string5)) continue;
                            n2 = j;
                        }
                        ((JMCADObject)object3[n]).out_obj[i] = object4;
                        ((JMCADObject)object3[n]).out_obj_index[i] = n2;
                        continue;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            for (n = 0; n < ((Object)object3).length; ++n) {
                if (!object3[n].getClass().getName().equals("_doc")) continue;
                System.out.println(object3[n]);
            }
            return jMCADDocument;
        }
        catch (Exception exception) {
            return jMCADDocument;
        }
    }

    public JMCAD getJMCAD() {
        Container container;
        for (container = this; container != null && !(container instanceof JMCAD); container = container.getParent()) {
        }
        return (JMCAD)container;
    }

    public JInternalFrame getJInternalFrame() {
        Container container;
        for (container = this; container != null && !(container instanceof JInternalFrame); container = container.getParent()) {
        }
        return (JInternalFrame)container;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isVisual) {
            return;
        }
        graphics.setColor(Color.black);
        ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Object[] objectArray = ((JMCADObject)componentArray[i]).out_obj;
            int[] nArray = ((JMCADObject)componentArray[i]).out_obj_index;
            for (int j = 0; j < objectArray.length; ++j) {
                try {
                    if (objectArray[j] == null) continue;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    n4 = componentArray[i].getLocation().x;
                    n4 += ((JMCADObject)componentArray[i]).panel_out.getLocation().x;
                    n4 += ((JMCADObject)componentArray[i]).panel_out.getComponent((int)j).getLocation().x + ((JMCADObject)componentArray[i]).panel_out.getComponent(j).getWidth() / 2;
                    n5 = componentArray[i].getLocation().y;
                    n5 += ((JMCADObject)componentArray[i]).panel_out.getLocation().y;
                    n2 = ((JMCADObject)objectArray[j]).getLocation().x;
                    n2 += ((JMCADObject)objectArray[j]).panel_in.getLocation().x;
                    n3 = ((JMCADObject)objectArray[j]).getLocation().y;
                    n3 += ((JMCADObject)objectArray[j]).panel_in.getLocation().y;
                    if (Math.abs(n4 - (n2 += ((JMCADObject)objectArray[j]).panel_in.getComponent((int)nArray[j]).getLocation().x + ((JMCADObject)objectArray[j]).panel_in.getComponent(nArray[j]).getWidth() / 2)) > 40 || Math.abs((n5 += ((JMCADObject)componentArray[i]).panel_out.getComponent((int)j).getLocation().y + ((JMCADObject)componentArray[i]).panel_out.getComponent(j).getHeight() / 2) - (n3 += ((JMCADObject)objectArray[j]).panel_in.getComponent((int)nArray[j]).getLocation().y + ((JMCADObject)objectArray[j]).panel_in.getComponent(nArray[j]).getHeight() / 2)) > 40) {
                        graphics.drawLine(n4, n5, n4 + 12, n5);
                        if (n4 > n2) {
                            n = n5 < n3 ? (n5 + ((JMCADObject)componentArray[i]).getHeight() / 2 + n3 - ((JMCADObject)objectArray[j]).getHeight() / 2) / 2 : (n5 - ((JMCADObject)componentArray[i]).getHeight() / 2 + n3 + ((JMCADObject)objectArray[j]).getHeight() / 2) / 2;
                            graphics.drawLine(n4 + 12, n5, n4 + 12, n);
                            graphics.drawLine(n4 + 12, n, n2 - 12, n);
                            graphics.drawLine(n2 - 12, n3, n2 - 12, n);
                        } else {
                            graphics.drawLine(n4 + 12, n5, n2 - 12, n3);
                        }
                        graphics.drawLine(n2 - 12, n3, n2, n3);
                        continue;
                    }
                    graphics.drawLine(n2, n3, n4, n5);
                    continue;
                }
                catch (Exception exception) {
                    objectArray[j] = null;
                }
            }
        }
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setFileName(String string) {
        this.file_name = string;
        this.getJInternalFrame().setTitle(this.file_name + (this.doc_name.length() > 0 ? " - " + this.doc_name : ""));
    }

    public void error(Object object) {
        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("JMCAD_Internationalize").getString("Error") + ": " + object, ResourceBundle.getBundle("JMCAD_Internationalize").getString("Error") + "!", 0);
        if (object instanceof Exception) {
            ((Exception)object).printStackTrace();
        } else {
            System.out.println(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Error") + ": " + object);
        }
    }

    public void setConfig() {
        try {
            JMCADConfigPanel jMCADConfigPanel = new JMCADConfigPanel();
            if (this.isVisual || JMCAD.isSingle) {
                jMCADConfigPanel.delay_debug.setEnabled(false);
                jMCADConfigPanel.name.setEnabled(false);
                jMCADConfigPanel.autor.setEnabled(false);
                jMCADConfigPanel.info.setEnabled(false);
            }
            jMCADConfigPanel.delay.setText(this.time_sleep + "");
            jMCADConfigPanel.delay_debug.setText(this.time_debug + "");
            jMCADConfigPanel.name.setText(this.doc_name);
            jMCADConfigPanel.autor.setText(this.doc_autor);
            jMCADConfigPanel.info.setText(this.doc_info);
            Object[] objectArray = new Object[]{ResourceBundle.getBundle("JMCAD_Internationalize").getString("Ok"), ResourceBundle.getBundle("JMCAD_Internationalize").getString("Cancel"), ResourceBundle.getBundle("JMCAD_Internationalize").getString("Help")};
            int n = JOptionPane.showOptionDialog(this, jMCADConfigPanel, ResourceBundle.getBundle("JMCAD_Internationalize").getString("Configuring_model"), 0, -1, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.time_sleep = Integer.parseInt(jMCADConfigPanel.delay.getText());
                this.doc_name = jMCADConfigPanel.name.getText();
                this.doc_autor = jMCADConfigPanel.autor.getText();
                this.doc_info = jMCADConfigPanel.info.getText();
                this.time_debug = Integer.parseInt(jMCADConfigPanel.delay_debug.getText());
            } else if (n == 2) {
                this.getJMCAD().showHelp("config", ResourceBundle.getBundle("JMCAD_Internationalize").getString("Configuring_model"));
            }
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }
}

