/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class _oscillograph
extends JMCADObject {
    private BufferedImage offscreen;
    private BufferedImage offscreen_grid;
    private Graphics2D offgraphics;
    private Graphics2D offgraphics_grid;
    private Vector valueY;
    private double sy;
    private double min_y;
    private double max_y;
    private double dy;
    private int w_c;
    private int h_c;
    private boolean isPainted = false;
    private double[] vy;
    private JTextField tfw = new JTextField();
    private JTextField tfh = new JTextField();

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBytes("width = " + this.w_c + "\n");
        randomAccessFile.writeBytes("height = " + this.h_c + "\n");
    }

    @Override
    public void parse(String string) {
        super.parse(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken();
                if ((string2 = string2.trim()).length() == 0) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " =,\t");
                String string3 = stringTokenizer2.nextToken();
                if (string3.equalsIgnoreCase("WIDTH")) {
                    string3 = stringTokenizer2.nextToken();
                    try {
                        this.w = Integer.parseInt(string3) + 40;
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this.w_c = this.w - 40;
                    continue;
                }
                if (!string3.equalsIgnoreCase("HEIGHT")) continue;
                string3 = stringTokenizer2.nextToken();
                try {
                    this.h = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                this.h_c = this.h;
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public _oscillograph() {
        this.isVisual = true;
        this.ToolTipText = ResourceBundle.getBundle("JMCAD_Internationalize").getString("Display_of_data_in_real_time");
        this.in = new double[1];
        this.in[0] = Double.NaN;
        this.in_text = new String[1];
        this.in_text[0] = "IN";
        this.out = new double[1];
        this.out[0] = Double.NaN;
        this.out_text = new String[1];
        this.out_text[0] = "OUT";
        this.out_obj = new Object[1];
        this.out_obj_index = new int[1];
        this.w = 150;
        this.h = 100;
        this.w_c = 150;
        this.h_c = 100;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void paint_info(Graphics graphics) {
        this.isPainted = true;
        if (this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        } else {
            graphics.drawImage(this.getImageGrid(), 0, 0, this);
        }
        this.isPainted = false;
    }

    private BufferedImage getImageGrid() {
        double d;
        if (this.panel_c.getWidth() != 0) {
            this.w_c = this.panel_c.getWidth();
        }
        if (this.panel_c.getHeight() != 0) {
            this.h_c = this.panel_c.getHeight();
        }
        this.offscreen_grid = new BufferedImage(this.w_c, this.h_c, 5);
        this.offgraphics_grid = (Graphics2D)this.offscreen_grid.getGraphics();
        this.offgraphics_grid.clearRect(0, 0, this.w_c, this.h_c);
        this.offgraphics_grid.setColor(Color.gray);
        this.offgraphics_grid.setStroke(new BasicStroke(1.0f));
        double d2 = this.w_c / 10;
        for (d = 0.0; d <= (double)(this.w_c + 1); d += d2) {
            this.offgraphics_grid.draw(new Line2D.Double(d, 0.0, d, this.h_c));
        }
        d = this.h_c / 10;
        for (double d3 = 0.0; d3 <= (double)(this.h_c + 1); d3 += d) {
            this.offgraphics_grid.draw(new Line2D.Double(0.0, d3, this.w_c, d3));
        }
        return this.offscreen_grid;
    }

    @Override
    public void calc_pre() {
        this.valueY = new Vector();
        if (this.panel_c.getWidth() != 0) {
            this.w_c = this.panel_c.getWidth();
        }
        if (this.panel_c.getHeight() != 0) {
            this.h_c = this.panel_c.getHeight();
        }
        this.sy = 1.0;
        this.min_y = Double.MAX_VALUE;
        this.max_y = Double.MIN_VALUE;
        this.valueY.removeAllElements();
        this.offscreen = new BufferedImage(this.w_c, this.h_c, 5);
        this.offgraphics = (Graphics2D)this.offscreen.getGraphics();
        this.vy = new double[this.w_c];
        this.getImageGrid();
    }

    @Override
    public void calc() {
        int n;
        this.out[0] = this.in[0];
        if (Double.isInfinite(this.in[0])) {
            return;
        }
        this.valueY.insertElementAt(new Double(this.in[0]), 0);
        if (this.valueY.size() > this.w_c) {
            this.valueY.setSize(this.w_c);
            this.valueY.trimToSize();
        }
        this.min_y = Math.min(this.min_y, this.in[0]);
        this.max_y = Math.max(this.max_y, this.in[0]);
        this.sy = (this.max_y - this.min_y) / (double)(this.h_c - 4);
        this.dy = -this.min_y / this.sy + 2.0;
        this.in[0] = Double.NaN;
        if (this.isPainted) {
            return;
        }
        this.offgraphics.drawImage(this.offscreen_grid, null, 0, 0);
        this.offgraphics.setColor(Color.GREEN);
        this.offgraphics.setStroke(new BasicStroke(2.0f));
        int n2 = this.valueY.size() - 1;
        for (n = 0; n < this.valueY.size(); ++n) {
            this.vy[n] = (double)this.h_c - (Double)this.valueY.elementAt(n2 - n) / this.sy - this.dy;
        }
        try {
            for (n = 0; n < this.valueY.size() - 1; ++n) {
                this.offgraphics.draw(new Line2D.Double(n, this.vy[n], n + 1, this.vy[n + 1]));
            }
            this.offgraphics.setColor(Color.YELLOW);
            this.offgraphics.drawString(this.max_y + "", 3, 10);
            this.offgraphics.drawString(this.min_y + "", 3, this.h_c - 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void calc_post() {
        int n;
        this.offgraphics.drawImage(this.offscreen_grid, null, 0, 0);
        this.offgraphics.setColor(Color.GREEN);
        this.offgraphics.setStroke(new BasicStroke(2.0f));
        if (this.valueY == null) {
            return;
        }
        int n2 = this.valueY.size() - 1;
        for (n = 0; n < this.valueY.size(); ++n) {
            this.vy[n] = (double)this.h_c - (Double)this.valueY.elementAt(n2 - n) / this.sy - this.dy;
        }
        try {
            for (n = 0; n < this.valueY.size() - 1; ++n) {
                this.offgraphics.draw(new Line2D.Double(n, this.vy[n], n + 1, this.vy[n + 1]));
            }
            this.offgraphics.setColor(Color.YELLOW);
            this.offgraphics.drawString(this.max_y + "", 3, 10);
            this.offgraphics.drawString(this.min_y + "", 3, this.h_c - 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void edit_pre() {
        this.edit_panel = new JPanel(new VerticalFlowLayout());
        this.tfw.setText("" + this.w_c);
        this.tfh.setText("" + this.h_c);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Width")), "West");
        jPanel.add((Component)this.tfw, "Center");
        jPanel2.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Height")), "West");
        jPanel2.add((Component)this.tfh, "Center");
        this.edit_panel.add(jPanel);
        this.edit_panel.add(jPanel2);
    }

    @Override
    public void edit_post() {
        try {
            this.setSize(Integer.parseInt(this.tfw.getText()) + this.panel_in.getWidth() * 2, Integer.parseInt(this.tfh.getText()));
            this.validate();
            this.revalidate();
            this.w_c = this.panel_c.getWidth();
            this.h_c = this.panel_c.getHeight();
            this.w = this.w_c;
            this.h = this.h_c;
            this.size_visual_w = this.w_c;
            this.size_visual_h = this.h_c;
            this.sy = (this.max_y - this.min_y) / (double)this.h_c;
            this.dy = -this.min_y / this.sy;
            this.offscreen = null;
            this.calc_pre();
            this.validate();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }
}

