/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_platform_id;
import org.jocl.cl_program;

public class _graph1_gpu
extends JMCADObject {
    private BufferedImage offscreen;
    private BufferedImage offscreen_grid;
    private Graphics2D offgraphics;
    private Graphics2D offgraphics_grid;
    private Vector valueX;
    private Vector valueY;
    private float sx;
    private float sy;
    private float dx;
    private float dy;
    private float count;
    private float count_i;
    private float min_x;
    private float min_y;
    private float max_x;
    private float max_y;
    private int w_c;
    private int h_c;
    private boolean isPainted = false;
    private boolean isRt = true;
    private JTextField tfw = new JTextField();
    private JTextField tfh = new JTextField();
    private JCheckBox cb = new JCheckBox(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Display_of_data_in_real_time"), true);
    private boolean joclinit = false;
    private cl_kernel kernel;
    private cl_context context;
    private cl_program program;
    private cl_command_queue commandQueue;
    private static String programSource = "__kernel void sampleKernel(__global float *X,             __global float *Y,             __global float *param){   int index = get_global_id(0);     X[index] = X[index]/param[0]+param[1];    Y[index] = param[4] - Y[index]/param[2]-param[3];}";

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBytes("width = " + this.w_c + "\n");
        randomAccessFile.writeBytes("height = " + this.h_c + "\n");
        randomAccessFile.writeBytes("real_time = " + this.cb.isSelected() + "\n");
    }

    @Override
    public void parse(String string) {
        super.parse(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken();
                if ((string2 = string2.trim()).length() == 0) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " =,\t");
                String string3 = stringTokenizer2.nextToken();
                if (string3.equalsIgnoreCase("WIDTH")) {
                    string3 = stringTokenizer2.nextToken();
                    try {
                        this.w = Integer.parseInt(string3) + 40;
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this.w_c = this.w - 40;
                    continue;
                }
                if (string3.equalsIgnoreCase("HEIGHT")) {
                    string3 = stringTokenizer2.nextToken();
                    try {
                        this.h = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this.h_c = this.h;
                    continue;
                }
                if (!string3.equalsIgnoreCase("REAL_TIME")) continue;
                string3 = stringTokenizer2.nextToken();
                try {
                    this.isRt = Boolean.valueOf(string3);
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                this.cb.setSelected(this.isRt);
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    public _graph1_gpu() {
        this.isVisual = true;
        this.isGeneranor = true;
        this.ToolTipText = ResourceBundle.getBundle("JMCAD_Internationalize").getString("The_time_graph:_Y_-_a_variable;_X_-_time_ti");
        this.in = new double[1];
        this.in[0] = Double.NaN;
        this.in_text = new String[1];
        this.in_text[0] = "IN";
        this.out = new double[1];
        this.out[0] = Double.NaN;
        this.out_text = new String[1];
        this.out_text[0] = "OUT";
        this.out_obj = new Object[1];
        this.out_obj_index = new int[1];
        this.w = 150;
        this.h = 100;
        this.w_c = 150;
        this.h_c = 100;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void paint_info(Graphics graphics) {
        this.isPainted = true;
        if (this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        } else {
            graphics.drawImage(this.getImageGrid(), 0, 0, this);
        }
        this.isPainted = false;
    }

    private BufferedImage getImageGrid() {
        double d;
        this.offscreen_grid = new BufferedImage(this.w_c, this.h_c, 5);
        this.offgraphics_grid = (Graphics2D)this.offscreen_grid.getGraphics();
        this.offgraphics_grid.setColor(this.panel_c.getBackground());
        this.offgraphics_grid.fillRect(0, 0, this.w_c, this.h_c);
        this.offgraphics_grid.setColor(Color.gray);
        this.offgraphics_grid.setStroke(new BasicStroke(1.0f));
        double d2 = (double)this.w_c / 10.0;
        for (d = 0.0; d <= (double)(this.w_c + 1); d += d2) {
            this.offgraphics_grid.draw(new Line2D.Double(d, 0.0, d, this.h_c));
        }
        d = (double)this.h_c / 10.0;
        for (double d3 = 0.0; d3 <= (double)(this.h_c + 1); d3 += d) {
            this.offgraphics_grid.draw(new Line2D.Double(0.0, d3, this.w_c, d3));
        }
        return this.offscreen_grid;
    }

    @Override
    public void calc_pre() {
        this.valueX = new Vector();
        this.valueY = new Vector();
        if (this.panel_c.getWidth() != 0) {
            this.w_c = this.panel_c.getWidth();
        }
        if (this.panel_c.getHeight() != 0) {
            this.h_c = this.panel_c.getHeight();
        }
        this.count_i = 0.0f;
        this.count /= (float)this.w_c;
        this.sx = 1.0f;
        this.sy = 1.0f;
        this.min_x = Float.MAX_VALUE;
        this.max_x = Float.MIN_VALUE;
        this.min_y = Float.MAX_VALUE;
        this.max_y = Float.MIN_VALUE;
        this.valueX.removeAllElements();
        this.valueY.removeAllElements();
        this.offscreen = (BufferedImage)this.panel_c.createImage(this.w_c, this.h_c);
        this.offgraphics = (Graphics2D)this.offscreen.getGraphics();
        long[] lArray = new long[1];
        try {
            System.out.println("Obtaining platform...");
            cl_platform_id[] cl_platform_idArray = new cl_platform_id[1];
            CL.clGetPlatformIDs(cl_platform_idArray.length, cl_platform_idArray, null);
            cl_context_properties cl_context_properties2 = new cl_context_properties();
            cl_context_properties2.addProperty(4228L, cl_platform_idArray[0]);
            this.context = CL.clCreateContextFromType(cl_context_properties2, 4L, null, null, null);
            if (this.context == null) {
                System.out.println("Unable to create a OpenCL context.");
                this.joclinit = false;
                return;
            }
            System.out.println("Created an OpenCL context on a GPU device.");
            CL.setExceptionsEnabled(true);
            CL.clGetContextInfo(this.context, 4225, 0L, null, lArray);
            int n = (int)lArray[0] / Sizeof.cl_device_id;
            NativePointerObject[] nativePointerObjectArray = new cl_device_id[n];
            CL.clGetContextInfo(this.context, 4225, lArray[0], Pointer.to(nativePointerObjectArray), null);
            this.commandQueue = CL.clCreateCommandQueue(this.context, (cl_device_id)nativePointerObjectArray[0], 0L, null);
            this.program = CL.clCreateProgramWithSource(this.context, 1, new String[]{programSource}, null, null);
            CL.clBuildProgram(this.program, 0, null, null, null, null);
            this.kernel = CL.clCreateKernel(this.program, "sampleKernel", null);
            this.joclinit = true;
        }
        catch (Exception exception) {
            try {
                System.out.println("JOCL Error!");
                CL.clReleaseKernel(this.kernel);
                CL.clReleaseProgram(this.program);
                CL.clReleaseCommandQueue(this.commandQueue);
                CL.clReleaseContext(this.context);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    @Override
    public void calc() {
        this.out[0] = this.in[0];
        if (Double.isInfinite(this.in[0])) {
            return;
        }
        this.valueY.addElement(new Float(this.in[0]));
        this.min_y = (float)Math.min((double)this.min_y, this.in[0]);
        this.max_y = (float)Math.max((double)this.max_y, this.in[0]);
        this.sy = (this.max_y - this.min_y) / (float)this.h_c;
        this.dy = -this.min_y / this.sy;
        this.in[0] = Double.NaN;
        if (!this.isRt) {
            return;
        }
        if (this.count < this.count_i) {
            if (this.isPainted) {
                return;
            }
            this.offgraphics.drawImage(this.offscreen_grid, null, 0, 0);
            this.offgraphics.setColor(Color.BLUE);
            this.offgraphics.setStroke(new BasicStroke(2.0f));
            float[] fArray = new float[this.valueX.size()];
            float[] fArray2 = new float[this.valueY.size()];
            if (this.joclinit) {
                int n;
                for (n = 0; n < this.valueX.size(); ++n) {
                    fArray[n] = ((Float)this.valueX.elementAt(n)).floatValue();
                }
                for (n = 0; n < this.valueY.size(); ++n) {
                    fArray2[n] = ((Float)this.valueY.elementAt(n)).floatValue();
                }
                float[] fArray3 = new float[]{this.sx, this.dx, this.sy, this.dy, this.h_c};
                Pointer pointer = Pointer.to(fArray);
                Pointer pointer2 = Pointer.to(fArray2);
                Pointer pointer3 = Pointer.to(fArray3);
                cl_mem[] cl_memArray = new cl_mem[7];
                cl_memArray[0] = CL.clCreateBuffer(this.context, 8L, 4 * fArray.length, pointer, null);
                cl_memArray[1] = CL.clCreateBuffer(this.context, 8L, 4 * fArray2.length, pointer2, null);
                cl_memArray[2] = CL.clCreateBuffer(this.context, 8L, 4 * fArray3.length, pointer3, null);
                CL.clSetKernelArg(this.kernel, 0, Sizeof.cl_mem, Pointer.to((NativePointerObject)cl_memArray[0]));
                CL.clSetKernelArg(this.kernel, 1, Sizeof.cl_mem, Pointer.to((NativePointerObject)cl_memArray[1]));
                CL.clSetKernelArg(this.kernel, 2, Sizeof.cl_mem, Pointer.to((NativePointerObject)cl_memArray[2]));
                long[] lArray = new long[]{fArray.length < fArray2.length ? (long)fArray2.length : (long)fArray.length};
                long[] lArray2 = new long[]{1L};
                CL.clEnqueueNDRangeKernel(this.commandQueue, this.kernel, 1, null, lArray, lArray2, 0, null, null);
                CL.clEnqueueReadBuffer(this.commandQueue, cl_memArray[0], true, 0L, fArray.length * 4, pointer, 0, null, null);
                CL.clEnqueueReadBuffer(this.commandQueue, cl_memArray[1], true, 0L, fArray2.length * 4, pointer2, 0, null, null);
                CL.clReleaseMemObject(cl_memArray[0]);
                CL.clReleaseMemObject(cl_memArray[1]);
                CL.clReleaseMemObject(cl_memArray[2]);
            }
            try {
                for (int i = 0; i < fArray.length - 1; ++i) {
                    this.offgraphics.draw(new Line2D.Double(fArray[i], fArray2[i], fArray[i + 1], fArray2[i + 1]));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.repaint();
            this.count_i = 0.0f;
        } else {
            this.count_i += 1.0f;
        }
    }

    @Override
    public void calc_post() {
        int n;
        if (this.joclinit) {
            CL.clReleaseKernel(this.kernel);
            CL.clReleaseProgram(this.program);
            CL.clReleaseCommandQueue(this.commandQueue);
            CL.clReleaseContext(this.context);
        }
        this.offgraphics.drawImage(this.offscreen_grid, null, 0, 0);
        this.offgraphics.setColor(Color.BLUE);
        this.offgraphics.setStroke(new BasicStroke(2.0f));
        if (this.valueX == null || this.valueY == null) {
            return;
        }
        float[] fArray = new float[this.valueX.size()];
        float[] fArray2 = new float[this.valueY.size()];
        for (n = 0; n < this.valueX.size() && n < this.valueY.size(); ++n) {
            fArray[n] = ((Float)this.valueX.elementAt(n)).floatValue() / this.sx + this.dx;
            fArray2[n] = (float)this.h_c - ((Float)this.valueY.elementAt(n)).floatValue() / this.sy - this.dy;
        }
        try {
            for (n = 0; n < fArray.length - 1; ++n) {
                this.offgraphics.draw(new Line2D.Double(fArray[n], fArray2[n], fArray[n + 1], fArray2[n + 1]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public synchronized void start(long l, long l2, long l3) {
        this.valueX.addElement(new Float(l2 & 0xFFFFFFL));
        this.min_x = l & 0xFFFFFFL;
        this.max_x = l2 & 0xFFFFFFL;
        this.count = (l - l2) / (long)this.h;
        this.sx = (this.max_x - this.min_x) / (float)this.w_c;
        this.dx = -this.min_x / this.sx;
    }

    @Override
    public void edit_pre() {
        this.edit_panel = new JPanel(new VerticalFlowLayout());
        this.tfw.setText("" + this.w_c);
        this.tfh.setText("" + this.h_c);
        this.cb.setSelected(this.isRt);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Width")), "West");
        jPanel.add((Component)this.tfw, "Center");
        jPanel2.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Height")), "West");
        jPanel2.add((Component)this.tfh, "Center");
        this.edit_panel.add(jPanel);
        this.edit_panel.add(jPanel2);
        this.edit_panel.add(this.cb);
    }

    @Override
    public void edit_post() {
        try {
            this.setSize(Integer.parseInt(this.tfw.getText()) + 40, Integer.parseInt(this.tfh.getText()));
            this.validate();
            this.revalidate();
            this.w_c = this.panel_c.getWidth();
            this.h_c = this.panel_c.getHeight();
            this.size_visual_w = this.w_c;
            this.size_visual_h = this.h_c;
            this.w = this.w_c;
            this.h = this.h_c;
            this.sx = (this.max_x - this.min_x) / (float)this.w_c;
            this.dx = -this.min_x / this.sx;
            this.sy = (this.max_y - this.min_y) / (float)this.h_c;
            this.dy = -this.min_y / this.sy;
            this.offscreen = (BufferedImage)this.panel_c.createImage(this.w_c, this.h_c);
            this.offgraphics = (Graphics2D)this.offscreen.getGraphics();
            this.getImageGrid();
            this.isRt = false;
            this.calc_post();
            this.panel_c.removeAll();
            this.isRt = this.cb.isSelected();
            this.validate();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }
}

