/*
 * Decompiled with CFR 0.152.
 */
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class _dev_RS232
extends JMCADObject
implements SerialPortEventListener {
    private final Image img = new ImageIcon(this.getClass().getResource("_dev_RS232.gif")).getImage();
    private JComboBox cb_port = new JComboBox();
    private JComboBox cb_br = new JComboBox<String>(new String[]{"110", "150", "300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200"});
    private JComboBox cb_db = new JComboBox<String>(new String[]{"5", "6", "7", "8"});
    private JComboBox cb_sb = new JComboBox<String>(new String[]{"1", "1.5", "2"});
    private JComboBox cb_p = new JComboBox<String>(new String[]{"NONE", "ODD", "EVEN", "MARK", "SPACE"});
    private String PortName = "";
    private int BaudRate = 9600;
    private int DataBits = 8;
    private int StopBits = 1;
    private String Parity = "NONE";
    private boolean PortChacked = false;
    private SerialPort SPort = null;
    private InputStream ins;
    private OutputStream outs;

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeBytes("PortName = " + this.PortName + "\n");
        randomAccessFile.writeBytes("BaudRate = " + this.BaudRate + "\n");
        randomAccessFile.writeBytes("DataBits = " + this.DataBits + "\n");
        randomAccessFile.writeBytes("StopBits = " + this.StopBits + "\n");
        randomAccessFile.writeBytes("Parity = " + this.Parity + "\n");
    }

    @Override
    public void parse(String string) {
        Object object;
        Object object2;
        super.parse(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object2 = stringTokenizer.nextToken();
                if (((String)(object2 = ((String)object2).trim())).length() == 0) continue;
                object = new StringTokenizer((String)object2, " =,\t");
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equalsIgnoreCase("PORTNAME")) {
                    try {
                        this.PortName = ((StringTokenizer)object).nextToken();
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("BAUNDRATE")) {
                    try {
                        this.BaudRate = Integer.parseInt(((StringTokenizer)object).nextToken());
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("DATABITS")) {
                    try {
                        this.DataBits = Integer.parseInt(((StringTokenizer)object).nextToken());
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("STOPBITS")) {
                    try {
                        this.StopBits = Integer.parseInt(((StringTokenizer)object).nextToken());
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    continue;
                }
                if (!string2.equalsIgnoreCase("PARITY")) continue;
                try {
                    this.Parity = ((StringTokenizer)object).nextToken();
                }
                catch (Exception exception) {
                    this.error(exception);
                }
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            this.error(exception);
        }
        object2 = new JPanel();
        object = new JPanel();
        ((JComponent)object2).setBackground(Color.YELLOW);
        ((JComponent)object).setBackground(Color.GREEN);
        this.panel_c.setLayout(new GridLayout(1, 2));
        this.panel_c.add((Component)object2);
        this.panel_c.add((Component)object);
    }

    public _dev_RS232() {
        this.ToolTipText = "RS-232";
        this.in = new double[1];
        for (int i = 0; i < this.in.length; ++i) {
            this.in[i] = Double.NaN;
        }
        this.in_text = new String[1];
        this.in_text[0] = "TxD";
        this.out = new double[1];
        this.out[0] = Double.NaN;
        this.out_text = new String[1];
        this.out_text[0] = "RxD";
        this.out_obj = new Object[1];
        this.out_obj_index = new int[1];
        this.w = 76;
        this.h = 36;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setBackground(Color.YELLOW);
        jPanel2.setBackground(Color.GREEN);
        this.panel_c.setLayout(new GridLayout(1, 2));
        this.panel_c.add(jPanel);
        this.panel_c.add(jPanel2);
    }

    @Override
    public void paint_info(Graphics graphics) {
        graphics.drawImage(this.img, 0, 0, this);
    }

    @Override
    public void calc_pre() {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(this.PortName);
            this.SPort = (SerialPort)commPortIdentifier.open(this.PortName, 2000);
            if (this.Parity.equalsIgnoreCase("NONE")) {
                this.SPort.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, 0);
            } else if (this.Parity.equalsIgnoreCase("ODD")) {
                this.SPort.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, 1);
            } else if (this.Parity.equalsIgnoreCase("EVEN")) {
                this.SPort.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, 2);
            } else if (this.Parity.equalsIgnoreCase("MARK")) {
                this.SPort.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, 3);
            } else if (this.Parity.equalsIgnoreCase("SPACE")) {
                this.SPort.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, 4);
            }
            this.ins = this.SPort.getInputStream();
            this.outs = this.SPort.getOutputStream();
            this.SPort.removeEventListener();
            this.SPort.addEventListener(this);
            this.SPort.notifyOnDataAvailable(true);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    @Override
    public void calc() {
        try {
            if (!Double.isInfinite(this.in[0])) {
                this.outs.write((int)this.in[0]);
                this.in[0] = Double.NaN;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void calc_post() {
        try {
            this.ins.close();
            this.outs.close();
            this.SPort.close();
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    @Override
    public void edit_pre() {
        Cloneable cloneable;
        if (!this.PortChacked) {
            String[] stringArray;
            cloneable = new Vector<String>();
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                if (stringArray.getPortType() != 1) continue;
                cloneable.addElement(stringArray.getName());
            }
            stringArray = new String[cloneable.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = cloneable.elementAt(i) + "";
            }
            this.cb_port.setModel(new DefaultComboBoxModel<String>(stringArray));
            this.PortChacked = true;
        }
        this.cb_port.setSelectedItem(this.PortName);
        this.cb_br.setSelectedItem(this.BaudRate + "");
        this.cb_db.setSelectedItem(this.DataBits + "");
        this.cb_sb.setSelectedItem(this.StopBits + "");
        this.cb_p.setSelectedItem(this.Parity);
        this.edit_panel = new JPanel(new GridBagLayout());
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Port") + ": "), cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).fill = 2;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)this.cb_port, cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).gridy = 1;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Baud_Rate") + ": "), cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 1;
        ((GridBagConstraints)cloneable).gridy = 1;
        ((GridBagConstraints)cloneable).fill = 2;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)this.cb_br, cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).gridy = 2;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Data_Bits") + ": "), cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 1;
        ((GridBagConstraints)cloneable).gridy = 2;
        ((GridBagConstraints)cloneable).fill = 2;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)this.cb_db, cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).gridy = 3;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Stop_Bits") + ": "), cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 1;
        ((GridBagConstraints)cloneable).gridy = 3;
        ((GridBagConstraints)cloneable).fill = 2;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)this.cb_sb, cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 0;
        ((GridBagConstraints)cloneable).gridy = 4;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)new JLabel(ResourceBundle.getBundle("JMCAD_Internationalize").getString("Parity") + ": "), cloneable);
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).gridx = 1;
        ((GridBagConstraints)cloneable).gridy = 4;
        ((GridBagConstraints)cloneable).fill = 2;
        ((GridBagConstraints)cloneable).anchor = 17;
        this.edit_panel.add((Component)this.cb_p, cloneable);
    }

    @Override
    public void edit_post() {
        try {
            this.PortName = this.cb_port.getSelectedItem() + "";
            this.BaudRate = Integer.parseInt(this.cb_br.getSelectedItem() + "");
            this.DataBits = Integer.parseInt(this.cb_db.getSelectedItem() + "");
            this.StopBits = Integer.parseInt(this.cb_sb.getSelectedItem() + "");
            this.Parity = this.cb_p.getSelectedItem() + "";
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    @Override
    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    int n;
                    while ((n = this.ins.read()) > -1) {
                        if (Double.isInfinite(n) || Double.isNaN(n)) continue;
                        ((JMCADObject)this.out_obj[0]).set(n, this.out_obj_index[0]);
                    }
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

