/*
 * Decompiled with CFR 0.152.
 */
package undo;

import java.util.NoSuchElementException;
import java.util.Vector;
import undo.UndoState;

public class UndoManager {
    private final Vector<UndoState> undoBuffer;
    private int pointer;
    private boolean isRedoable;

    public UndoManager(int size) {
        this.undoBuffer = new Vector(size);
        this.undoReset();
    }

    public void printUndoState() {
        System.out.println("===============================================");
        for (int i = 0; i < this.undoBuffer.size(); ++i) {
            if (i == this.pointer - 2) {
                System.out.println("*****************");
            }
            System.out.println("undoBuffer[" + i + "]=" + this.undoBuffer.get(i));
            if (i != this.pointer - 2) continue;
            System.out.println("*****************");
        }
        System.out.println("Is the next operation on a library? " + (this.isNextOperationOnALibrary() ? "Yes" : "No"));
    }

    public final void undoReset() {
        this.undoBuffer.removeAllElements();
        this.pointer = 0;
        this.isRedoable = false;
    }

    public void undoPush(UndoState state) {
        if (this.undoBuffer.size() == this.undoBuffer.capacity()) {
            this.undoBuffer.removeElementAt(0);
            --this.pointer;
        }
        this.undoBuffer.add(this.pointer++, state);
        this.isRedoable = false;
        for (int i = this.pointer; i < this.undoBuffer.size(); ++i) {
            this.undoBuffer.removeElementAt(this.pointer);
        }
    }

    public boolean isNextOperationOnALibrary() {
        if (this.pointer >= this.undoBuffer.size() || this.pointer < 1) {
            return false;
        }
        try {
            if (this.undoBuffer.get((int)this.pointer).libraryOperation) {
                return true;
            }
        }
        catch (NoSuchElementException E) {
            return false;
        }
        return false;
    }

    public UndoState undoPop() throws NoSuchElementException {
        --this.pointer;
        if (this.pointer < 1) {
            this.pointer = 1;
        }
        UndoState o = this.undoBuffer.get(this.pointer - 1);
        this.isRedoable = true;
        return o;
    }

    public UndoState undoRedo() throws NoSuchElementException {
        if (!this.isRedoable) {
            NoSuchElementException E = new NoSuchElementException();
            throw E;
        }
        ++this.pointer;
        if (this.pointer > this.undoBuffer.size()) {
            this.pointer = this.undoBuffer.size();
        }
        UndoState o = this.undoBuffer.get(this.pointer - 1);
        return o;
    }
}

