/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.librarymodel.utils;

import globals.FileUtils;
import globals.LibUtils;
import java.io.File;
import java.io.IOException;
import net.sourceforge.fidocadj.FidoFrame;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import undo.LibraryUndoListener;

public class LibraryUndoExecutor
implements LibraryUndoListener {
    FidoFrame fidoFrame;
    LibraryModel libraryModel;

    public LibraryUndoExecutor(FidoFrame frame, LibraryModel model) {
        this.fidoFrame = frame;
        this.libraryModel = model;
    }

    public void undoLibrary(String s) {
        try {
            File sourceDir = new File(s);
            String d = LibUtils.getLibDir();
            File destinationDir = new File(d);
            FileUtils.copyDirectory(sourceDir, destinationDir);
            this.fidoFrame.loadLibraries();
            this.libraryModel.forceUpdate();
        }
        catch (IOException e) {
            System.out.println("Cannot restore library directory contents.");
        }
    }
}

