/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import circuit.CircuitPanel;
import circuit.HasChangedListener;
import circuit.controllers.ContinuosMoveActions;
import circuit.controllers.CopyPasteActions;
import circuit.controllers.EditorActions;
import circuit.controllers.ParserActions;
import circuit.model.DrawingModel;
import clipboard.TextTransfer;
import dialogs.DialogAbout;
import dialogs.DialogExport;
import dialogs.DialogLayer;
import dialogs.DialogOptions;
import dialogs.DialogPrint;
import dialogs.DialogUtil;
import dialogs.EnterCircuitFrame;
import export.ExportGraphic;
import geom.MapCoordinates;
import globals.AccessResources;
import globals.Globals;
import globals.LibUtils;
import globals.Utf8ResourceBundle;
import graphic.PointG;
import graphic.swing.ColorSwing;
import graphic.swing.Graphics2DSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import layers.LayerDesc;
import layers.StandardLayers;
import net.sourceforge.fidocadj.FidoMain;
import net.sourceforge.fidocadj.OpenFile;
import net.sourceforge.fidocadj.RunExport;
import net.sourceforge.fidocadj.ScrollGestureRecognizer;
import net.sourceforge.fidocadj.layermodel.LayerModel;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import net.sourceforge.fidocadj.librarymodel.utils.CircuitPanelUpdater;
import net.sourceforge.fidocadj.librarymodel.utils.LibraryUndoExecutor;
import net.sourceforge.fidocadj.macropicker.MacroTree;
import toolbars.ToolbarTools;
import toolbars.ToolbarZoom;
import toolbars.ZoomToFitListener;

public class FidoFrame
extends JFrame
implements MenuListener,
ActionListener,
Printable,
DropTargetListener,
ZoomToFitListener,
HasChangedListener,
WindowFocusListener {
    public CircuitPanel CC;
    private JScrollPane SC;
    private LayerModel layerModel;
    private LibraryModel libraryModel;
    private String exportFileName;
    private String exportFormat;
    private boolean exportBlackWhite;
    private double exportUnitPerPixel;
    private double exportMagnification;
    private boolean printMirror;
    private boolean printFitToPage;
    private boolean printLandscape;
    public String openFileDirectory;
    public String libDirectory;
    public Preferences prefs;
    private ToolbarTools toolBar;
    private boolean textToolbar;
    private boolean smallIconsToolbar;
    private DropTarget dt;
    private JCheckBoxMenuItem optionMacroOrigin;
    public Locale currentLocale;
    public boolean runsAsApplication;
    private ScrollGestureRecognizer sgr;

    public Locale getLocale() {
        return this.currentLocale;
    }

    public FidoFrame(boolean appl, Locale loc) {
        super("FidoCadJ 0.24.4");
        this.runsAsApplication = appl;
        String systemLanguage = Locale.getDefault().getLanguage();
        if (loc == null) {
            this.currentLocale = new Locale(systemLanguage);
        } else {
            this.currentLocale = loc;
            System.out.println("Forced the locale to be: " + loc + " instead of: " + systemLanguage);
        }
        this.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        this.exportMagnification = 1.0;
        try {
            Globals.messages = new AccessResources(Utf8ResourceBundle.getBundle("MessagesBundle", this.currentLocale));
        }
        catch (MissingResourceException mre) {
            try {
                Globals.messages = new AccessResources(ResourceBundle.getBundle("MessagesBundle", new Locale("en", "US")));
                System.out.println("No locale available, sorry... interface will be in English");
            }
            catch (MissingResourceException mre1) {
                JOptionPane.showMessageDialog(null, "Unable to find language localization files: " + mre1);
                System.exit(1);
            }
        }
        Globals.useNativeFileDialogs = false;
        Globals.useMetaForMultipleSelection = false;
        if (System.getProperty("os.name").startsWith("Mac")) {
            Globals.shortcutKey = 4;
            Globals.useMetaForMultipleSelection = true;
            Globals.useNativeFileDialogs = true;
            Globals.okCancelWinOrder = false;
        } else {
            Globals.okCancelWinOrder = true;
            Globals.shortcutKey = 2;
        }
        DialogUtil.center(this, 0.75, 0.75, 800, 500);
        this.setDefaultCloseOperation(0);
        ++Globals.openWindowsNumber;
        Globals.openWindows.add(this);
        URL url = DialogAbout.class.getResource("program_icons/icona_fidocadj_128x128.png");
        if (url != null) {
            Image icon = Toolkit.getDefaultToolkit().getImage(url);
            this.setIconImage(icon);
        }
        if (this.runsAsApplication) {
            FidoMain fm = new FidoMain();
            this.prefs = Preferences.userNodeForPackage(fm.getClass());
            this.readPreferences();
        } else {
            this.libDirectory = System.getProperty("user.home");
            this.openFileDirectory = "";
            this.smallIconsToolbar = true;
            this.textToolbar = true;
            this.exportBlackWhite = false;
            this.exportFormat = "";
        }
        this.exportFileName = "";
        this.printMirror = false;
        this.printFitToPage = false;
        this.printLandscape = false;
    }

    public final void readPreferences() {
        this.libDirectory = this.prefs.get("DIR_LIBS", "");
        this.openFileDirectory = this.prefs.get("OPEN_DIR", "");
        this.smallIconsToolbar = this.prefs.get("SMALL_ICON_TOOLBAR", "true").equals("true");
        this.textToolbar = this.prefs.get("TEXT_TOOLBAR", "true").equals("true");
        this.exportFormat = this.prefs.get("EXPORT_FORMAT", "png");
        this.exportUnitPerPixel = Double.parseDouble(this.prefs.get("EXPORT_UNITPERPIXEL", "1"));
        this.exportMagnification = Double.parseDouble(this.prefs.get("EXPORT_MAGNIFICATION", "1"));
        this.exportBlackWhite = this.prefs.get("EXPORT_BW", "false").equals("true");
        Globals.lineWidth = Double.parseDouble(this.prefs.get("STROKE_SIZE_STRAIGHT", "0.5"));
        Globals.lineWidthCircles = Double.parseDouble(this.prefs.get("STROKE_SIZE_OVAL", "0.35"));
        Globals.diameterConnection = Double.parseDouble(this.prefs.get("CONNECTION_SIZE", "2.0"));
    }

    public void readGridSettings() {
        this.CC.getMapCoordinates().setXGridStep(Integer.parseInt(this.prefs.get("GRID_SIZE", "5")));
        this.CC.getMapCoordinates().setYGridStep(Integer.parseInt(this.prefs.get("GRID_SIZE", "5")));
    }

    public void readDrawingSettings() {
        CopyPasteActions cpa = this.CC.getCopyPasteActions();
        cpa.setShiftCopyPaste(this.prefs.get("SHIFT_CP", "true").equals("true"));
        ContinuosMoveActions eea = this.CC.getContinuosMoveActions();
        eea.PCB_pad_sizex = Integer.parseInt(this.prefs.get("PCB_pad_sizex", "10"));
        eea.PCB_pad_sizey = Integer.parseInt(this.prefs.get("PCB_pad_sizey", "10"));
        eea.PCB_pad_style = Integer.parseInt(this.prefs.get("PCB_pad_style", "0"));
        eea.PCB_pad_drill = Integer.parseInt(this.prefs.get("PCB_pad_drill", "5"));
        eea.PCB_thickness = Integer.parseInt(this.prefs.get("PCB_thickness", "5"));
    }

    public void loadLibraries() {
        boolean englishLibraries = !this.currentLocale.getLanguage().equals(new Locale("it", "", "").getLanguage());
        this.CC.P.resetLibrary();
        ParserActions pa = this.CC.getParserActions();
        if (this.runsAsApplication) {
            FidoMain.readLibrariesProbeDirectory(this.CC.P, englishLibraries, this.libDirectory);
        } else if (englishLibraries) {
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM_en.FCL"), "ihram");
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib_en.fcl"), "");
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB_en.fcl"), "pcb");
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica_en.fcl"), "elettrotecnica");
        } else {
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/IHRAM.FCL"), "ihram");
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/FCDstdlib.fcl"), "");
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/PCB.fcl"), "pcb");
            pa.loadLibraryInJar(FidoFrame.class.getResource("lib/elettrotecnica.fcl"), "elettrotecnica");
        }
        this.libraryModel.forceUpdate();
    }

    public void init() {
        Container contentPane = this.getContentPane();
        this.CC = new CircuitPanel(true);
        this.CC.getParserActions().openFileName = "";
        this.dt = new DropTarget(this.CC, this);
        if (this.runsAsApplication) {
            this.CC.setStrictCompatibility(this.prefs.get("FCJ_EXT_STRICT", "false").equals("true"));
            this.CC.P.setTextFont(this.prefs.get("MACRO_FONT", "Courier New"), Integer.parseInt(this.prefs.get("MACRO_SIZE", "3")), this.CC.getUndoActions());
            this.readGridSettings();
            this.readDrawingSettings();
        }
        this.CC.setPreferredSize(new Dimension(1000, 1000));
        this.CC.father = this.SC = new JScrollPane(this.CC);
        this.SC.setHorizontalScrollBarPolicy(32);
        this.SC.setVerticalScrollBarPolicy(22);
        if (this.runsAsApplication) {
            this.sgr = new ScrollGestureRecognizer();
            this.CC.addScrollGestureSelectionListener(this.sgr);
            FidoFrame fidoFrame = this;
            fidoFrame.sgr.getInstance();
        }
        this.SC.getVerticalScrollBar().setUnitIncrement(20);
        this.SC.getHorizontalScrollBar().setUnitIncrement(20);
        this.CC.profileTime = false;
        this.CC.antiAlias = true;
        Vector<LayerDesc> layerDesc = StandardLayers.createStandardLayers();
        this.CC.P.setLayers(layerDesc);
        this.toolBar = new ToolbarTools(this.textToolbar, this.smallIconsToolbar);
        ToolbarZoom toolZoom = new ToolbarZoom(layerDesc);
        this.toolBar.addSelectionListener(this.CC);
        toolZoom.addLayerListener(this.CC);
        toolZoom.addGridStateListener(this.CC);
        toolZoom.addZoomToFitListener(this);
        this.CC.addChangeZoomListener(toolZoom);
        this.CC.addChangeSelectionListener(this.toolBar);
        this.CC.getContinuosMoveActions().addChangeCoordinatesListener(toolZoom);
        toolZoom.addChangeZoomListener(this.CC);
        Box b = Box.createVerticalBox();
        b.add(this.toolBar);
        b.add(toolZoom);
        toolZoom.setFloatable(false);
        toolZoom.setRollover(false);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.CC.setSelectionState(1, "");
        JMenu fileMenu = new JMenu(Globals.messages.getString("File"));
        JMenuItem fileNew = new JMenuItem(Globals.messages.getString("New"));
        fileNew.setAccelerator(KeyStroke.getKeyStroke(78, Globals.shortcutKey));
        JMenuItem fileOpen = new JMenuItem(Globals.messages.getString("Open"));
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, Globals.shortcutKey));
        JMenuItem fileSave = new JMenuItem(Globals.messages.getString("Save"));
        fileSave.setAccelerator(KeyStroke.getKeyStroke(83, Globals.shortcutKey));
        JMenuItem fileSaveName = new JMenuItem(Globals.messages.getString("SaveName"));
        fileSaveName.setAccelerator(KeyStroke.getKeyStroke(83, Globals.shortcutKey | 1));
        JMenuItem fileSaveNameSplit = new JMenuItem(Globals.messages.getString("Save_split"));
        JMenuItem fileExport = new JMenuItem(Globals.messages.getString("Export"));
        fileExport.setAccelerator(KeyStroke.getKeyStroke(69, Globals.shortcutKey));
        JMenuItem filePrint = new JMenuItem(Globals.messages.getString("Print"));
        filePrint.setAccelerator(KeyStroke.getKeyStroke(80, Globals.shortcutKey));
        JMenuItem fileClose = new JMenuItem(Globals.messages.getString("Close"));
        fileClose.setAccelerator(KeyStroke.getKeyStroke(87, Globals.shortcutKey));
        JMenuItem options = new JMenuItem(Globals.messages.getString("Circ_opt"));
        fileMenu.add(fileNew);
        fileMenu.add(fileOpen);
        fileMenu.add(fileSave);
        fileMenu.add(fileSaveName);
        fileMenu.addSeparator();
        fileMenu.add(fileSaveNameSplit);
        fileMenu.addSeparator();
        fileMenu.add(fileExport);
        fileMenu.add(filePrint);
        fileMenu.addSeparator();
        if (!Globals.weAreOnAMac) {
            fileMenu.add(options);
            fileMenu.addSeparator();
        }
        fileMenu.add(fileClose);
        fileNew.addActionListener(this);
        fileOpen.addActionListener(this);
        fileExport.addActionListener(this);
        filePrint.addActionListener(this);
        fileClose.addActionListener(this);
        fileSave.addActionListener(this);
        fileSaveName.addActionListener(this);
        fileSaveNameSplit.addActionListener(this);
        options.addActionListener(this);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu(Globals.messages.getString("Edit_menu"));
        JMenuItem editUndo = new JMenuItem(Globals.messages.getString("Undo"));
        editUndo.setAccelerator(KeyStroke.getKeyStroke(90, Globals.shortcutKey));
        JMenuItem editRedo = new JMenuItem(Globals.messages.getString("Redo"));
        editRedo.setAccelerator(KeyStroke.getKeyStroke(90, Globals.shortcutKey | 1));
        JMenuItem editCut = new JMenuItem(Globals.messages.getString("Cut"));
        editCut.setAccelerator(KeyStroke.getKeyStroke(88, Globals.shortcutKey));
        JMenuItem editCopy = new JMenuItem(Globals.messages.getString("Copy"));
        editCopy.setAccelerator(KeyStroke.getKeyStroke(67, Globals.shortcutKey));
        JMenuItem editCopySplit = new JMenuItem(Globals.messages.getString("Copy_split"));
        editCopySplit.setAccelerator(KeyStroke.getKeyStroke(77, Globals.shortcutKey));
        JMenuItem editPaste = new JMenuItem(Globals.messages.getString("Paste"));
        editPaste.setAccelerator(KeyStroke.getKeyStroke(86, Globals.shortcutKey));
        JMenuItem clipboardCircuit = new JMenuItem(Globals.messages.getString("DefineClipboard"));
        JMenuItem editSelectAll = new JMenuItem(Globals.messages.getString("SelectAll"));
        editSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, Globals.shortcutKey));
        JMenuItem editRotate = new JMenuItem(Globals.messages.getString("Rotate"));
        editRotate.setAccelerator(KeyStroke.getKeyStroke("R"));
        JMenuItem editMirror = new JMenuItem(Globals.messages.getString("Mirror_E"));
        editMirror.setAccelerator(KeyStroke.getKeyStroke("S"));
        editUndo.addActionListener(this);
        editRedo.addActionListener(this);
        editCut.addActionListener(this);
        editCopy.addActionListener(this);
        editCopySplit.addActionListener(this);
        editPaste.addActionListener(this);
        editSelectAll.addActionListener(this);
        editMirror.addActionListener(this);
        editRotate.addActionListener(this);
        editMenu.add(editUndo);
        editMenu.add(editRedo);
        editMenu.addSeparator();
        editMenu.add(editCut);
        editMenu.add(editCopy);
        editMenu.add(editCopySplit);
        editMenu.add(editPaste);
        editMenu.add(clipboardCircuit);
        editMenu.addSeparator();
        editMenu.add(editSelectAll);
        editMenu.addSeparator();
        editMenu.add(editRotate);
        editMenu.add(editMirror);
        menuBar.add(editMenu);
        JMenu viewMenu = new JMenu(Globals.messages.getString("View"));
        JMenuItem layerOptions = new JMenuItem(Globals.messages.getString("Layer_opt"));
        layerOptions.setAccelerator(KeyStroke.getKeyStroke(76, Globals.shortcutKey));
        viewMenu.add(layerOptions);
        layerOptions.addActionListener(this);
        menuBar.add(viewMenu);
        JMenu circuitMenu = new JMenu(Globals.messages.getString("Circuit"));
        JMenuItem defineCircuit = new JMenuItem(Globals.messages.getString("Define"));
        defineCircuit.setAccelerator(KeyStroke.getKeyStroke(68, Globals.shortcutKey));
        circuitMenu.add(defineCircuit);
        JMenuItem updateLibraries = new JMenuItem(Globals.messages.getString("LibraryUpdate"));
        updateLibraries.setAccelerator(KeyStroke.getKeyStroke(85, Globals.shortcutKey));
        circuitMenu.add(updateLibraries);
        defineCircuit.addActionListener(this);
        updateLibraries.addActionListener(this);
        clipboardCircuit.addActionListener(this);
        menuBar.add(circuitMenu);
        JMenu about = new JMenu(Globals.messages.getString("About"));
        JMenuItem aboutMenu = new JMenuItem(Globals.messages.getString("About_menu"));
        about.add(aboutMenu);
        contentPane.add((Component)b, "North");
        if (!Globals.weAreOnAMac) {
            menuBar.add(about);
        }
        aboutMenu.addActionListener(this);
        this.libraryModel = new LibraryModel(this.CC.P);
        this.layerModel = new LayerModel(this.CC.P);
        MacroTree macroLib = new MacroTree(this.libraryModel, this.layerModel);
        macroLib.setSelectionListener(this.CC);
        this.libraryModel.setUndoActorListener(this.CC.getUndoActions());
        this.libraryModel.addLibraryListener(new CircuitPanelUpdater(this));
        this.CC.getUndoActions().setLibraryUndoListener(new LibraryUndoExecutor(this, this.libraryModel));
        try {
            LibUtils.saveLibraryState(this.CC.getUndoActions());
        }
        catch (IOException e) {
            System.out.println("Exception: " + e);
        }
        JSplitPane splitPane = new JSplitPane(1);
        Dimension windowSize = this.getSize();
        this.CC.setPreferredSize(new Dimension(windowSize.width * 85 / 100, 100));
        splitPane.setTopComponent(this.SC);
        macroLib.setPreferredSize(new Dimension(450, 200));
        splitPane.setBottomComponent(macroLib);
        splitPane.setResizeWeight(0.8);
        contentPane.add((Component)splitPane, "Center");
        this.CC.getUndoActions().setHasChangedListener(this);
        this.CC.setFocusable(true);
        this.SC.setFocusable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (!FidoFrame.this.checkIfToBeSaved()) {
                    return;
                }
                FidoFrame.this.setVisible(false);
                FidoFrame.this.CC.getUndoActions().doTheDishes();
                FidoFrame.this.dispose();
                Globals.openWindows.remove(FidoFrame.this);
                if (--Globals.openWindowsNumber < 1 && FidoFrame.this.runsAsApplication) {
                    System.exit(0);
                }
            }
        });
        this.addWindowFocusListener(this);
        Globals.activeWindow = this;
        this.CC.getUndoActions().setModified(false);
    }

    public boolean checkIfToBeSaved() {
        boolean shouldExit = true;
        if (this.CC.getUndoActions().getModified()) {
            int choice;
            Object[] options = new Object[]{Globals.messages.getString("Save"), Globals.messages.getString("Do_Not_Save"), Globals.messages.getString("Cancel_btn")};
            String filename = Globals.messages.getString("Warning");
            if (!"".equals(this.CC.getParserActions().openFileName)) {
                filename = this.CC.getParserActions().openFileName;
            }
            if ((choice = JOptionPane.showOptionDialog(this, Globals.messages.getString("Warning_unsaved"), Globals.prettifyPath(filename, 35), 1, 3, null, options, options[0])) == 0) {
                if (!this.save(false)) {
                    shouldExit = false;
                }
            } else if (choice == 2) {
                shouldExit = false;
            }
        }
        if (shouldExit) {
            this.CC.getUndoActions().doTheDishes();
        }
        return shouldExit;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JMenuItem) {
            String arg = evt.getActionCommand();
            EditorActions edt = this.CC.getEditorActions();
            CopyPasteActions cpa = this.CC.getCopyPasteActions();
            ContinuosMoveActions eea = this.CC.getContinuosMoveActions();
            if (arg.equals(Globals.messages.getString("Define"))) {
                EnterCircuitFrame circuitDialog = new EnterCircuitFrame(this, this.CC.getCirc(!this.CC.extStrict).toString());
                circuitDialog.setVisible(true);
                this.CC.setCirc(new StringBuffer(circuitDialog.getStringCircuit()));
                this.CC.getUndoActions().saveUndoState();
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("LibraryUpdate"))) {
                this.loadLibraries();
                this.show();
            }
            if (arg.equals(Globals.messages.getString("Circ_opt"))) {
                this.showPrefs();
            }
            if (arg.equals(Globals.messages.getString("Layer_opt"))) {
                DialogLayer layerDialog = new DialogLayer(this, this.CC.P.getLayers());
                layerDialog.setVisible(true);
                this.CC.P.setChanged(true);
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Print"))) {
                this.printDrawing();
            }
            if (arg.equals(Globals.messages.getString("SaveName"))) {
                this.saveWithName(false);
            }
            if (arg.equals(Globals.messages.getString("Save_split"))) {
                this.saveWithName(true);
            }
            if (arg.equals(Globals.messages.getString("Save"))) {
                this.save(false);
            }
            if (arg.equals(Globals.messages.getString("New"))) {
                this.createNewInstance();
            }
            if (arg.equals(Globals.messages.getString("Undo"))) {
                this.CC.getUndoActions().undo();
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Redo"))) {
                this.CC.getUndoActions().redo();
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("About_menu"))) {
                DialogAbout d = new DialogAbout(this);
                d.setVisible(true);
            }
            if (arg.equals(Globals.messages.getString("Open"))) {
                OpenFile openf = new OpenFile();
                openf.setParam(this);
                SwingUtilities.invokeLater(openf);
            }
            if (arg.equals(Globals.messages.getString("Export"))) {
                this.export();
            }
            if (arg.equals(Globals.messages.getString("SelectAll"))) {
                edt.setSelectionAll(true);
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Copy"))) {
                cpa.copySelected(!this.CC.extStrict, false, this.CC.getMapCoordinates().getXGridStep(), this.CC.getMapCoordinates().getYGridStep());
            }
            if (arg.equals(Globals.messages.getString("Copy_split"))) {
                cpa.copySelected(!this.CC.extStrict, true, this.CC.getMapCoordinates().getXGridStep(), this.CC.getMapCoordinates().getYGridStep());
            }
            if (arg.equals(Globals.messages.getString("Cut"))) {
                cpa.copySelected(!this.CC.extStrict, false, this.CC.getMapCoordinates().getXGridStep(), this.CC.getMapCoordinates().getYGridStep());
                edt.deleteAllSelected(true);
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Mirror_E"))) {
                if (eea.isEnteringMacro()) {
                    eea.mirrorMacro();
                } else {
                    edt.mirrorAllSelected();
                }
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Rotate"))) {
                if (eea.isEnteringMacro()) {
                    eea.rotateMacro();
                } else {
                    edt.rotateAllSelected();
                }
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("DefineClipboard"))) {
                TextTransfer textTransfer = new TextTransfer();
                FidoFrame popFrame = this.CC.getUndoActions().getModified() ? this.createNewInstance() : this;
                popFrame.CC.setCirc(new StringBuffer(textTransfer.getClipboardContents()));
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Paste"))) {
                cpa.paste(this.CC.getMapCoordinates().getXGridStep(), this.CC.getMapCoordinates().getYGridStep());
                this.repaint();
            }
            if (arg.equals(Globals.messages.getString("Close"))) {
                if (!this.checkIfToBeSaved()) {
                    return;
                }
                this.setVisible(false);
                this.CC.getUndoActions().doTheDishes();
                this.dispose();
                Globals.openWindows.remove(this);
                if (--Globals.openWindowsNumber < 1) {
                    System.exit(0);
                }
            }
        }
    }

    public void menuSelected(MenuEvent evt) {
    }

    public void menuDeselected(MenuEvent evt) {
    }

    public void menuCanceled(MenuEvent evt) {
    }

    public void printDrawing() {
        DialogPrint dp = new DialogPrint(this);
        dp.setMirror(this.printMirror);
        dp.setFit(this.printFitToPage);
        dp.setBW(this.exportBlackWhite);
        dp.setLandscape(this.printLandscape);
        dp.setVisible(true);
        this.printMirror = dp.getMirror();
        this.printFitToPage = dp.getFit();
        this.printLandscape = dp.getLandscape();
        this.exportBlackWhite = dp.getBW();
        Vector<LayerDesc> ol = this.CC.P.getLayers();
        if (dp.shouldPrint()) {
            if (this.exportBlackWhite) {
                Vector<LayerDesc> v = new Vector<LayerDesc>();
                for (int i = 0; i < 16; ++i) {
                    v.add(new LayerDesc(new ColorSwing(Color.black), ol.get(i).getVisible(), "B/W", ol.get(i).getAlpha()));
                }
                this.CC.P.setLayers(v);
            }
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(this);
            boolean ok = job.printDialog();
            if (ok) {
                try {
                    HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                    if (this.printLandscape) {
                        aset.add(OrientationRequested.LANDSCAPE);
                    } else {
                        aset.add(OrientationRequested.PORTRAIT);
                    }
                    job.print(aset);
                }
                catch (PrinterException ex) {
                    JOptionPane.showMessageDialog(this, Globals.messages.getString("Print_uncomplete"));
                }
            }
            this.CC.P.setLayers(ol);
        }
    }

    public void export() {
        DialogExport export = new DialogExport(this);
        export.setAntiAlias(true);
        export.setFormat(this.exportFormat);
        if ("".equals(this.exportFileName)) {
            this.exportFileName = this.openFileDirectory;
        }
        export.setFileName(this.exportFileName);
        export.setUnitPerPixel(this.exportUnitPerPixel);
        export.setBlackWhite(this.exportBlackWhite);
        export.setMagnification(this.exportMagnification);
        export.setVisible(true);
        if (export.shouldExport()) {
            int selection;
            this.exportFileName = export.getFileName();
            this.exportFormat = export.getFormat();
            this.exportUnitPerPixel = "png".equals(this.exportFormat) || "jpg".equals(this.exportFormat) ? export.getUnitPerPixel() : export.getMagnification();
            this.exportBlackWhite = export.getBlackWhite();
            this.exportMagnification = export.getMagnification();
            File f = new File(this.exportFileName);
            if (f.isDirectory()) {
                JOptionPane.showMessageDialog(null, Globals.messages.getString("Warning_noname"), Globals.messages.getString("Warning"), 1);
                return;
            }
            if (!Globals.checkExtension(this.exportFileName, this.exportFormat)) {
                selection = JOptionPane.showConfirmDialog(null, Globals.messages.getString("Warning_extension"), Globals.messages.getString("Warning"), 0, 2);
                if (selection == 0) {
                    this.exportFileName = Globals.adjustExtension(this.exportFileName, this.exportFormat);
                }
                f = new File(this.exportFileName);
            }
            if (f.exists() && (selection = JOptionPane.showConfirmDialog(null, Globals.messages.getString("Warning_overwrite"), Globals.messages.getString("Warning"), 2, 2)) != 0) {
                return;
            }
            RunExport doExport = new RunExport();
            doExport.setParam(new File(this.exportFileName), this.CC.P, this.exportFormat, this.exportUnitPerPixel, export.getAntiAlias(), this.exportBlackWhite, !this.CC.extStrict, this);
            SwingUtilities.invokeLater(doExport);
            this.prefs.put("EXPORT_FORMAT", this.exportFormat);
            this.prefs.put("EXPORT_UNITPERPIXEL", "" + this.exportUnitPerPixel);
            this.prefs.put("EXPORT_MAGNIFICATION", "" + this.exportMagnification);
            this.prefs.put("EXPORT_BW", this.exportBlackWhite ? "true" : "false");
        }
    }

    public FidoFrame createNewInstance() {
        FidoFrame popFrame = new FidoFrame(this.runsAsApplication, this.currentLocale);
        popFrame.init();
        popFrame.setBounds(this.getX() + 30, this.getY() + 30, popFrame.getWidth(), popFrame.getHeight());
        popFrame.loadLibraries();
        popFrame.setVisible(true);
        return popFrame;
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        int npages = 0;
        double xscale = 0.0625;
        double yscale = 0.0625;
        double zoom = 5.76;
        Graphics2D g2d = (Graphics2D)g;
        if (this.printMirror) {
            g2d.translate(pf.getImageableX() + pf.getImageableWidth(), pf.getImageableY());
            g2d.scale(-xscale, yscale);
        } else {
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g2d.scale(xscale, yscale);
        }
        int printerWidth = (int)pf.getImageableWidth() * 16;
        if (this.printFitToPage) {
            MapCoordinates zoomm = ExportGraphic.calculateZoomToFit(this.CC.P, (int)pf.getImageableWidth() * 16, (int)pf.getImageableHeight() * 16, false);
            zoom = zoomm.getXMagnitude();
        }
        MapCoordinates m = new MapCoordinates();
        m.setMagnitudes(zoom, zoom);
        PointG o = new PointG(0, 0);
        int imageWidth = ExportGraphic.getImageSize((DrawingModel)this.CC.P, (double)zoom, (boolean)false, (PointG)o).width;
        npages = (int)Math.floor((double)(imageWidth - 1) / (double)printerWidth);
        if (printerWidth < imageWidth) {
            g2d.translate(-(printerWidth * page), 0);
        }
        if (page > npages) {
            return 1;
        }
        this.CC.drawingAgent.draw(new Graphics2DSwing(g2d), m);
        return 0;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            if (flavors == null) {
                return;
            }
            for (int i = 0; i < flavors.length; ++i) {
                if (flavors[i] == null) {
                    return;
                }
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(3);
                    List list = (List)tr.getTransferData(flavors[i]);
                    FidoFrame popFrame = this.CC.getUndoActions().getModified() ? this.createNewInstance() : this;
                    popFrame.CC.getParserActions().openFileName = ((File)list.get(0)).getAbsolutePath();
                    popFrame.openFile();
                    dtde.dropComplete(true);
                    return;
                }
                if (flavors[i].isFlavorSerializedObjectType()) {
                    dtde.acceptDrop(3);
                    Object o = tr.getTransferData(flavors[i]);
                    FidoFrame popFrame = this.CC.getUndoActions().getModified() ? this.createNewInstance() : this;
                    popFrame.CC.setCirc(new StringBuffer(o.toString()));
                    popFrame.CC.getUndoActions().saveUndoState();
                    popFrame.CC.getUndoActions().setModified(false);
                    dtde.dropComplete(true);
                    popFrame.CC.repaint();
                    return;
                }
                if (!flavors[i].isRepresentationClassInputStream()) continue;
                dtde.acceptDrop(3);
                InputStreamReader reader = new InputStreamReader((InputStream)tr.getTransferData(flavors[i]));
                BufferedReader in = new BufferedReader(reader);
                String line = "";
                while (line != null) {
                    int k;
                    line = in.readLine();
                    if (line == null || (k = line.toString().indexOf("file://")) < 0) continue;
                    FidoFrame popFrame = this.CC.getUndoActions().getModified() ? this.createNewInstance() : this;
                    popFrame.CC.getParserActions().openFileName = line.toString().substring(k + 7);
                    popFrame.CC.getParserActions().openFileName = URLDecoder.decode(popFrame.CC.getParserActions().openFileName);
                    popFrame.openFile();
                    popFrame.CC.getUndoActions().saveUndoState();
                    popFrame.CC.getUndoActions().setModified(false);
                    break;
                }
                in.close();
                reader.close();
                this.CC.repaint();
                dtde.dropComplete(true);
                return;
            }
            System.out.println("Drop failed: " + dtde);
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public void openFile() throws IOException {
        BufferedReader bufRead = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.CC.getParserActions().openFileName), "UTF8"));
        StringBuffer txt = new StringBuffer();
        String line = bufRead.readLine();
        while (line != null) {
            txt.append(line);
            txt.append("\n");
            line = bufRead.readLine();
        }
        bufRead.close();
        this.CC.setCirc(new StringBuffer(txt.toString()));
        this.zoomToFit();
        this.CC.getUndoActions().saveUndoState();
        this.CC.getUndoActions().setModified(false);
        this.repaint();
    }

    boolean saveWithName(boolean splitNonStandardMacro_s) {
        String din;
        String fin;
        if (Globals.useNativeFileDialogs) {
            FileDialog fd = new FileDialog((Frame)this, Globals.messages.getString("SaveName"), 1);
            fd.setDirectory(this.openFileDirectory);
            fd.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase(FidoFrame.this.getLocale()).endsWith(".fcd");
                }
            });
            fd.setVisible(true);
            fin = fd.getFile();
            din = fd.getDirectory();
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".fcd") || f.isDirectory();
                }

                public String getDescription() {
                    return "FidoCadJ (.fcd)";
                }
            });
            fc.setCurrentDirectory(new File(this.openFileDirectory));
            fc.setDialogTitle(Globals.messages.getString("SaveName"));
            if (fc.showSaveDialog(this) != 0) {
                return false;
            }
            fin = fc.getSelectedFile().getName();
            din = fc.getSelectedFile().getParentFile().getPath();
        }
        if (fin == null) {
            return false;
        }
        this.CC.getParserActions().openFileName = Globals.createCompleteFileName(din, fin);
        this.CC.getParserActions().openFileName = Globals.adjustExtension(this.CC.getParserActions().openFileName, "fcd");
        if (this.runsAsApplication) {
            this.prefs.put("OPEN_DIR", din);
        }
        this.openFileDirectory = din;
        return this.save(splitNonStandardMacro_s);
    }

    boolean save(boolean splitNonStandardMacro_s) {
        if ("".equals(this.CC.getParserActions().openFileName)) {
            return this.saveWithName(splitNonStandardMacro_s);
        }
        try {
            if (splitNonStandardMacro_s) {
                ExportGraphic.export(new File(this.CC.getParserActions().openFileName), this.CC.P, "fcd", 1.0, true, false, !this.CC.extStrict, false);
                this.CC.getUndoActions().setModified(false);
            } else {
                BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.CC.getParserActions().openFileName), "UTF8"));
                output.write("[FIDOCAD]\n");
                output.write(this.CC.getCirc(!this.CC.extStrict).toString());
                output.close();
                this.CC.getUndoActions().setModified(false);
            }
        }
        catch (IOException fnfex) {
            JOptionPane.showMessageDialog(this, Globals.messages.getString("Save_error") + fnfex);
            return false;
        }
        return true;
    }

    void load(String s) {
        this.CC.getParserActions().openFileName = s;
        try {
            this.openFile();
        }
        catch (IOException fnfex) {
            JOptionPane.showMessageDialog(this, Globals.messages.getString("Open_error") + fnfex);
        }
    }

    void showPrefs() {
        String oldDirectory = this.libDirectory;
        CopyPasteActions cpa = this.CC.getCopyPasteActions();
        ContinuosMoveActions eea = this.CC.getContinuosMoveActions();
        DialogOptions options = new DialogOptions(this, this.CC.getMapCoordinates().getXMagnitude(), this.CC.profileTime, this.CC.antiAlias, this.CC.getMapCoordinates().getXGridStep(), this.libDirectory, this.textToolbar, this.smallIconsToolbar, eea.getPCB_thickness(), eea.getPCB_pad_sizex(), eea.getPCB_pad_sizey(), eea.getPCB_pad_drill(), Globals.quaquaActive, this.CC.getStrictCompatibility(), this.CC.P.getTextFont(), false, false, Globals.lineWidth, Globals.lineWidthCircles, Globals.diameterConnection, this.CC.P.getTextFontSize(), cpa.getShiftCopyPaste());
        options.setVisible(true);
        this.CC.profileTime = options.profileTime;
        this.CC.antiAlias = options.antiAlias;
        this.textToolbar = options.textToolbar;
        this.smallIconsToolbar = options.smallIconsToolbar;
        this.CC.getMapCoordinates().setMagnitudes(options.zoomValue, options.zoomValue);
        this.CC.getMapCoordinates().setXGridStep(options.gridSize);
        this.CC.getMapCoordinates().setYGridStep(options.gridSize);
        eea.setPCB_thickness(options.pcblinewidth_i);
        eea.setPCB_pad_sizex(options.pcbpadwidth_i);
        eea.setPCB_pad_sizey(options.pcbpadheight_i);
        eea.setPCB_pad_drill(options.pcbpadintw_i);
        this.CC.P.setTextFont(options.macroFont, options.macroSize_i, this.CC.getUndoActions());
        this.CC.setStrictCompatibility(options.extStrict);
        this.toolBar.setStrictCompatibility(options.extStrict);
        cpa.setShiftCopyPaste(options.shiftCP);
        Globals.quaquaActive = options.quaquaActive;
        this.libDirectory = options.libDirectory;
        Globals.lineWidth = options.stroke_size_straight_i;
        Globals.lineWidthCircles = options.stroke_size_straight_i;
        Globals.diameterConnection = options.connectionSize_i;
        if (this.runsAsApplication) {
            this.prefs.put("DIR_LIBS", this.libDirectory);
            this.prefs.put("MACRO_FONT", this.CC.P.getTextFont());
            this.prefs.put("MACRO_SIZE", "" + this.CC.P.getTextFontSize());
            this.prefs.put("STROKE_SIZE_STRAIGHT", "" + Globals.lineWidth);
            this.prefs.put("STROKE_SIZE_OVAL", "" + Globals.lineWidthCircles);
            this.prefs.put("CONNECTION_SIZE", "" + Globals.diameterConnection);
            this.prefs.put("SMALL_ICON_TOOLBAR", this.smallIconsToolbar ? "true" : "false");
            this.prefs.put("TEXT_TOOLBAR", this.textToolbar ? "true" : "false");
            this.prefs.put("QUAQUA", Globals.quaquaActive ? "true" : "false");
            this.prefs.put("FCJ_EXT_STRICT", this.CC.getStrictCompatibility() ? "true" : "false");
            this.prefs.put("GRID_SIZE", "" + this.CC.getMapCoordinates().getXGridStep());
            this.prefs.put("PCB_pad_sizex", "" + eea.PCB_pad_sizex);
            this.prefs.put("PCB_pad_sizey", "" + eea.PCB_pad_sizey);
            this.prefs.put("PCB_pad_style", "" + eea.PCB_pad_style);
            this.prefs.put("PCB_pad_drill", "" + eea.PCB_pad_drill);
            this.prefs.put("PCB_thickness", "" + eea.PCB_thickness);
            this.prefs.put("SHIFT_CP", cpa.getShiftCopyPaste() ? "true" : "false");
        }
        if (!this.libDirectory.equals(oldDirectory)) {
            this.loadLibraries();
            this.show();
        }
        this.repaint();
    }

    public void zoomToFit() {
        double oldz = this.CC.getMapCoordinates().getXMagnitude();
        MapCoordinates m = ExportGraphic.calculateZoomToFit(this.CC.P, this.SC.getViewport().getExtentSize().width - 35, this.SC.getViewport().getExtentSize().height - 35, true);
        double z = m.getXMagnitude();
        this.CC.getMapCoordinates().setMagnitudes(z, z);
        Rectangle r = new Rectangle((int)m.getXCenter(), (int)m.getYCenter(), this.SC.getViewport().getExtentSize().width, this.SC.getViewport().getExtentSize().height);
        this.CC.setScrollRectangle(r);
    }

    public void somethingHasChanged() {
        if (Globals.weAreOnAMac) {
            this.getRootPane().putClientProperty("Window.documentModified", this.CC.getUndoActions().getModified());
            this.getRootPane().putClientProperty("Window.documentFile", new File(this.CC.getParserActions().openFileName));
            this.setTitle("FidoCadJ 0.24.4 " + Globals.prettifyPath(this.CC.getParserActions().openFileName, 45) + (this.CC.getUndoActions().getModified() ? " *" : ""));
        } else {
            this.setTitle("FidoCadJ 0.24.4 " + Globals.prettifyPath(this.CC.getParserActions().openFileName, 45) + (this.CC.getUndoActions().getModified() ? " *" : ""));
        }
    }

    public void windowGainedFocus(WindowEvent e) {
        Globals.activeWindow = this;
    }

    public void windowLostFocus(WindowEvent e) {
    }
}

