/*
 * Decompiled with CFR 0.152.
 */
package graphic.swing;

import geom.MapCoordinates;
import globals.Globals;
import graphic.ColorInterface;
import graphic.GraphicsInterface;
import graphic.PolygonInterface;
import graphic.ShapeInterface;
import graphic.swing.ColorSwing;
import graphic.swing.PolygonSwing;
import graphic.swing.ShapeSwing;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import layers.LayerDesc;

public class Graphics2DSwing
implements GraphicsInterface {
    Graphics2D g;
    private BufferedImage bufferedImage;
    private double oldZoom;
    private TexturePaint tp;
    private int width;
    private int height;
    private BasicStroke[] strokeList;
    private BasicStroke stroke;
    private float actual_w;
    private AffineTransform at;
    private AffineTransform stretching;
    private AffineTransform ats;
    private Font f;
    private AffineTransform mm;

    public Graphics2DSwing(Graphics2D gg) {
        this.g = gg;
        this.oldZoom = -1.0;
    }

    public Graphics2DSwing(Graphics gg) {
        this.g = (Graphics2D)gg;
        this.oldZoom = -1.0;
    }

    public Graphics2DSwing() {
        this.g = null;
        this.oldZoom = -1.0;
    }

    public void applyStroke(float w, int dashStyle) {
        if (w != this.actual_w && w > 0.0f) {
            this.strokeList = new BasicStroke[5];
            this.strokeList[0] = new BasicStroke(w, 1, 1);
            for (int i = 1; i < 5; ++i) {
                this.strokeList[i] = new BasicStroke(w, 1, 1, 10.0f, Globals.dash[i], 0.0f);
            }
            this.actual_w = w;
        }
        this.stroke = this.strokeList[dashStyle];
        if (!this.stroke.equals(this.g.getStroke())) {
            this.g.setStroke(this.stroke);
        }
    }

    public void setGraphicContext(Graphics2D gg) {
        this.g = gg;
    }

    public Graphics2D getGraphicContext() {
        return this.g;
    }

    public void setColor(ColorInterface c) {
        ColorSwing cc = (ColorSwing)c;
        this.g.setColor(cc.getColorSwing());
    }

    public ColorInterface getColor() {
        return new ColorSwing(this.g.getColor());
    }

    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.g.hitClip(x, y, width, height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void setFont(String name, int size, boolean isItalic, boolean isBold) {
        this.f = new Font(name, 0 + (isItalic ? 2 : 0) + (isBold ? 1 : 0), size);
        if (!this.g.getFont().equals(this.f)) {
            this.g.setFont(this.f);
        }
    }

    public void setFont(String name, int size) {
        this.setFont(name, size, false, false);
    }

    public int getFontAscent() {
        FontMetrics fm = this.g.getFontMetrics(this.g.getFont());
        return fm.getAscent();
    }

    public int getFontDescent() {
        FontMetrics fm = this.g.getFontMetrics(this.g.getFont());
        return fm.getDescent();
    }

    public int getStringWidth(String s) {
        FontMetrics fm = this.g.getFontMetrics(this.g.getFont());
        return fm.stringWidth(s);
    }

    public void drawString(String str, int x, int y) {
        this.g.drawString(str, x, y);
    }

    public void setAlpha(float alpha) {
        this.g.setComposite(AlphaComposite.getInstance(3, alpha));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(x, y, width, height);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(x, y, width, height);
    }

    public void fill(ShapeInterface s) {
        ShapeSwing ss = (ShapeSwing)s;
        this.g.fill(ss.getShapeInSwing());
    }

    public void draw(ShapeInterface s) {
        ShapeSwing ss = (ShapeSwing)s;
        this.g.draw(ss.getShapeInSwing());
    }

    public void fillPolygon(PolygonInterface p) {
        PolygonSwing pp = (PolygonSwing)p;
        this.g.fillPolygon(pp.getSwingPolygon());
    }

    public void drawPolygon(PolygonInterface p) {
        PolygonSwing pp = (PolygonSwing)p;
        this.g.drawPolygon(pp.getSwingPolygon());
    }

    public void activateSelectColor(LayerDesc l) {
        if (l == null) {
            this.g.setColor(Color.green);
        } else {
            ColorSwing c = (ColorSwing)l.getColor();
            this.g.setColor(Graphics2DSwing.blendColors(Color.green, c.getColorSwing(), 0.6f));
        }
        this.g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public static Color blendColors(Color color1, Color color2, float r) {
        float ir = 1.0f - r;
        float[] rgb1 = new float[3];
        float[] rgb2 = new float[3];
        color1.getColorComponents(rgb1);
        color2.getColorComponents(rgb2);
        Color color = new Color(rgb1[0] * r + rgb2[0] * ir, rgb1[1] * r + rgb2[1] * ir, rgb1[2] * r + rgb2[2] * ir);
        return color;
    }

    public void drawAdvText(double xyfactor, int xa, int ya, int qq, int h, int w, int th, boolean needsStretching, int orientation, boolean mirror, String txt) {
        AffineTransform at = (AffineTransform)this.g.getTransform().clone();
        AffineTransform ats = (AffineTransform)at.clone();
        AffineTransform stretching = new AffineTransform();
        AffineTransform mm = new AffineTransform();
        stretching.scale(1.0, xyfactor);
        if (mirror) {
            mm.scale(-1.0, 1.0);
        }
        if (orientation == 0) {
            if (mirror) {
                at.scale(-1.0, xyfactor);
                this.g.setTransform(at);
                if (this.g.hitClip(-xa, qq, w, h)) {
                    if (!this.g.getFont().equals(this.f)) {
                        this.g.setFont(this.f);
                    }
                    this.g.drawString(txt, -xa, qq + h);
                }
            } else {
                if (needsStretching) {
                    at.concatenate(stretching);
                    this.g.setTransform(at);
                }
                if (this.g.hitClip(xa, qq, w, th)) {
                    if (th < 4) {
                        this.g.drawLine(xa, qq, xa + w, qq);
                        if (needsStretching) {
                            this.g.setTransform(ats);
                        }
                        return;
                    }
                    if (!this.g.getFont().equals(this.f)) {
                        this.g.setFont(this.f);
                    }
                    this.g.drawString(txt, xa, qq + h);
                    if (needsStretching) {
                        this.g.setTransform(ats);
                    }
                    return;
                }
            }
        } else if (mirror) {
            at.concatenate(mm);
            at.rotate(Math.toRadians(orientation), -xa, ya);
            if (needsStretching) {
                at.concatenate(stretching);
            }
            this.g.setTransform(at);
            if (!this.g.getFont().equals(this.f)) {
                this.g.setFont(this.f);
            }
            this.g.drawString(txt, -xa, qq + h);
        } else {
            at.rotate(Math.toRadians(-orientation), xa, ya);
            if (needsStretching) {
                at.concatenate(stretching);
            }
            this.g.setTransform(at);
            if (!this.g.getFont().equals(this.f)) {
                this.g.setFont(this.f);
            }
            this.g.drawString(txt, xa, qq + h);
        }
        this.g.setTransform(ats);
    }

    public void drawGrid(MapCoordinates cs, int xmin, int ymin, int xmax, int ymax) {
        int dx = cs.getXGridStep();
        int dy = cs.getYGridStep();
        int mul = 1;
        double toll = 0.01;
        double z = cs.getYMagnitude();
        double m = 1.0;
        if (this.oldZoom != z || this.bufferedImage == null || this.tp == null) {
            for (double l = 1.0; l < 105.0; l += 1.0) {
                if (!(Math.abs(l * z - (double)Math.round(l * z)) < toll)) continue;
                mul = (int)l;
                break;
            }
            this.tp = null;
            double ddx = Math.abs(cs.mapXi(dx, 0.0, false) - cs.mapXi(0.0, 0.0, false));
            double ddy = Math.abs(cs.mapYi(0.0, dy, false) - cs.mapYi(0.0, 0.0, false));
            int d = 1;
            if (ddx > 50.0 || ddy > 50.0) {
                d = 2;
            } else if (ddx < 3.0 || ddy < 3.0) {
                dx = 5 * cs.getXGridStep();
                dy = 5 * cs.getYGridStep();
                ddx = Math.abs(cs.mapXi(dx, 0.0, false) - cs.mapXi(0.0, 0.0, false));
            }
            this.width = Math.abs(cs.mapX(mul * dx, 0.0) - cs.mapX(0.0, 0.0));
            if (this.width <= 0) {
                this.width = 1;
            }
            this.height = Math.abs(cs.mapY(0.0, 0.0) - cs.mapY(0.0, mul * dy));
            if (this.height <= 0) {
                this.height = 1;
            }
            if (this.width > 1000 || this.height > 1000) {
                this.g.setColor(Color.white);
                this.g.fillRect(xmin, ymin, xmax, ymax);
                this.g.setColor(Color.gray);
                for (double x = (double)cs.unmapXsnap(xmin); x <= (double)cs.unmapXsnap(xmax); x += (double)dx) {
                    for (double y = (double)cs.unmapYsnap(ymin); y <= (double)cs.unmapYsnap(ymax); y += (double)dy) {
                        this.g.fillRect(cs.mapXi((int)x, (int)y, false), cs.mapYi((int)x, (int)y, false), d, d);
                    }
                }
                return;
            }
            try {
                this.bufferedImage = new BufferedImage(this.width, this.height, 4);
            }
            catch (OutOfMemoryError E) {
                System.out.println("Out of memory error when painting grid");
                return;
            }
            Graphics2D g2d = this.bufferedImage.createGraphics();
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, this.width, this.height);
            g2d.setColor(Color.gray);
            for (double x = 0.0; x <= (double)cs.unmapXsnap(this.width); x += (double)dx) {
                for (double y = 0.0; y <= (double)cs.unmapYsnap(this.height); y += (double)dy) {
                    g2d.fillRect(cs.mapX((int)x, (int)y), cs.mapY((int)x, (int)y), d, d);
                }
            }
            this.oldZoom = z;
            Rectangle anchor = new Rectangle(this.width, this.height);
            this.tp = new TexturePaint(this.bufferedImage, anchor);
        }
        this.g.setPaint(this.tp);
        this.g.fillRect(0, 0, xmax, ymax);
    }

    public PolygonInterface createPolygon() {
        return new PolygonSwing();
    }

    public ShapeInterface createShape() {
        return new ShapeSwing();
    }

    public ColorInterface createColor() {
        return new ColorSwing(this.g.getColor());
    }
}

