/*
 * Decompiled with CFR 0.152.
 */
package export;

import export.ExportInterface;
import graphic.ColorInterface;
import graphic.DimensionG;
import graphic.PointDouble;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import layers.LayerDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPGF
implements ExportInterface {
    private final FileWriter fstream;
    private BufferedWriter out;
    private Vector layerV;
    private ColorInterface actualColor = null;
    private int actualDash;
    private double actualWidth;
    static final String[] dash = new String[]{"{5.0pt}{10pt}", "{2.5pt}{2.5pt}", "{1.0pt}{1.0pt}", "{1.0pt}{2.5pt}", "{1.0pt}{2.5pt}{2.5pt}{2.5pt}"};

    public ExportPGF(File f) throws IOException {
        this.fstream = new FileWriter(f);
    }

    @Override
    public void exportStart(DimensionG totalSize, Vector<LayerDesc> la, int grid) throws IOException {
        this.layerV = la;
        this.out = new BufferedWriter(this.fstream);
        int wi = totalSize.width;
        int he = totalSize.height;
        this.out.write("\\begin{pgfpicture}{0cm}{0cm}{" + wi + "pt}{" + he + "pt}\n" + "% Created by FidoCadJ ver. " + "0.24.4" + ", export filter by Davide Bucci\n");
        this.out.write("\\pgfsetxvec{\\pgfpoint{1pt}{0pt}}\n");
        this.out.write("\\pgfsetyvec{\\pgfpoint{0pt}{1pt}}\n");
        this.out.write("\\pgfsetroundjoin \n\\pgfsetroundcap\n");
        this.out.write("\\pgftranslateto{\\pgfxy(0," + he + ")}\n");
        this.out.write("\\begin{pgfmagnify}{1}{-1}\n");
        this.out.write("% Layer color definitions\n");
        for (int i = 0; i < this.layerV.size(); ++i) {
            LayerDesc l = (LayerDesc)this.layerV.get(i);
            ColorInterface c = l.getColor();
            this.out.write("\\definecolor{layer" + i + "}{rgb}{" + (double)Math.round(100.0 * (double)c.getRed() / 255.0) / 100.0 + "," + (double)Math.round(100.0 * (double)c.getGreen() / 255.0) / 100.0 + "," + (double)Math.round(100.0 * (double)c.getBlue() / 255.0) / 100.0 + "}\n");
        }
        this.out.write("% End of color definitions\n");
        this.actualColor = null;
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write("\\end{pgfmagnify}\n");
        this.out.write("\\end{pgfpicture}");
        this.out.close();
    }

    @Override
    public void exportAdvText(int x, int y, int sizex, int sizey, String fontname, boolean isBold, boolean isMirrored, boolean isItalic, int orientation, int layer, String text) throws IOException {
        this.registerColorSize(layer, -1.0);
        this.out.write("\\begin{pgfmagnify}{1}{-1}\n");
        this.out.write("\\pgfputat{\\pgfxy(" + x + "," + -y + ")}{\\pgfbox[left,top]{");
        this.out.write(text);
        this.out.write("}}\n");
        this.out.write("\\end{pgfmagnify}\n");
    }

    @Override
    public void exportBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        this.registerColorSize(layer, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("\\pgfmoveto{\\pgfxy(" + x1 + "," + y1 + ")} \n" + "\\pgfcurveto{\\pgfxy(" + x2 + "," + y2 + ")}{\\pgfxy(" + x3 + "," + y3 + ")}{\\pgfxy(" + x4 + "," + y4 + ")}\n" + "\\pgfstroke\n");
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x4, y4, x3, y3, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    @Override
    public void exportConnection(int x, int y, int layer, double node_size) throws IOException {
        this.registerColorSize(layer, 0.33);
        this.out.write("\\pgfcircle[fill]{\\pgfxy(" + x + "," + y + ")}{" + node_size / 2.0 + "pt}");
    }

    @Override
    public void exportLine(double x1, double y1, double x2, double y2, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        this.registerColorSize(layer, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("\\pgfline{\\pgfxy(" + x1 + "," + y1 + ")}{\\pgfxy(" + x2 + "," + y2 + ")}\n");
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x2, y2, x1, y1, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    @Override
    public void exportArrow(double x, double y, double xc, double yc, double l, double h, int style) throws IOException {
        double alpha = x == xc ? 1.5707963267948966 + (y - yc < 0.0 ? 0.0 : Math.PI) : Math.atan((y - yc) / (x - xc));
        double x0 = x - l * Math.cos(alpha += x - xc > 0.0 ? 0.0 : Math.PI);
        double y0 = y - l * Math.sin(alpha);
        double x1 = x0 - h * Math.sin(alpha);
        double y1 = y0 + h * Math.cos(alpha);
        double x2 = x0 + h * Math.sin(alpha);
        double y2 = y0 - h * Math.cos(alpha);
        this.registerDash(0);
        this.out.write("\\pgfmoveto{\\pgfxy(" + x + "," + y + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + x1 + "," + y1 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + x2 + "," + y2 + ")}\n");
        this.out.write("\\pgfclosepath \n");
        if ((style & 2) == 0) {
            this.out.write("\\pgffill \n");
        } else {
            this.out.write("\\pgfqstroke \n");
        }
        if ((style & 1) != 0) {
            double x3 = x - h * Math.sin(alpha);
            double y3 = y + h * Math.cos(alpha);
            double x4 = x + h * Math.sin(alpha);
            double y4 = y - h * Math.cos(alpha);
            this.out.write("\\pgfline{\\pgfxy(" + x3 + "," + y3 + ")}{\\pgfxy(" + x4 + "," + y4 + ")}\n");
        }
    }

    public boolean exportMacro(int x, int y, boolean isMirrored, int orientation, String macroName, String macroDesc, String name, int xn, int yn, String value, int xv, int yv, String font, int fontSize, Map m) throws IOException {
        return false;
    }

    @Override
    public void exportOval(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        this.registerColorSize(layer, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("\\pgfellipse[" + (isFilled ? "fillstroke" : "stroke") + "]{\\pgfxy(" + (double)(x1 + x2) / 2.0 + "," + (double)(y1 + y2) / 2.0 + ")}{\\pgfxy(" + (double)Math.abs(x2 - x1) / 2.0 + ",0)}{\\pgfxy(0," + (double)Math.abs(y2 - y1) / 2.0 + ")}\n");
    }

    @Override
    public void exportPCBLine(int x1, int y1, int x2, int y2, int width, int layer) throws IOException {
        this.registerColorSize(layer, width);
        this.registerDash(0);
        this.out.write("\\pgfline{\\pgfxy(" + x1 + "," + y1 + ")}{\\pgfxy(" + x2 + "," + y2 + ")}\n");
    }

    @Override
    public void exportPCBPad(int x, int y, int style, int six, int siy, int indiam, int layer, boolean onlyHole) throws IOException {
        if (onlyHole) {
            if (!this.actualColor.equals(this.actualColor.white())) {
                this.actualColor = this.actualColor.white();
                this.out.write("\\color{white}\n");
            }
            this.out.write("\\pgfellipse[fillstroke]{\\pgfxy(" + x + "," + y + ")}{\\pgfxy(" + indiam / 2 + ",0)}{\\pgfxy(0," + indiam / 2 + ")}\n");
        } else {
            this.registerColorSize(layer, 0.33);
            switch (style) {
                case 1: {
                    double xdd = (double)x - (double)six / 2.0;
                    double ydd = (double)y - (double)siy / 2.0;
                    this.out.write("\\pgfrect[fillstroke]{\\pgfxy(" + xdd + "," + ydd + ")}{\\pgfxy(" + six + "," + siy + ")}\n");
                    break;
                }
                case 2: {
                    double xdd = (double)x - (double)six / 2.0;
                    double ydd = (double)y - (double)siy / 2.0;
                    this.out.write("\\pgfrect[fillstroke]{\\pgfxy(" + xdd + "," + ydd + ")}{\\pgfxy(" + six + "," + siy + ")}\n");
                    break;
                }
                default: {
                    this.out.write("\\pgfellipse[fillstroke]{\\pgfxy(" + x + "," + y + ")}{\\pgfxy(" + (double)six / 2.0 + ",0)}{\\pgfxy(0," + (double)siy / 2.0 + ")}\n");
                }
            }
        }
    }

    @Override
    public void exportPolygon(PointDouble[] vertices, int nVertices, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        this.registerColorSize(layer, strokeWidth);
        this.registerDash(dashStyle);
        String fill_pattern = "";
        this.out.write("\\pgfmoveto{\\pgfxy(" + vertices[0].x + "," + vertices[0].y + ")}\n");
        for (int i = 1; i < nVertices; ++i) {
            this.out.write("\\pgflineto{\\pgfxy(" + vertices[i].x + "," + vertices[i].y + ")}\n");
        }
        this.out.write("\\pgfclosepath \n");
        if (isFilled) {
            this.out.write("\\pgffill \n");
        } else {
            this.out.write("\\pgfqstroke \n");
        }
    }

    @Override
    public boolean exportCurve(PointDouble[] vertices, int nVertices, boolean isFilled, boolean isClosed, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        return false;
    }

    @Override
    public void exportRectangle(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        this.registerColorSize(layer, strokeWidth);
        this.registerDash(dashStyle);
        this.out.write("\\pgfmoveto{\\pgfxy(" + x1 + "," + y1 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + x2 + "," + y1 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + x2 + "," + y2 + ")}\n");
        this.out.write("\\pgflineto{\\pgfxy(" + x1 + "," + y2 + ")}\n");
        this.out.write("\\pgfclosepath \n");
        if (isFilled) {
            this.out.write("\\pgffill \n");
        } else {
            this.out.write("\\pgfqstroke \n");
        }
    }

    private void registerColorSize(int layer, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        ColorInterface c = l.getColor();
        if (!c.equals(this.actualColor)) {
            this.actualColor = c;
            this.out.write("\\color{layer" + layer + "}\n");
        }
        if (strokeWidth > 0.0 && this.actualWidth != strokeWidth) {
            this.out.write("\\pgfsetlinewidth{" + strokeWidth + "pt}\n");
            this.actualWidth = strokeWidth;
        }
    }

    private void registerDash(int dashStyle) throws IOException {
        if (this.actualDash != dashStyle) {
            this.actualDash = dashStyle;
            if (dashStyle == 0) {
                this.out.write("\\pgfsetdash{}{0pt}\n");
            } else {
                this.out.write("\\pgfsetdash{" + dash[dashStyle] + "}{0pt}\n");
            }
        }
    }
}

