/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import circuit.CircuitPanel;
import circuit.controllers.EditorActions;
import circuit.controllers.ParserActions;
import circuit.model.DrawingModel;
import dialogs.DialogUtil;
import export.ExportGraphic;
import geom.MapCoordinates;
import globals.Globals;
import globals.LibUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import primitives.GraphicPrimitive;
import primitives.MacroDesc;

public class DialogSymbolize
extends JDialog
implements ComponentListener,
ActionListener {
    private static final int MIN_WIDTH = 350;
    private static final int MIN_HEIGHT = 250;
    private final JPanel parent;
    private DrawingModel cp;
    private JComboBox<String> libFilename;
    private JTextField libName;
    private JTextField name;
    private JTextField key;
    private JComboBox<String> group;
    private JCheckBox snapToGrid;
    myCircuitPanel cpanel = new myCircuitPanel(false);

    public String getLibraryName() {
        String s = this.libName.getText();
        return s.trim();
    }

    public String getMacroName() {
        return this.name.getText();
    }

    public String getPrefix() {
        return this.libFilename.getEditor().getItem().toString();
    }

    public String getGroup() {
        return this.group.getEditor().getItem().toString();
    }

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 350) {
            resize = true;
            width = 350;
        }
        if (height < 250) {
            resize = true;
            height = 250;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private void enumLibs() {
        this.libFilename.removeAllItems();
        LinkedList<String> lst = new LinkedList<String>();
        Map<String, MacroDesc> m = this.cpanel.P.getLibrary();
        for (Map.Entry<String, MacroDesc> e : m.entrySet()) {
            MacroDesc md = e.getValue();
            if (lst.contains(md.filename) || LibUtils.isStdLib(md)) continue;
            this.libFilename.addItem(md.filename);
            lst.add(md.filename);
        }
        if (((DefaultComboBoxModel)this.libFilename.getModel()).getSize() == 0) {
            this.libFilename.addItem("user_lib");
        }
        this.libFilename.setEditable(true);
    }

    private JPanel createInterfacePanel() {
        JPanel panel = new JPanel();
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(bgl);
        JLabel libraryLabel = new JLabel(Globals.messages.getString("Library_file"));
        constraints = DialogUtil.createConst(1, 0, 1, 1, 0, 0, 13, 0, new Insets(6, 0, 0, 0));
        panel.add((Component)libraryLabel, constraints);
        this.libFilename = new JComboBox();
        Object e = null;
        constraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        panel.add(this.libFilename, constraints);
        JLabel libraryNameLabel = new JLabel(Globals.messages.getString("Library_name"));
        constraints = DialogUtil.createConst(1, 1, 1, 1, 0, 0, 13, 0, new Insets(6, 0, 0, 0));
        panel.add((Component)libraryNameLabel, constraints);
        this.libName = new JTextField();
        constraints = DialogUtil.createConst(2, 1, 1, 1, 0, 0, 13, 1, new Insets(6, 0, 0, 0));
        panel.add((Component)this.libName, constraints);
        MouseAdapter ma = new MouseAdapter(){
            boolean grid = false;

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    this.grid = !this.grid;
                    DialogSymbolize.this.cpanel.setGridVisibility(this.grid);
                    DialogSymbolize.this.cpanel.repaint();
                } else {
                    this.mouseDragged(e);
                }
            }

            public void mouseDragged(MouseEvent evt) {
                int x = evt.getX();
                int y = evt.getY();
                if (DialogSymbolize.this.snapToGrid.isSelected()) {
                    DialogSymbolize.this.cpanel.xl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapXsnap(x);
                    DialogSymbolize.this.cpanel.yl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapYsnap(y);
                } else {
                    DialogSymbolize.this.cpanel.xl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapXnosnap(x);
                    DialogSymbolize.this.cpanel.yl = DialogSymbolize.this.cpanel.getMapCoordinates().unmapYnosnap(y);
                }
                x = DialogSymbolize.this.cpanel.getMapCoordinates().mapXi(DialogSymbolize.this.cpanel.xl, DialogSymbolize.this.cpanel.yl, false);
                y = DialogSymbolize.this.cpanel.getMapCoordinates().mapYi(DialogSymbolize.this.cpanel.xl, DialogSymbolize.this.cpanel.yl, false);
                DialogSymbolize.this.cpanel.setDx(x);
                DialogSymbolize.this.cpanel.setDy(y);
                DialogSymbolize.this.cpanel.repaint();
            }
        };
        this.cpanel.addMouseListener(ma);
        this.cpanel.addMouseMotionListener(ma);
        this.cpanel.setSize(256, 256);
        this.cpanel.setPreferredSize(new Dimension(256, 256));
        this.cpanel.add(Box.createVerticalStrut(256));
        this.cpanel.add(Box.createHorizontalStrut(256));
        this.cpanel.P.setLayers(this.cp.getLayers());
        this.cpanel.P.setLibrary(this.cp.getLibrary());
        this.enumLibs();
        this.cpanel.antiAlias = true;
        this.cpanel.profileTime = false;
        MacroDesc macro = this.buildMacro("temp", "temp", "temp", "temp", "temp", new Point(100, 100));
        this.cpanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.cpanel.getParserActions().addString(new StringBuffer(macro.description), false);
        MapCoordinates m = ExportGraphic.calculateZoomToFit(this.cpanel.P, this.cpanel.getSize().width * 80 / 100, this.cpanel.getSize().height * 80 / 100, true);
        m.setXCenter(-m.getXCenter() + 10.0);
        m.setYCenter(-m.getYCenter() + 10.0);
        this.cpanel.setMapCoordinates(m);
        this.cpanel.resetOrigin();
        constraints = DialogUtil.createConst(3, 0, 8, 8, 100, 100, 10, 1, new Insets(6, 6, 6, 6));
        panel.add((Component)this.cpanel, constraints);
        JLabel groupLabel = new JLabel(Globals.messages.getString("Group"));
        constraints = DialogUtil.createConst(1, 3, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 0, 0));
        panel.add((Component)groupLabel, constraints);
        this.group = new JComboBox();
        this.listGroups();
        if (this.group.getItemCount() == 0) {
            this.group.addItem(Globals.messages.getString("Group").toLowerCase());
        }
        this.group.setEditable(true);
        this.libFilename.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                DialogSymbolize.this.listGroups();
            }
        });
        this.libFilename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DialogSymbolize.this.listGroups();
            }
        });
        constraints = DialogUtil.createConst(2, 3, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 0, 0));
        panel.add(this.group, constraints);
        JLabel nameLabel = new JLabel(Globals.messages.getString("Name"));
        constraints = DialogUtil.createConst(1, 4, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 12, 0));
        panel.add((Component)nameLabel, constraints);
        this.name = new JTextField();
        this.name.setText(Globals.messages.getString("Name").toLowerCase());
        constraints = DialogUtil.createConst(2, 4, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 12, 0));
        panel.add((Component)this.name, constraints);
        JLabel nameLabel1 = new JLabel(Globals.messages.getString("Key"));
        constraints = DialogUtil.createConst(1, 5, 1, 1, 0, 0, 13, 0, new Insets(6, 40, 12, 0));
        panel.add((Component)nameLabel1, constraints);
        this.key = new JTextField();
        long t = System.nanoTime();
        long h = 0L;
        int i = 0;
        while (t > 0L) {
            h ^= (t >>= i * 8) & 0xFFL;
            ++i;
        }
        this.key.setText(String.valueOf(h));
        constraints = DialogUtil.createConst(2, 5, 1, 1, 100, 100, 10, 2, new Insets(6, 0, 12, 0));
        panel.add((Component)this.key, constraints);
        this.snapToGrid = new JCheckBox(Globals.messages.getString("SnapToGridOrigin"));
        constraints = DialogUtil.createConst(2, 6, 1, 1, 0, 0, 17, 0, new Insets(6, 0, 0, 0));
        panel.add((Component)this.snapToGrid, constraints);
        if (Globals.lastCLib != null) {
            this.libFilename.setSelectedItem(Globals.lastCLib);
        }
        if (Globals.lastCGrp != null) {
            this.group.setSelectedItem(Globals.lastCGrp);
        }
        this.libFilename.getEditor().selectAll();
        return panel;
    }

    private void listGroups() {
        List<String> l = LibUtils.enumGroups(this.cp.getLibrary(), this.libFilename.getEditor().getItem().toString());
        this.group.removeAllItems();
        for (String s : l) {
            this.group.addItem(s);
        }
        this.libName.setText(LibUtils.getLibName(this.cp.getLibrary(), this.libFilename.getEditor().getItem().toString()));
    }

    public void actionPerformed(ActionEvent evt) {
    }

    public DialogSymbolize(CircuitPanel circuitPanel, DrawingModel p) {
        super((Frame)null, Globals.messages.getString("SaveSymbol"), true);
        this.parent = circuitPanel;
        this.addComponentListener(this);
        GridBagLayout bgl = new GridBagLayout();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(bgl);
        GridBagConstraints constraints = DialogUtil.createConst(2, 0, 1, 1, 100, 100, 17, 2, new Insets(12, 0, 0, 20));
        this.setCircuit(p);
        JPanel panel = this.createInterfacePanel();
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(20, 20, 20, 20);
        contentPane.add((Component)panel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        constraints.insets = new Insets(20, 20, 20, 20);
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        contentPane.add((Component)b, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (DialogSymbolize.this.key.getText().length() < 1) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("InvKey"), Globals.messages.getString("Symbolize"), 0);
                    DialogSymbolize.this.key.requestFocus();
                    return;
                }
                if (LibUtils.checkKey(DialogSymbolize.this.cp.getLibrary(), DialogSymbolize.this.getPrefix().trim(), DialogSymbolize.this.getPrefix().trim() + "." + DialogSymbolize.this.key.getText().trim())) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("DupKey"), Globals.messages.getString("Symbolize"), 0);
                    DialogSymbolize.this.key.requestFocus();
                    return;
                }
                if (DialogSymbolize.this.key.getText().contains(" ")) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("SpaceKey"), Globals.messages.getString("Symbolize"), 0);
                    DialogSymbolize.this.key.requestFocus();
                    return;
                }
                Point p = new Point(200 - DialogSymbolize.this.cpanel.xl, 200 - DialogSymbolize.this.cpanel.yl);
                MacroDesc macro = DialogSymbolize.this.buildMacro(DialogSymbolize.this.getMacroName().trim(), DialogSymbolize.this.key.getText().trim(), DialogSymbolize.this.getLibraryName().trim(), DialogSymbolize.this.getGroup().trim(), DialogSymbolize.this.getPrefix().trim(), p);
                DialogSymbolize.this.cp.getLibrary().put(macro.key, macro);
                System.out.println("key: " + macro.key);
                try {
                    LibUtils.save(DialogSymbolize.this.cp.getLibrary(), LibUtils.getLibPath(DialogSymbolize.this.getPrefix()).trim(), DialogSymbolize.this.getLibraryName(), DialogSymbolize.this.getPrefix());
                }
                catch (FileNotFoundException F) {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("DirNotFound"), Globals.messages.getString("Symbolize"), 0);
                }
                DialogSymbolize.this.setVisible(false);
                ((JFrame)Globals.activeWindow).repaint();
                DialogSymbolize.this.updateTreeLib();
                Globals.lastCLib = DialogSymbolize.this.getLibraryName();
                Globals.lastCGrp = DialogSymbolize.this.getGroup();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogSymbolize.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogSymbolize.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }

    protected MacroDesc buildMacro(String myname, String mykey, String mylib, String mygrp, String myprefix, Point origin) {
        StringBuilder ss = new StringBuilder();
        EditorActions edt = new EditorActions(this.cp, null);
        if (edt.getFirstSelectedPrimitive() == null) {
            return null;
        }
        DrawingModel ps = new DrawingModel();
        try {
            ps.setLibrary(this.cp.getLibrary());
            ParserActions pa = new ParserActions(ps);
            for (GraphicPrimitive g : this.cp.getPrimitiveVector()) {
                if (!g.getSelected()) continue;
                pa.addString(new StringBuffer(g.toString(true)), true);
            }
            edt.setSelectionAll(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (GraphicPrimitive psp : ps.getPrimitiveVector()) {
            if (!psp.getSelected()) continue;
            psp.movePrimitive(origin.x, origin.y);
            ss.append(psp.toString(true));
        }
        this.parent.repaint();
        String desc = ss.toString();
        MacroDesc md = new MacroDesc(myprefix + "." + mykey, myname, desc, mygrp, mylib, myprefix);
        return md;
    }

    protected void updateTreeLib() {
        JFrame cc = (JFrame)Globals.activeWindow;
        ((AbstractButton)((Object)cc.getJMenuBar().getMenu(3).getSubElements()[0].getSubElements()[1])).doClick();
    }

    public void setCircuit(DrawingModel p) {
        this.cp = p;
    }

    static class myCircuitPanel
    extends CircuitPanel {
        private static final long serialVersionUID = 1L;
        final float[] dash1 = new float[]{2.0f};
        final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash1, 1.0f);
        private int dx = 20;
        private int dy = 20;
        public int xl = 5;
        public int yl = 5;

        public int getDx() {
            return this.dx;
        }

        public int getDy() {
            return this.dy;
        }

        public void resetOrigin() {
            this.xl = this.getMapCoordinates().unmapXsnap(10);
            this.yl = this.getMapCoordinates().unmapYsnap(10);
            this.dx = this.getMapCoordinates().mapXi(this.xl, this.yl, false);
            this.dy = this.getMapCoordinates().mapYi(this.xl, this.yl, false);
        }

        public void setDx(int dx) {
            if (dx < 0 || dx > this.getWidth()) {
                return;
            }
            this.dx = dx;
        }

        public void setDy(int dy) {
            if (dy < 0 || dy > this.getHeight()) {
                return;
            }
            this.dy = dy;
        }

        public myCircuitPanel(boolean isEditable) {
            super(isEditable);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color c = g.getColor();
            Graphics2D g2 = (Graphics2D)g;
            g.setColor(Color.red);
            Stroke t = g2.getStroke();
            g2.setStroke(this.dashed);
            g.drawLine(this.dx, 0, this.dx, this.getHeight());
            g.drawLine(0, this.dy, this.getWidth(), this.dy);
            Font f = new Font("Helvetica", 0, 12);
            FontMetrics fm = g.getFontMetrics(f);
            int h = fm.getAscent();
            int th = h + fm.getDescent();
            g.drawString(Globals.messages.getString("Origin"), this.dx + 5, this.dy + th + 2);
            g.setColor(c);
            g2.setStroke(t);
        }
    }
}

