/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.DialogUtil;
import dialogs.LibraryPanel;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DialogOptions
extends JDialog
implements ComponentListener {
    private static final int MIN_WIDTH = 600;
    private static final int MIN_HEIGHT = 450;
    public double zoomValue;
    public boolean profileTime;
    public boolean antiAlias;
    public boolean textToolbar;
    public boolean smallIconsToolbar;
    public int gridSize;
    public boolean extStrict;
    public boolean split_n_s;
    public boolean split_n_c;
    public boolean shiftCP;
    public double stroke_size_straight_i;
    public double connectionSize_i;
    public boolean quaquaActive;
    public String libDirectory;
    public int pcblinewidth_i;
    public int pcbpadwidth_i;
    public int pcbpadheight_i;
    public int pcbpadintw_i;
    public String macroFont;
    public int macroSize_i;
    private final JFrame parent;
    private JCheckBox antiAlias_CB;
    private JCheckBox profile_CB;
    private JCheckBox extStrict_CB;
    private JCheckBox shiftCP_CB;
    private JTextField gridWidth;
    private JTextField libD;
    private JCheckBox textToolbar_CB;
    private JCheckBox smallIconsToolbar_CB;
    private JTextField pcblinewidth;
    private JTextField pcbpadwidth;
    private JTextField pcbpadheight;
    private JTextField pcbpadintw;
    private JTextField connectionSize;
    private JTextField macroSize;
    private JTextField stroke_size_straight;
    private JCheckBox quaquaActive_CB;
    private JComboBox<String> comboFont;

    public DialogOptions(JFrame pa, double z, boolean p, boolean a, int gs, String libDir, boolean tt, boolean sit, int plw, int pw, int ph, int piw, boolean qq, boolean ex, String mf, boolean sn, boolean sc, double sssi, double ssoi, double ccs, int ms, boolean sdcp) {
        super(pa, Globals.messages.getString("Cir_opt_t"), true);
        this.addComponentListener(this);
        this.shiftCP = sdcp;
        this.parent = pa;
        this.zoomValue = z;
        this.profileTime = p;
        this.antiAlias = a;
        this.gridSize = gs;
        this.libDirectory = libDir;
        this.textToolbar = tt;
        this.smallIconsToolbar = sit;
        this.quaquaActive = qq;
        this.extStrict = ex;
        this.macroFont = mf;
        this.split_n_s = sn;
        this.split_n_c = sc;
        this.pcblinewidth_i = plw;
        this.pcbpadwidth_i = pw;
        this.pcbpadheight_i = ph;
        this.pcbpadintw_i = piw;
        this.connectionSize_i = ccs;
        this.macroSize_i = ms;
        this.stroke_size_straight_i = sssi;
        this.setSize(600, 500);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JTabbedPane tabsPane = new JTabbedPane();
        tabsPane.addTab(Globals.messages.getString("Restart"), this.createRestartPane());
        tabsPane.addTab(Globals.messages.getString("Drawing"), this.createDrawingOptPanel());
        tabsPane.addTab(Globals.messages.getString("PCBsizes"), this.createPCBsizePanel());
        tabsPane.addTab(Globals.messages.getString("FidoCad"), this.createExtensionsPanel());
        GridBagConstraints constraints = DialogUtil.createConst(0, 0, 3, 1, 100, 100, 13, 1, new Insets(6, 20, 6, 20));
        contentPane.add((Component)tabsPane, constraints);
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        constraints = DialogUtil.createConst(0, 1, 3, 1, 100, 100, 13, 1, new Insets(6, 20, 20, 20));
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        contentPane.add((Component)b, constraints);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int ng = -1;
                DialogOptions.this.shiftCP = DialogOptions.this.shiftCP_CB.isSelected();
                DialogOptions.this.antiAlias = DialogOptions.this.antiAlias_CB.isSelected();
                DialogOptions.this.profileTime = DialogOptions.this.profile_CB.isSelected();
                DialogOptions.this.textToolbar = DialogOptions.this.textToolbar_CB.isSelected();
                DialogOptions.this.smallIconsToolbar = DialogOptions.this.smallIconsToolbar_CB.isSelected();
                DialogOptions.this.quaquaActive = DialogOptions.this.quaquaActive_CB.isSelected();
                DialogOptions.this.extStrict = DialogOptions.this.extStrict_CB.isSelected();
                DialogOptions.this.macroFont = (String)DialogOptions.this.comboFont.getSelectedItem();
                try {
                    int s = Integer.parseInt(DialogOptions.this.macroSize.getText().trim());
                    if (s <= 0) {
                        JOptionPane.showMessageDialog(null, Globals.messages.getString("Font_size_invalid"), "", 1);
                        return;
                    }
                    DialogOptions.this.macroSize_i = s;
                    ng = Integer.parseInt(DialogOptions.this.gridWidth.getText().trim());
                    DialogOptions.this.libDirectory = DialogOptions.this.libD.getText().trim();
                    DialogOptions.this.pcblinewidth_i = Integer.parseInt(DialogOptions.this.pcblinewidth.getText().trim());
                    DialogOptions.this.pcbpadwidth_i = Integer.parseInt(DialogOptions.this.pcbpadwidth.getText().trim());
                    DialogOptions.this.pcbpadheight_i = Integer.parseInt(DialogOptions.this.pcbpadheight.getText().trim());
                    DialogOptions.this.pcbpadintw_i = Integer.parseInt(DialogOptions.this.pcbpadintw.getText().trim());
                    DialogOptions.this.stroke_size_straight_i = Double.parseDouble(DialogOptions.this.stroke_size_straight.getText().trim());
                    DialogOptions.this.connectionSize_i = Double.parseDouble(DialogOptions.this.connectionSize.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ng > 0) {
                    DialogOptions.this.gridSize = ng;
                } else {
                    JOptionPane.showMessageDialog(null, Globals.messages.getString("Format_invalid"), "", 1);
                }
                DialogOptions.this.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogOptions.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogOptions.this.setVisible(false);
            }
        };
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 600) {
            resize = true;
            width = 600;
        }
        if (height < 450) {
            resize = true;
            height = 450;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private JPanel createRestartPane() {
        JPanel restartOptionPanel = new JPanel();
        restartOptionPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        restartOptionPanel.setOpaque(false);
        JLabel liblbl = new JLabel(Globals.messages.getString("lib_dir"));
        constraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 17, 2, new Insets(20, 40, 6, 0));
        restartOptionPanel.add((Component)liblbl, constraints);
        this.libD = new JTextField(10);
        this.libD.setText(this.libDirectory);
        constraints = DialogUtil.createConst(0, 1, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 20));
        restartOptionPanel.add((Component)this.libD, constraints);
        JButton libB = new JButton(Globals.messages.getString("Browse"));
        constraints.insets = new Insets(0, 0, 0, 40);
        libB.setOpaque(false);
        constraints.gridx = 1;
        constraints.gridy = 1;
        restartOptionPanel.add((Component)libB, constraints);
        libB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String din;
                if (Globals.useNativeFileDialogs) {
                    FileDialog fd = new FileDialog((Frame)DialogOptions.this.parent, Globals.messages.getString("Select_lib_directory"), 0);
                    fd.setDirectory(DialogOptions.this.libD.getText());
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                    fd.setVisible(true);
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    din = fd.getDirectory() != null && fd.getFile() != null ? new File(fd.getDirectory(), fd.getFile()).getPath() : null;
                } else {
                    JFileChooser fc = new JFileChooser(new File(DialogOptions.this.libD.getText()).getPath());
                    fc.setDialogTitle(Globals.messages.getString("Select_lib_directory"));
                    fc.setFileSelectionMode(1);
                    LibraryPanel p = new LibraryPanel(fc);
                    int r = fc.showOpenDialog(null);
                    din = r == 0 ? fc.getSelectedFile().getPath() : null;
                }
                if (din != null) {
                    DialogOptions.this.libD.setText(din);
                }
            }
        });
        this.textToolbar_CB = new JCheckBox(Globals.messages.getString("TextToolbar"));
        this.textToolbar_CB.setSelected(this.textToolbar);
        this.textToolbar_CB.setOpaque(false);
        constraints = DialogUtil.createConst(0, 3, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 0));
        restartOptionPanel.add((Component)this.textToolbar_CB, constraints);
        this.quaquaActive_CB = new JCheckBox(Globals.messages.getString("Quaqua"));
        this.quaquaActive_CB.setSelected(this.quaquaActive);
        this.quaquaActive_CB.setOpaque(false);
        constraints = DialogUtil.createConst(0, 4, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 6, 20));
        this.smallIconsToolbar_CB = new JCheckBox(Globals.messages.getString("SmallIcons"));
        this.smallIconsToolbar_CB.setSelected(this.smallIconsToolbar);
        this.smallIconsToolbar_CB.setOpaque(false);
        constraints = DialogUtil.createConst(0, 5, 1, 1, 100, 100, 13, 2, new Insets(6, 40, 20, 20));
        restartOptionPanel.add((Component)this.smallIconsToolbar_CB, constraints);
        return restartOptionPanel;
    }

    private JPanel createDrawingOptPanel() {
        JPanel drawingOptPanel = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        drawingOptPanel.setLayout(new GridBagLayout());
        drawingOptPanel.setOpaque(false);
        this.profile_CB = new JCheckBox(Globals.messages.getString("Profile"));
        this.profile_CB.setOpaque(false);
        this.profile_CB.setSelected(this.profileTime);
        constraints = DialogUtil.createConst(1, 1, 2, 1, 100, 100, 13, 2, new Insets(6, 6, 6, 20));
        JLabel gridlbl = new JLabel(Globals.messages.getString("Grid_width"));
        constraints = DialogUtil.createConst(0, 2, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)gridlbl, constraints);
        this.gridWidth = new JTextField(10);
        this.gridWidth.setText("" + this.gridSize);
        constraints = DialogUtil.createConst(1, 2, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)this.gridWidth, constraints);
        JLabel connectionSizelbl = new JLabel(Globals.messages.getString("connection_size"));
        constraints = DialogUtil.createConst(0, 8, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)connectionSizelbl, constraints);
        this.connectionSize = new JTextField(10);
        this.connectionSize.setText("" + this.connectionSize_i);
        constraints = DialogUtil.createConst(1, 8, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)this.connectionSize, constraints);
        JLabel stroke_size_strlbl = new JLabel(Globals.messages.getString("stroke_size_straight"));
        constraints = DialogUtil.createConst(0, 9, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)stroke_size_strlbl, constraints);
        this.stroke_size_straight = new JTextField(10);
        this.stroke_size_straight.setText("" + this.stroke_size_straight_i);
        constraints = DialogUtil.createConst(1, 9, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)this.stroke_size_straight, constraints);
        JLabel macroFontlbl = new JLabel(Globals.messages.getString("macrofont"));
        constraints = DialogUtil.createConst(0, 11, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)macroFontlbl, constraints);
        GraphicsEnvironment gE = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] s = gE.getAvailableFontFamilyNames();
        this.comboFont = new JComboBox();
        for (int i = 0; i < s.length; ++i) {
            this.comboFont.addItem(s[i]);
            if (!s[i].equals(this.macroFont)) continue;
            this.comboFont.setSelectedIndex(i);
        }
        constraints = DialogUtil.createConst(1, 11, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add(this.comboFont, constraints);
        JLabel macroSizelbl = new JLabel(Globals.messages.getString("macroSize"));
        constraints = DialogUtil.createConst(0, 12, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)macroSizelbl, constraints);
        this.macroSize = new JTextField(10);
        this.macroSize.setText("" + this.macroSize_i);
        constraints = DialogUtil.createConst(1, 12, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        drawingOptPanel.add((Component)this.macroSize, constraints);
        this.antiAlias_CB = new JCheckBox(Globals.messages.getString("Anti_al"));
        this.antiAlias_CB.setSelected(this.antiAlias);
        this.antiAlias_CB.setOpaque(false);
        constraints = DialogUtil.createConst(1, 13, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 40));
        drawingOptPanel.add((Component)this.antiAlias_CB, constraints);
        this.shiftCP_CB = new JCheckBox(Globals.messages.getString("Shift_cp"));
        this.shiftCP_CB.setSelected(this.shiftCP);
        this.shiftCP_CB.setOpaque(false);
        constraints = DialogUtil.createConst(1, 14, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 40));
        drawingOptPanel.add((Component)this.shiftCP_CB, constraints);
        return drawingOptPanel;
    }

    private JPanel createPCBsizePanel() {
        JPanel pcbSizePanel = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        pcbSizePanel.setLayout(new GridBagLayout());
        pcbSizePanel.setOpaque(false);
        JLabel pcblinelbl = new JLabel(Globals.messages.getString("pcbline_width"));
        constraints = DialogUtil.createConst(0, 0, 1, 1, 100, 100, 13, 0, new Insets(0, 0, 0, 0));
        pcbSizePanel.add((Component)pcblinelbl, constraints);
        this.pcblinewidth = new JTextField(10);
        this.pcblinewidth.setText("" + this.pcblinewidth_i);
        constraints = DialogUtil.createConst(1, 0, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)this.pcblinewidth, constraints);
        JLabel pcbpadwidthlbl = new JLabel(Globals.messages.getString("pcbpad_width"));
        constraints = DialogUtil.createConst(0, 1, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)pcbpadwidthlbl, constraints);
        this.pcbpadwidth = new JTextField(10);
        this.pcbpadwidth.setText("" + this.pcbpadwidth_i);
        constraints = DialogUtil.createConst(1, 1, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)this.pcbpadwidth, constraints);
        JLabel pcbpadheightlbl = new JLabel(Globals.messages.getString("pcbpad_height"));
        constraints = DialogUtil.createConst(0, 2, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)pcbpadheightlbl, constraints);
        this.pcbpadheight = new JTextField(10);
        this.pcbpadheight.setText("" + this.pcbpadheight_i);
        constraints = DialogUtil.createConst(1, 2, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)this.pcbpadheight, constraints);
        JLabel pcbpadintwlbl = new JLabel(Globals.messages.getString("pcbpad_intw"));
        constraints = DialogUtil.createConst(0, 3, 1, 1, 100, 100, 13, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)pcbpadintwlbl, constraints);
        this.pcbpadintw = new JTextField(10);
        this.pcbpadintw.setText("" + this.pcbpadintw_i);
        constraints = DialogUtil.createConst(1, 3, 1, 1, 100, 100, 17, 0, new Insets(6, 6, 6, 6));
        pcbSizePanel.add((Component)this.pcbpadintw, constraints);
        return pcbSizePanel;
    }

    private JPanel createExtensionsPanel() {
        JPanel extensionsPanel = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        extensionsPanel.setLayout(new GridBagLayout());
        extensionsPanel.setOpaque(false);
        this.extStrict_CB = new JCheckBox(Globals.messages.getString("strict_FC_comp"));
        this.extStrict_CB.setSelected(this.extStrict);
        this.extStrict_CB.setOpaque(false);
        constraints = DialogUtil.createConst(0, 0, 2, 1, 100, 100, 17, 0, new Insets(6, 40, 6, 40));
        extensionsPanel.add((Component)this.extStrict_CB, constraints);
        return extensionsPanel;
    }
}

