/*
 * Decompiled with CFR 0.152.
 */
package circuit.views;

import circuit.model.DrawingModel;
import geom.MapCoordinates;
import graphic.GraphicsInterface;
import primitives.GraphicPrimitive;

public class Drawing {
    private final DrawingModel P;
    private boolean needHoles;
    private double oZ;
    private double oX;
    private double oY;
    private double oO;
    private GraphicPrimitive gg;
    private int i_index;
    private int j_index;

    public Drawing(DrawingModel pp) {
        this.P = pp;
    }

    public void drawSelectedHandles(GraphicsInterface gi, MapCoordinates cs) {
        for (GraphicPrimitive gp : this.P.getPrimitiveVector()) {
            if (!gp.getSelected()) continue;
            gp.drawHandles(gi, cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GraphicsInterface G, MapCoordinates cs) {
        if (cs == null) {
            System.out.println("DrawingModel.draw: ouch... cs not initialized :-(");
            return;
        }
        Drawing drawing = this;
        synchronized (drawing) {
            if (this.P.changed || this.oZ != cs.getXMagnitude() || this.oX != cs.getXCenter() || this.oY != cs.getYCenter() || this.oO != (double)cs.getOrientation()) {
                this.oZ = cs.getXMagnitude();
                this.oX = cs.getXCenter();
                this.oY = cs.getYCenter();
                this.oO = cs.getOrientation();
                this.P.changed = false;
                for (GraphicPrimitive gp : this.P.getPrimitiveVector()) {
                    gp.setChanged(true);
                }
                if (!this.P.drawOnlyPads) {
                    cs.resetMinMax();
                }
            }
            this.needHoles = this.P.drawOnlyPads;
            if (this.P.drawOnlyLayer >= 0 && !this.P.drawOnlyPads) {
                if (!this.P.layersUsed[this.P.drawOnlyLayer]) {
                    return;
                }
                this.drawPrimitives(this.P.drawOnlyLayer, G, cs);
                return;
            }
            if (!this.P.drawOnlyPads) {
                this.j_index = 0;
                while (this.j_index < 16) {
                    if (this.P.layersUsed[this.j_index]) {
                        this.drawPrimitives(this.j_index, G, cs);
                    }
                    ++this.j_index;
                }
            }
            if (this.needHoles) {
                this.i_index = 0;
                while (this.i_index < this.P.getPrimitiveVector().size()) {
                    this.gg = this.P.getPrimitiveVector().get(this.i_index);
                    if (this.gg.needsHoles()) {
                        this.gg.setDrawOnlyPads(true);
                        this.gg.draw(G, cs, this.P.layerV);
                        this.gg.setDrawOnlyPads(false);
                    }
                    ++this.i_index;
                }
            }
        }
    }

    public final boolean getNeedHoles() {
        return this.needHoles;
    }

    private void drawPrimitives(int j_index, GraphicsInterface graphic, MapCoordinates cs) {
        for (int i_index = 0; i_index < this.P.getPrimitiveVector().size(); ++i_index) {
            GraphicPrimitive gg = this.P.getPrimitiveVector().get(i_index);
            if (j_index > 0 && gg.layer > j_index) break;
            if (gg.containsLayer(j_index)) {
                gg.setDrawOnlyLayer(j_index);
                gg.draw(graphic, cs, this.P.layerV);
            }
            if (!gg.needsHoles()) continue;
            this.needHoles = true;
        }
    }
}

