/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.MissingArgEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Index
implements Function {
    public ValueEval evaluate(ValueEval[] args, int srcCellRow, short srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval firstArg = args[0];
        if (firstArg instanceof RefEval) {
            firstArg = ((RefEval)firstArg).offset(0, 0, 0, 0);
        }
        if (!(firstArg instanceof AreaEval)) {
            throw new RuntimeException("Incomplete code - cannot handle first arg of type (" + firstArg.getClass().getName() + ")");
        }
        AreaEval reference = (AreaEval)firstArg;
        int rowIx = 0;
        int columnIx = 0;
        boolean colArgWasPassed = false;
        try {
            switch (nArgs) {
                case 4: {
                    throw new RuntimeException("Incomplete code - don't know how to support the 'area_num' parameter yet)");
                }
                case 3: {
                    columnIx = Index.resolveIndexArg(args[2], srcCellRow, srcCellCol);
                    colArgWasPassed = true;
                }
                case 2: {
                    rowIx = Index.resolveIndexArg(args[1], srcCellRow, srcCellCol);
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
            return Index.getValueFromArea(reference, rowIx, columnIx, colArgWasPassed, srcCellRow, srcCellCol);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static ValueEval getValueFromArea(AreaEval ae, int pRowIx, int pColumnIx, boolean colArgWasPassed, int srcRowIx, int srcColIx) throws EvaluationException {
        int columnIx;
        int rowIx;
        boolean colArgWasEmpty;
        boolean rowArgWasEmpty = pRowIx == 0;
        boolean bl = colArgWasEmpty = pColumnIx == 0;
        if (ae.isRow()) {
            if (ae.isColumn()) {
                rowIx = rowArgWasEmpty ? 0 : pRowIx - 1;
                columnIx = colArgWasEmpty ? 0 : pColumnIx - 1;
            } else if (colArgWasPassed) {
                rowIx = rowArgWasEmpty ? 0 : pRowIx - 1;
                columnIx = pColumnIx - 1;
            } else {
                rowIx = 0;
                columnIx = pRowIx - 1;
                colArgWasEmpty = rowArgWasEmpty;
            }
        } else if (ae.isColumn()) {
            rowIx = rowArgWasEmpty ? srcRowIx - ae.getFirstRow() : pRowIx - 1;
            columnIx = colArgWasEmpty ? 0 : (colArgWasEmpty ? 0 : pColumnIx - 1);
        } else {
            if (!colArgWasPassed) {
                throw new EvaluationException(pRowIx < 0 ? ErrorEval.VALUE_INVALID : ErrorEval.REF_INVALID);
            }
            rowIx = rowArgWasEmpty ? srcRowIx - ae.getFirstRow() : pRowIx - 1;
            columnIx = colArgWasEmpty ? srcColIx - ae.getFirstColumn() : pColumnIx - 1;
        }
        int width = ae.getWidth();
        int height = ae.getHeight();
        if (!rowArgWasEmpty && rowIx >= height || !colArgWasEmpty && columnIx >= width) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        if (rowIx < 0 || columnIx < 0 || rowIx >= height || columnIx >= width) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return ae.getRelativeValue(rowIx, columnIx);
    }

    private static int resolveIndexArg(ValueEval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        if (ev == MissingArgEval.instance) {
            return 0;
        }
        if (ev == BlankEval.INSTANCE) {
            return 0;
        }
        int result = OperandResolver.coerceValueToInt(ev);
        if (result < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }
}

