/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.tube;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import org.diylc.common.ObjectCache;
import org.diylc.components.transform.TubeSymbolTransformer;
import org.diylc.components.tube.AbstractTubeSymbol;
import org.diylc.core.IPropertyValidator;
import org.diylc.core.ValidationException;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;

@ComponentDescriptor(name="Diode", author="Branislav Stojkovic", category="Schematic Symbols", instanceNamePrefix="V", description="Diode tube symbol", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE, transformer=TubeSymbolTransformer.class)
public class DiodeSymbol
extends AbstractTubeSymbol {
    private static final long serialVersionUID = 1L;
    protected boolean directlyHeated = false;

    public DiodeSymbol() {
        this.controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
        this.updateControlPoints();
    }

    @Override
    public Shape[] initializeBody() {
        if (this.body == null) {
            Point[] controlPoints = this.initializeControlPoints(this.controlPoints[0]);
            this.body = new Shape[3];
            int x = controlPoints[0].x;
            int y = controlPoints[0].y;
            int pinSpacing = (int)PIN_SPACING.convertToPixels();
            GeneralPath polyline = new GeneralPath();
            polyline.moveTo(x + pinSpacing * 3 / 2, y - pinSpacing);
            polyline.lineTo(x + pinSpacing * 9 / 2, y - pinSpacing);
            if (this.directlyHeated) {
                polyline.moveTo(controlPoints[2].x, controlPoints[2].y - pinSpacing);
                polyline.lineTo(controlPoints[2].x + pinSpacing, controlPoints[2].y - pinSpacing * 2);
                polyline.lineTo(controlPoints[4].x, controlPoints[4].y - pinSpacing);
            } else {
                polyline.moveTo(x + pinSpacing * 2, y + pinSpacing);
                polyline.lineTo(x + pinSpacing * 4, y + pinSpacing);
            }
            this.body[0] = polyline;
            polyline = new GeneralPath();
            polyline.moveTo(controlPoints[1].x, controlPoints[1].y);
            polyline.lineTo(x + pinSpacing * 3, y - pinSpacing);
            if (this.directlyHeated) {
                polyline.moveTo(controlPoints[2].x, controlPoints[2].y);
                polyline.lineTo(controlPoints[2].x, controlPoints[2].y - pinSpacing);
                polyline.moveTo(controlPoints[4].x, controlPoints[4].y);
                polyline.lineTo(controlPoints[4].x, controlPoints[4].y - pinSpacing);
            } else {
                polyline.moveTo(controlPoints[2].x, controlPoints[2].y);
                polyline.lineTo(x + pinSpacing * 2, y + pinSpacing);
                if (this.showHeaters) {
                    polyline.moveTo(controlPoints[3].x, controlPoints[3].y);
                    polyline.lineTo(controlPoints[3].x, controlPoints[3].y - pinSpacing);
                    polyline.lineTo(controlPoints[3].x + pinSpacing / 2, controlPoints[3].y - 3 * pinSpacing / 2);
                    polyline.moveTo(controlPoints[4].x, controlPoints[4].y);
                    polyline.lineTo(controlPoints[4].x, controlPoints[4].y - pinSpacing);
                    polyline.lineTo(controlPoints[4].x - pinSpacing / 2, controlPoints[4].y - 3 * pinSpacing / 2);
                }
            }
            this.body[1] = polyline;
            this.body[2] = new Ellipse2D.Double(x + pinSpacing / 2, y - pinSpacing * 5 / 2, pinSpacing * 5, pinSpacing * 5);
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.drawLine(width / 4, height / 4, width * 3 / 4, height / 4);
        g2d.drawLine(width / 2, height / 4, width / 2, 0);
        g2d.drawLine(width / 4 + 2 * width / 32, height * 3 / 4, width * 3 / 4 - 4 * width / 32, height * 3 / 4);
        g2d.drawLine(width / 4 + 2 * width / 32, height * 3 / 4, width / 4 + 2 * width / 32, height - 1);
        g2d.drawOval(1, 1, width - 1 - 2 * width / 32, height - 1 - 2 * width / 32);
    }

    @Override
    protected Point[] initializeControlPoints(Point first) {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = first.x;
        int y = first.y;
        Point[] newPoints = new Point[]{first, new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
        newPoints[1].x = x + pinSpacing * 3;
        newPoints[1].y = y - pinSpacing * 3;
        newPoints[2].x = x + pinSpacing * 2;
        newPoints[2].y = y + pinSpacing * 3;
        newPoints[3].x = x + pinSpacing * 3;
        newPoints[3].y = y + pinSpacing * 3;
        newPoints[4].x = x + pinSpacing * 4;
        newPoints[4].y = y + pinSpacing * 3;
        return newPoints;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        if (this.directlyHeated) {
            return index > 0 && index != 3 ? VisibilityPolicy.WHEN_SELECTED : VisibilityPolicy.NEVER;
        }
        if (this.showHeaters) {
            return index > 0 ? VisibilityPolicy.WHEN_SELECTED : VisibilityPolicy.NEVER;
        }
        return index < 3 && index > 0 ? VisibilityPolicy.WHEN_SELECTED : VisibilityPolicy.NEVER;
    }

    public boolean isControlPointSticky(int index) {
        if (this.directlyHeated) {
            return index > 0 && index != 3;
        }
        if (this.showHeaters) {
            return index > 0;
        }
        return index > 0 && index < 3;
    }

    @EditableProperty(name="Directly heated")
    public boolean getDirectlyHeated() {
        return this.directlyHeated;
    }

    public void setDirectlyHeated(boolean directlyHeated) {
        this.directlyHeated = directlyHeated;
        this.body = null;
    }

    public class HeaterValidator
    implements IPropertyValidator {
        public void validate(Object value) throws ValidationException {
            boolean b;
            if (value != null && value instanceof Boolean && !(b = ((Boolean)value).booleanValue()) && DiodeSymbol.this.getDirectlyHeated()) {
                throw new ValidationException("Must show heaters for directly heated tubes.");
            }
        }
    }
}

