/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.TwoCircleTangent;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractMultiPartComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="RCA Jack", category="Electro-Mechanical", author="Branislav Stojkovic", description="Panel mount RCA phono jack socket", zOrder=4.0, instanceNamePrefix="J")
public class RCAJack
extends AbstractMultiPartComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Color BASE_COLOR = Color.lightGray;
    private static Color WAFER_COLOR = Color.black;
    private static Size BODY_DIAMETER = new Size(Double.valueOf(0.52), SizeUnit.in);
    private static Size WAFER_DIAMETER = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static Size HEX_DIAMETER = new Size(Double.valueOf(0.44), SizeUnit.in);
    private static Size SPRING_LENGTH = new Size(Double.valueOf(0.563), SizeUnit.in);
    private static Size SPRING_WIDTH = new Size(Double.valueOf(0.12), SizeUnit.in);
    private static Size HOLE_DIAMETER = new Size(Double.valueOf(0.05), SizeUnit.in);
    private static Size HOLE_TO_EDGE = new Size(Double.valueOf(0.063), SizeUnit.in);
    private String value = "";
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0)};
    transient Area[] body;
    private Orientation orientation = Orientation.DEFAULT;

    public RCAJack() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Theme theme;
        Area[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : WAFER_COLOR);
        g2d.fill(body[0]);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = WAFER_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BASE_COLOR);
        drawingObserver.startTrackingContinuityArea(true);
        g2d.fill(body[1]);
        g2d.fill(body[2]);
        drawingObserver.stopTrackingContinuityArea();
        if (body[3] != null) {
            g2d.fill(body[3]);
        }
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = BASE_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[1]);
        g2d.draw(body[2]);
        if (body[3] != null) {
            g2d.draw(body[3]);
        }
        this.drawSelectionOutline(g2d, componentState, outlineMode, project, drawingObserver);
    }

    @Override
    public Area[] getBody() {
        if (this.body == null) {
            this.body = new Area[4];
            int x0 = this.controlPoints[0].x;
            int y0 = this.controlPoints[0].y;
            int x1 = this.controlPoints[1].x;
            int y1 = this.controlPoints[1].y;
            int bodyDiameter = this.getClosestOdd(BODY_DIAMETER.convertToPixels());
            int waferDiameter = this.getClosestOdd(WAFER_DIAMETER.convertToPixels());
            int springWidth = (int)SPRING_WIDTH.convertToPixels();
            int holeDiameter = this.getClosestOdd(HOLE_DIAMETER.convertToPixels());
            double hexDiameter = HEX_DIAMETER.convertToPixels();
            Area wafer = new Area(new Ellipse2D.Double(x0 - waferDiameter / 2, y0 - waferDiameter / 2, waferDiameter, waferDiameter));
            wafer.subtract(new Area(new Ellipse2D.Double(x0 - holeDiameter / 2, y0 - holeDiameter / 2, holeDiameter, holeDiameter)));
            this.body[0] = wafer;
            TwoCircleTangent tip = new TwoCircleTangent(this.controlPoints[0], this.controlPoints[1], bodyDiameter / 2, springWidth / 2);
            tip.subtract(new Area(new Ellipse2D.Double(x1 - holeDiameter / 2, y1 - holeDiameter / 2, holeDiameter, holeDiameter)));
            tip.subtract(new Area(new Ellipse2D.Double(x0 - waferDiameter / 2, y0 - waferDiameter / 2, waferDiameter, waferDiameter)));
            this.body[1] = tip;
            Area sleeve = new Area(new Ellipse2D.Double(x0 - springWidth / 2, y0 - springWidth / 2, springWidth, springWidth));
            sleeve.subtract(new Area(new Ellipse2D.Double(x0 - holeDiameter / 2, y0 - holeDiameter / 2, holeDiameter, holeDiameter)));
            this.body[2] = sleeve;
            Path2D.Double hex = new Path2D.Double();
            for (int i = 0; i < 6; ++i) {
                double x = (double)x0 + Math.cos(1.0471975511965976 * (double)i) * hexDiameter / 2.0;
                double y = (double)y0 + Math.sin(1.0471975511965976 * (double)i) * hexDiameter / 2.0;
                if (i == 0) {
                    ((Path2D)hex).moveTo(x, y);
                    continue;
                }
                ((Path2D)hex).lineTo(x, y);
            }
            hex.closePath();
            Area hexArea = new Area(hex);
            hexArea.subtract(new Area(new Ellipse2D.Double(x0 - waferDiameter / 2, y0 - waferDiameter / 2, waferDiameter, waferDiameter)));
            this.body[3] = hexArea;
        }
        return this.body;
    }

    private void updateControlPoints() {
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        int springLength = (int)SPRING_LENGTH.convertToPixels();
        int holeToEdge = (int)HOLE_TO_EDGE.convertToPixels();
        int centerY = y + springLength - holeToEdge;
        this.controlPoints[1].setLocation(x, centerY);
        if (this.orientation != Orientation.DEFAULT) {
            double theta = 0.0;
            switch (this.orientation) {
                case _90: {
                    theta = 1.5707963267948966;
                    break;
                }
                case _180: {
                    theta = Math.PI;
                    break;
                }
                case _270: {
                    theta = 4.71238898038469;
                }
            }
            AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
            rotation.transform(this.controlPoints[1], this.controlPoints[1]);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        double x0 = (double)width * 0.35;
        double y0 = (double)height * 0.65;
        double x1 = (double)width * 0.75;
        double y1 = (double)height * 0.25;
        TwoCircleTangent main = new TwoCircleTangent(new Point2D.Double((double)width * 0.35, (double)height * 0.65), new Point2D.Double(x1, y1), (double)width * 0.3, (double)width * 0.1);
        main.subtract(new Area(new Ellipse2D.Double(x0 - 1.0, y0 - 1.0, 3.0, 3.0)));
        main.subtract(new Area(new Ellipse2D.Double(x1 - 1.0, y1 - 1.0, 2.0, 2.0)));
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(BASE_COLOR);
        g2d.fill(main);
        g2d.setColor(BASE_COLOR.darker());
        g2d.draw(main);
        double hexDiameter = (double)width * 0.48;
        Path2D.Double hex = new Path2D.Double();
        for (int i = 0; i < 6; ++i) {
            double x = x0 + Math.cos(1.0471975511965976 * (double)i) * hexDiameter / 2.0;
            double y = y0 + Math.sin(1.0471975511965976 * (double)i) * hexDiameter / 2.0;
            if (i == 0) {
                ((Path2D)hex).moveTo(x, y);
                continue;
            }
            ((Path2D)hex).lineTo(x, y);
        }
        hex.closePath();
        g2d.draw(hex);
        double waferDiameter = (double)width * 0.22;
        g2d.setColor(WAFER_COLOR);
        g2d.draw(new Ellipse2D.Double(x0 - waferDiameter / 2.0, y0 - waferDiameter / 2.0, waferDiameter, waferDiameter));
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public String getControlPointNodeName(int index) {
        return this.getName() + (index == 0 ? "Tip" : "Sleeve");
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

