/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.diylc.common.LineStyle;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractCurvedComponent;
import org.diylc.components.connectivity.AWG;
import org.diylc.core.ComponentState;
import org.diylc.core.IContinuity;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Twisted Leads", author="Branislav Stojkovic", category="Connectivity", instanceNamePrefix="W", description="A pair of flexible leads twisted tighly together", zOrder=4.0, flexibleZOrder=true, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class TwistedWire
extends AbstractCurvedComponent<Void>
implements IContinuity {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.green;
    public static Color COLOR2 = Color.blue;
    public static Color STRIPE_COLOR = Color.yellow;
    public static Color STRIPE_COLOR2 = Color.decode("#FF00FF");
    public static double INSULATION_THICKNESS_PCT = 0.3;
    protected AWG gauge = AWG._22;
    private Color color2 = COLOR2;
    private Color stripeColor = STRIPE_COLOR;
    private Color stripeColor2 = STRIPE_COLOR2;
    private boolean stripe1 = false;
    private boolean stripe2 = false;
    private transient Area firstLeadArea = null;
    private transient Area secondLeadArea = null;
    private transient Area firstLeadStripeArea = null;
    private transient Area secondLeadStripeArea = null;

    protected Color getDefaultColor() {
        return COLOR;
    }

    protected void drawCurve(Path2D curve, Graphics2D g2d, ComponentState componentState, IDrawingObserver drawingObserver) {
        Color curveColor2;
        int thickness = (int)(this.gauge.diameterIn() * 200.0 * (1.0 + 2.0 * INSULATION_THICKNESS_PCT)) - 1;
        Color curveColor1 = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color;
        Color color = curveColor2 = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color2;
        if (this.firstLeadArea == null || this.secondLeadArea == null) {
            this.firstLeadArea = new Area();
            this.secondLeadArea = new Area();
            this.recalculate(curve, thickness, this.firstLeadArea, this.secondLeadArea, false);
            if (this.stripe1 || this.stripe2) {
                this.firstLeadStripeArea = new Area();
                this.secondLeadStripeArea = new Area();
                this.recalculate(curve, thickness, this.firstLeadStripeArea, this.secondLeadStripeArea, true);
                this.firstLeadStripeArea.intersect(this.firstLeadArea);
                this.secondLeadStripeArea.intersect(this.secondLeadArea);
            }
        }
        g2d.setColor(curveColor1);
        g2d.fill(this.firstLeadArea);
        if (this.stripe1 && componentState == ComponentState.NORMAL) {
            drawingObserver.stopTracking();
            g2d.setColor(this.stripeColor);
            g2d.fill(this.firstLeadStripeArea);
            drawingObserver.startTracking();
        }
        g2d.setColor(curveColor2);
        g2d.fill(this.secondLeadArea);
        if (this.stripe2 && componentState == ComponentState.NORMAL) {
            drawingObserver.stopTracking();
            g2d.setColor(this.stripeColor2);
            g2d.fill(this.secondLeadStripeArea);
            drawingObserver.startTracking();
        }
        if (componentState == ComponentState.NORMAL) {
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            g2d.setColor(this.color.darker());
            g2d.draw(this.firstLeadArea);
            g2d.setColor(this.color2.darker());
            g2d.draw(this.secondLeadArea);
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        Stroke stroke = ObjectCache.getInstance().fetchBasicStroke(3.0f);
        CubicCurve2D.Double curve1 = new CubicCurve2D.Double(2.0, height - 2, width - 4, height - 4, 4.0, 4.0, width - 2, 2.0);
        CubicCurve2D.Double curve2 = new CubicCurve2D.Double(2.0, height - 2, 4.0, 4.0, width - 4, height - 4, width - 2, 2.0);
        Area area1 = new Area(stroke.createStrokedShape(curve1));
        Area area2 = new Area(stroke.createStrokedShape(curve2));
        area2.subtract(area1);
        g2d.setColor(COLOR2);
        g2d.fill(area2);
        g2d.setColor(COLOR);
        g2d.fill(area1);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(COLOR2.darker());
        g2d.draw(area2);
        g2d.setColor(COLOR.darker());
        g2d.draw(area1);
    }

    @EditableProperty(name="AWG")
    public AWG getGauge() {
        return this.gauge;
    }

    public void setGauge(AWG gauge) {
        this.gauge = gauge;
        this.firstLeadArea = null;
        this.secondLeadArea = null;
        this.firstLeadStripeArea = null;
        this.secondLeadStripeArea = null;
    }

    public void setControlPoint(Point point, int index) {
        super.setControlPoint(point, index);
        this.firstLeadArea = null;
        this.secondLeadArea = null;
        this.firstLeadStripeArea = null;
        this.secondLeadStripeArea = null;
    }

    public void setPointCount(AbstractCurvedComponent.PointCount pointCount) {
        super.setPointCount(pointCount);
        this.firstLeadArea = null;
        this.secondLeadArea = null;
        this.firstLeadStripeArea = null;
        this.secondLeadStripeArea = null;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    @EditableProperty(name="Color 1")
    public Color getLeadColor() {
        return this.color;
    }

    @EditableProperty(name="Color 2")
    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    public LineStyle getStyle() {
        return super.getStyle();
    }

    @EditableProperty(name="Stripe Color 1")
    public Color getStripeColor() {
        return this.stripeColor;
    }

    public void setStripeColor(Color stripeColor) {
        this.stripeColor = stripeColor;
    }

    @EditableProperty(name="Stripe Color 2")
    public Color getStripeColor2() {
        return this.stripeColor2;
    }

    public void setStripeColor2(Color stripeColor2) {
        this.stripeColor2 = stripeColor2;
    }

    @EditableProperty(name="Stripe 1")
    public boolean getStripe1() {
        return this.stripe1;
    }

    public void setStripe1(boolean stripe1) {
        this.stripe1 = stripe1;
        if (stripe1) {
            this.firstLeadArea = null;
            this.secondLeadArea = null;
            this.firstLeadStripeArea = null;
            this.secondLeadStripeArea = null;
        }
    }

    @EditableProperty(name="Stripe 2")
    public boolean getStripe2() {
        return this.stripe2;
    }

    public void setStripe2(boolean stripe2) {
        this.stripe2 = stripe2;
        if (stripe2) {
            this.firstLeadArea = null;
            this.secondLeadArea = null;
            this.firstLeadStripeArea = null;
            this.secondLeadStripeArea = null;
        }
    }

    public void recalculate(Path2D path, float thickness, Area firstLeadArea, Area secondLeadArea, boolean stripe) {
        PathIterator iterator = path.getPathIterator(null);
        float[] coords = new float[6];
        Point current = new Point();
        ArrayList<CubicCurve2D.Double> curves = new ArrayList<CubicCurve2D.Double>();
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    current.setLocation(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    curves.add(new CubicCurve2D.Double(current.x, current.y, ((float)current.x + coords[0]) / 2.0f, ((float)current.y + coords[1]) / 2.0f, ((float)current.x + coords[0]) / 2.0f, ((float)current.y + coords[1]) / 2.0f, coords[0], coords[1]));
                    current.setLocation(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    curves.add(new CubicCurve2D.Double(current.x, current.y, coords[0], coords[1], coords[0], coords[1], coords[2], coords[3]));
                    current.setLocation(coords[2], coords[3]);
                    break;
                }
                case 3: {
                    curves.add(new CubicCurve2D.Double(current.x, current.y, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]));
                    current.setLocation(coords[4], coords[5]);
                }
            }
            iterator.next();
        }
        Stroke stroke = stripe ? ObjectCache.getInstance().fetchStroke(thickness, new float[]{thickness / 2.0f, thickness * 2.0f}, thickness * 10.0f, 0) : ObjectCache.getInstance().fetchBasicStroke(thickness);
        double segmentLength = thickness * 6.0f;
        ArrayList<Line2D> polygon = new ArrayList<Line2D>();
        for (CubicCurve2D cubicCurve2D : curves) {
            polygon.addAll(this.split(cubicCurve2D, segmentLength));
        }
        ArrayList<Path2D.Double> firstCurves = new ArrayList<Path2D.Double>();
        ArrayList<Path2D.Double> arrayList = new ArrayList<Path2D.Double>();
        Path2D.Double current1 = new Path2D.Double();
        Path2D.Double current2 = new Path2D.Double();
        double offset = (double)thickness * 1.5;
        double rectSize = (double)thickness * 3.5;
        ((Path2D)current1).moveTo(((Line2D)polygon.get(0)).getX1(), ((Line2D)polygon.get(0)).getY1());
        ((Path2D)current2).moveTo(((Line2D)polygon.get(0)).getX1(), ((Line2D)polygon.get(0)).getY1());
        for (int i = 0; i < polygon.size(); ++i) {
            Line2D line2D = (Line2D)polygon.get(i);
            double centerX = (line2D.getX1() + line2D.getX2()) / 2.0;
            double centerY = (line2D.getY1() + line2D.getY2()) / 2.0;
            double theta = Math.atan2(line2D.getY2() - line2D.getY1(), line2D.getX2() - line2D.getX1());
            double sign = i % 2 == 0 ? 1.0 : -1.0;
            double theta1 = theta - sign * Math.PI / 2.0;
            double theta2 = theta + sign * Math.PI / 2.0;
            ((Path2D)current1).quadTo(centerX + offset * Math.cos(theta1), centerY + offset * Math.sin(theta1), line2D.getX2(), line2D.getY2());
            ((Path2D)current2).quadTo(centerX + offset * Math.cos(theta2), centerY + offset * Math.sin(theta2), line2D.getX2(), line2D.getY2());
            if (i % 2 == 0 || i == polygon.size() - 1) {
                firstCurves.add(current1);
                current1 = new Path2D.Double();
                ((Path2D)current1).moveTo(line2D.getX2(), line2D.getY2());
            }
            if (i % 2 != 1 && i != polygon.size() - 1) continue;
            arrayList.add(current2);
            current2 = new Path2D.Double();
            ((Path2D)current2).moveTo(line2D.getX2(), line2D.getY2());
        }
        for (Path2D path2D : firstCurves) {
            firstLeadArea.add(new Area(stroke.createStrokedShape(path2D)));
        }
        for (Path2D path2D : arrayList) {
            secondLeadArea.add(new Area(stroke.createStrokedShape(path2D)));
        }
        for (int i = 0; i < polygon.size(); ++i) {
            Line2D line2D = (Line2D)polygon.get(i);
            Area pointRect1 = new Area(new Rectangle2D.Double(line2D.getX1() - rectSize / 2.0, line2D.getY1() - rectSize / 2.0, rectSize, rectSize));
            if (i % 2 == 1) {
                pointRect1.intersect(firstLeadArea);
                secondLeadArea.subtract(pointRect1);
            } else {
                pointRect1.intersect(secondLeadArea);
                firstLeadArea.subtract(pointRect1);
            }
            if (i != polygon.size() - 1) continue;
            Area pointRect2 = new Area(new Rectangle2D.Double(line2D.getX2() - rectSize / 2.0, line2D.getY2() - rectSize / 2.0, rectSize, rectSize));
            if (i % 2 == 0) {
                pointRect2.intersect(firstLeadArea);
                secondLeadArea.subtract(pointRect2);
                continue;
            }
            pointRect2.intersect(secondLeadArea);
            firstLeadArea.subtract(pointRect2);
        }
    }

    private List<Line2D> split(CubicCurve2D curve, double segmentLength) {
        Point2D p1 = curve.getP1();
        Point2D p2 = curve.getP2();
        ArrayList<Line2D> res = new ArrayList<Line2D>();
        double length = Double.MAX_VALUE;
        if (p1.distance(p2) <= segmentLength) {
            length = this.calculateLength(curve, segmentLength / 10.0);
        }
        if (length <= segmentLength) {
            res.add(new Line2D.Double(p1, p2));
        } else {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            curve.subdivide(left, right);
            res.addAll(this.split(left, segmentLength));
            res.addAll(this.split(right, segmentLength));
        }
        return res;
    }

    private double calculateLength(CubicCurve2D curve, double precision) {
        Point2D p2;
        Point2D p1 = curve.getP1();
        double d = p1.distance(p2 = curve.getP2());
        if (d <= precision) {
            return d;
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double();
        CubicCurve2D.Double right = new CubicCurve2D.Double();
        curve.subdivide(left, right);
        return this.calculateLength(left, precision) + this.calculateLength(right, precision);
    }

    public boolean arePointsConnected(int index1, int index2) {
        return Math.abs(index1 - index2) == this.getControlPointCount() - 1;
    }
}

