/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.common.PCBLayer;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Solder Pad", category="Connectivity", author="Branislav Stojkovic", description="Copper solder pad, round or square", instanceNamePrefix="Pad", zOrder=3.1, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="PCB", transformer=SimpleComponentTransformer.class)
public class SolderPad
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size SIZE = new Size(Double.valueOf(0.09), SizeUnit.in);
    public static Size HOLE_SIZE = new Size(Double.valueOf(0.8), SizeUnit.mm);
    public static Color COLOR = Color.black;
    private Size size = SIZE;
    private Color color = COLOR;
    private Point point = new Point(0, 0);
    private Type type = Type.ROUND;
    private Size holeSize = HOLE_SIZE;
    private PCBLayer layer = PCBLayer._1;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        double diameter = this.getSize().convertToPixels();
        double holeDiameter = this.getHoleSize().convertToPixels();
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color);
        drawingObserver.startTrackingContinuityArea(true);
        if (this.type == Type.ROUND) {
            g2d.fill(new Ellipse2D.Double((double)this.point.x - diameter / 2.0, (double)this.point.y - diameter / 2.0, diameter, diameter));
        } else if (this.type == Type.OVAL_HORIZONTAL) {
            g2d.fill(new Ellipse2D.Double((double)this.point.x - diameter / 2.0, (double)this.point.y - diameter * 3.0 / 8.0, diameter, diameter * 3.0 / 4.0));
        } else if (this.type == Type.OVAL_VERTICAL) {
            g2d.fill(new Ellipse2D.Double((double)this.point.x - diameter * 3.0 / 8.0, (double)this.point.y - diameter / 2.0, diameter * 3.0 / 4.0, diameter));
        } else {
            g2d.fill(new Rectangle2D.Double((double)this.point.x - diameter / 2.0, (double)this.point.y - diameter / 2.0, diameter, diameter));
        }
        drawingObserver.stopTrackingContinuityArea();
        if (this.getHoleSize().getValue() > 0.0) {
            g2d.setColor(Constants.CANVAS_COLOR);
            g2d.fill(new Ellipse2D.Double((double)this.point.x - holeDiameter / 2.0, (double)this.point.y - holeDiameter / 2.0, holeDiameter, holeDiameter));
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int diameter = this.getClosestOdd(width / 2);
        int holeDiameter = 5;
        g2d.setColor(COLOR);
        g2d.fillOval((width - diameter) / 2, (height - diameter) / 2, diameter, diameter);
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval((width - holeDiameter) / 2, (height - holeDiameter) / 2, holeDiameter, holeDiameter);
    }

    @EditableProperty(validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @EditableProperty(name="Hole", validatorClass=PositiveMeasureValidator.class)
    public Size getHoleSize() {
        if (this.holeSize == null) {
            this.holeSize = HOLE_SIZE;
        }
        return this.holeSize;
    }

    public void setHoleSize(Size holeSize) {
        this.holeSize = holeSize;
    }

    @EditableProperty
    public PCBLayer getLayer() {
        if (this.layer == null) {
            this.layer = PCBLayer._1;
        }
        return this.layer;
    }

    public void setLayer(PCBLayer layer) {
        this.layer = layer;
    }

    public String getName() {
        return super.getName();
    }

    public int getControlPointCount() {
        return 1;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getLeadColor() {
        return this.color;
    }

    public void setLeadColor(Color color) {
        this.color = color;
    }

    @EditableProperty
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Void getValue() {
        return null;
    }

    public String getControlPointNodeName(int index) {
        return null;
    }

    public void setValue(Void value) {
    }

    public static enum Type {
        ROUND,
        SQUARE,
        OVAL_HORIZONTAL,
        OVAL_VERTICAL;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase().replace('_', ' ');
        }
    }
}

