/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.ShadedPaint;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.LineStyle;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractLeadedComponent<T>
extends AbstractTransparentComponent<T> {
    private static final long serialVersionUID = 1L;
    public static Color LEAD_COLOR = Color.decode("#CCCCCC");
    public static Color LEAD_COLOR_ICON = LEAD_COLOR.darker().darker();
    public static Size LEAD_THICKNESS = new Size(Double.valueOf(0.6), SizeUnit.mm);
    public static Size DEFAULT_SIZE = new Size(Double.valueOf(1.0), SizeUnit.in);
    protected Size length;
    protected Size width;
    protected Point[] points = new Point[]{new Point((int)(-DEFAULT_SIZE.convertToPixels() / 2.0), 0), new Point((int)(DEFAULT_SIZE.convertToPixels() / 2.0), 0), new Point(0, 0)};
    protected Color bodyColor = Color.white;
    protected Color borderColor = Color.black;
    protected Color labelColor = LABEL_COLOR;
    protected Color leadColor = LEAD_COLOR;
    protected Display display = Display.NAME;
    private boolean flipStanding = false;
    private LabelOriantation labelOriantation = LabelOriantation.Directional;
    protected boolean moveLabel = false;
    protected Double gamma = null;
    protected Double r = null;

    protected AbstractLeadedComponent() {
        try {
            this.length = this.getDefaultLength().clone();
            this.width = this.getDefaultWidth().clone();
        }
        catch (CloneNotSupportedException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.points[2] = this.calculateLabelPosition(this.points[0], this.points[1]);
    }

    protected boolean IsCopperArea() {
        return false;
    }

    protected Point[] getPoints() {
        if (this.points.length == 2) {
            this.points = new Point[]{this.points[0], this.points[1], this.calculateLabelPosition(this.points[0], this.points[1])};
            if (this.isStanding()) {
                this.display = Display.NONE;
            }
        }
        return this.points;
    }

    protected Point calculateLabelPosition(Point point1, Point point2) {
        double x = (double)(point1.x + point2.x) / 2.0;
        double y = (double)(point1.y + point2.y) / 2.0;
        return new Point((int)x, (int)y);
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        int offset;
        Color finalLabelColor;
        Color finalBorderColor;
        Theme theme;
        Rectangle shapeRect;
        double width;
        double length;
        if (this.gamma != null) {
            double x = (double)(this.getPoints()[1].x + this.getPoints()[0].x) / 2.0;
            double y = (double)(this.getPoints()[1].y + this.getPoints()[0].y) / 2.0;
            double theta = Math.atan2(this.getPoints()[1].y - this.getPoints()[0].y, this.getPoints()[1].x - this.getPoints()[0].x);
            double beta = this.gamma - (1.5707963267948966 - theta);
            this.getPoints()[2].setLocation(x + Math.cos(beta) * this.r, y + Math.sin(beta) * this.r);
            this.gamma = null;
            this.r = null;
        }
        double distance = this.getPoints()[0].distance(this.getPoints()[1]);
        Shape shape = this.getBodyShape();
        if (shape == null) {
            this.drawLead(g2d, componentState, drawingObserver, this.IsCopperArea());
            return;
        }
        AffineTransform oldTransform = g2d.getTransform();
        double theta = Math.atan2(this.getPoints()[1].y - this.getPoints()[0].y, this.getPoints()[1].x - this.getPoints()[0].x);
        if (this.isStanding()) {
            width = length = (double)this.getClosestOdd(this.width.convertToPixels());
            Ellipse2D.Double body = new Ellipse2D.Double((double)(this.getFlipStanding() ? this.getPoints()[1] : this.getPoints()[0]).x - width / 2.0, (double)(this.getFlipStanding() ? this.getPoints()[1] : this.getPoints()[0]).y - width / 2.0, width, width);
            shapeRect = body.getBounds();
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getStandingBodyColor());
            g2d.fill(body);
            g2d.setComposite(oldComposite);
            if (outlineMode) {
                theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
            } else {
                finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor;
            }
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            g2d.setColor(finalBorderColor);
            g2d.draw(body);
            if (!outlineMode) {
                this.drawLead(g2d, componentState, drawingObserver, false);
            }
        } else {
            shapeRect = shape.getBounds();
            if (!outlineMode) {
                float leadThickness = this.getLeadThickness();
                double leadLength = (distance - (double)this.calculatePinSpacing(shapeRect)) / 2.0;
                if (this.shouldShadeLeads()) {
                    Stroke leadStroke = ObjectCache.getInstance().fetchBasicStroke(leadThickness - 1.0f);
                    Color leadColor = this.getLeadColorForPainting(componentState);
                    Area leadArea = new Area();
                    int endX = (int)((double)this.getPoints()[0].x + Math.cos(theta) * leadLength);
                    int endY = (int)((double)this.getPoints()[0].y + Math.sin(theta) * leadLength);
                    Line2D.Double line = new Line2D.Double(this.getPoints()[0].x, this.getPoints()[0].y, endX, endY);
                    leadArea.add(new Area(leadStroke.createStrokedShape(line)));
                    endX = (int)((double)this.getPoints()[1].x + Math.cos(theta - Math.PI) * leadLength);
                    endY = (int)((double)this.getPoints()[1].y + Math.sin(theta - Math.PI) * leadLength);
                    line = new Line2D.Double(this.getPoints()[1].x, this.getPoints()[1].y, endX, endY);
                    leadArea.add(new Area(leadStroke.createStrokedShape(line)));
                    g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
                    g2d.setColor(leadColor);
                    g2d.fill(leadArea);
                    g2d.setColor(leadColor.darker());
                    g2d.draw(leadArea);
                } else {
                    g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(leadThickness));
                    Color leadColor = this.getLeadColorForPainting(componentState);
                    g2d.setColor(leadColor);
                    this.drawLeads(g2d, theta, leadLength);
                }
            }
            if (this.useShapeRectAsPosition()) {
                width = shapeRect.getHeight();
                length = shapeRect.getWidth();
            } else {
                width = this.getWidth().convertToPixels();
                length = this.getLength().convertToPixels();
            }
            g2d.translate(((double)(this.getPoints()[0].x + this.getPoints()[1].x) - length) / 2.0, ((double)(this.getPoints()[0].y + this.getPoints()[1].y) - width) / 2.0);
            g2d.rotate(theta, length / 2.0, width / 2.0);
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            if (this.bodyColor != null) {
                g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
                if (!outlineMode && ConfigurationManager.getInstance().readBoolean("hiQualityRender", false)) {
                    Point p1 = new Point((int)(length / 2.0), 0);
                    Point p2 = new Point((int)(length / 2.0), (int)width);
                    ShadedPaint paint = theta > 0.0 && theta < Math.PI ? new ShadedPaint(p2, p1, this.bodyColor) : new ShadedPaint(p1, p2, this.bodyColor);
                    Paint oldPaint = g2d.getPaint();
                    g2d.setPaint(paint);
                    g2d.fill(shape);
                    g2d.setPaint(oldPaint);
                } else {
                    g2d.fill(shape);
                }
            }
            Composite newComposite = null;
            if (!this.decorateAboveBorder()) {
                this.decorateComponentBody(g2d, outlineMode);
            } else {
                newComposite = g2d.getComposite();
            }
            g2d.setComposite(oldComposite);
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(this.getOutlineStrokeSize()));
            if (outlineMode) {
                theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
            } else {
                finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor;
            }
            g2d.setColor(finalBorderColor);
            g2d.draw(shape);
            if (this.decorateAboveBorder()) {
                g2d.setComposite(newComposite);
                this.decorateComponentBody(g2d, outlineMode);
                g2d.setComposite(oldComposite);
            }
        }
        g2d.setFont(project.getFont());
        if (this.useShapeRectAsPosition()) {
            g2d.translate(shapeRect.x, shapeRect.y);
        }
        if (outlineMode) {
            Theme theme2 = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme2.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.labelColor;
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        String label = "";
        String string = this.display == Display.NAME ? this.getName() : (label = this.getValue() == null ? "" : this.getValue().toString());
        if (this.display == Display.NONE) {
            label = "";
        }
        if (this.display == Display.BOTH) {
            label = this.getName() + " " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        Rectangle2D textRect = fontMetrics.getStringBounds(label, g2d);
        int n = offset = outlineMode ? 0 : this.getLabelOffset((int)length, (int)width, (int)textRect.getWidth());
        if (theta >= 1.5707963267948966 && theta <= Math.PI || theta < -1.5707963267948966 && theta > -Math.PI) {
            g2d.rotate(Math.PI, length / 2.0, width / 2.0);
            theta += Math.PI;
            offset = -offset;
        }
        if (this.getMoveLabel()) {
            g2d.setTransform(oldTransform);
            g2d.translate(this.getPoints()[2].x, this.getPoints()[2].y);
            if (this.getLabelOriantation() != LabelOriantation.Horizontal) {
                g2d.rotate(theta);
            }
            StringUtils.drawCenteredText(g2d, label, offset, 0, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            g2d.setTransform(oldTransform);
        } else if (this.isStanding() || this.getLabelOriantation() == LabelOriantation.Horizontal) {
            g2d.setTransform(oldTransform);
            double x = ((double)(this.getPoints()[0].x + this.getPoints()[1].x) - length) / 2.0;
            double y = ((double)(this.getPoints()[0].y + this.getPoints()[1].y) - width) / 2.0;
            g2d.drawString(label, (int)(x + (length - textRect.getWidth()) / 2.0 + (double)offset), (int)(y + (double)this.calculateLabelYOffset(shapeRect, textRect, fontMetrics)));
        } else {
            g2d.drawString(label, (int)(length - textRect.getWidth()) / 2 + offset, this.calculateLabelYOffset(shapeRect, textRect, fontMetrics));
            g2d.setTransform(oldTransform);
        }
    }

    protected boolean isStanding() {
        return this.supportsStandingMode() && this.length.convertToPixels() > this.getPoints()[0].distance(this.getPoints()[1]);
    }

    private void drawLeads(Graphics2D g2d, double theta, double leadLength) {
        double endX = (double)this.getPoints()[0].x + Math.cos(theta) * leadLength;
        double endY = (double)this.getPoints()[0].y + Math.sin(theta) * leadLength;
        g2d.draw(new Line2D.Double(this.getPoints()[0].x, this.getPoints()[0].y, endX, endY));
        endX = (double)this.getPoints()[1].x + Math.cos(theta - Math.PI) * leadLength;
        endY = (double)this.getPoints()[1].y + Math.sin(theta - Math.PI) * leadLength;
        g2d.draw(new Line2D.Double(this.getPoints()[1].x, this.getPoints()[1].y, endX, endY));
    }

    private void drawLead(Graphics2D g2d, ComponentState componentState, IDrawingObserver observer, boolean isCopperArea) {
        if (isCopperArea) {
            observer.startTrackingContinuityArea(true);
        }
        float thickness = this.getLeadThickness();
        Line2D.Double line = new Line2D.Double(this.getPoints()[0].x, this.getPoints()[0].y, this.getPoints()[1].x, this.getPoints()[1].y);
        if (this.shouldShadeLeads()) {
            thickness -= 1.0f;
        }
        Stroke stroke = null;
        switch (this.getStyle()) {
            case SOLID: {
                stroke = ObjectCache.getInstance().fetchBasicStroke(thickness);
                break;
            }
            case DASHED: {
                stroke = ObjectCache.getInstance().fetchStroke(thickness, new float[]{thickness * 2.0f, thickness * 4.0f}, thickness * 4.0f, 2);
                break;
            }
            case DOTTED: {
                stroke = ObjectCache.getInstance().fetchStroke(thickness, new float[]{thickness / 4.0f, thickness * 4.0f}, 0.0f, 1);
            }
        }
        if (this.shouldShadeLeads()) {
            Shape lineShape = stroke.createStrokedShape(line);
            g2d.setColor(this.getLeadColorForPainting(componentState));
            g2d.fill(lineShape);
            if (isCopperArea) {
                observer.stopTrackingContinuityArea();
            }
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            Color leadColor = this.getLeadColorForPainting(componentState);
            g2d.setColor(leadColor.darker());
            g2d.draw(lineShape);
        } else {
            g2d.setColor(this.getLeadColorForPainting(componentState));
            g2d.setStroke(stroke);
            g2d.draw(line);
            if (isCopperArea) {
                observer.stopTrackingContinuityArea();
            }
        }
    }

    protected LineStyle getStyle() {
        return LineStyle.SOLID;
    }

    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
    }

    protected boolean decorateAboveBorder() {
        return false;
    }

    protected int calculateLabelYOffset(Rectangle2D shapeRect, Rectangle2D textRect, FontMetrics fontMetrics) {
        return (int)(shapeRect.getHeight() - textRect.getHeight()) / 2 + fontMetrics.getAscent();
    }

    protected boolean shouldShadeLeads() {
        return true;
    }

    protected boolean supportsStandingMode() {
        return false;
    }

    protected int getLabelOffset(int bodyLength, int bodyWidth, int labelLength) {
        return 0;
    }

    protected float getOutlineStrokeSize() {
        return 1.0f;
    }

    protected abstract Size getDefaultLength();

    protected abstract Size getDefaultWidth();

    protected abstract Shape getBodyShape();

    protected boolean useShapeRectAsPosition() {
        return true;
    }

    protected float getLeadThickness() {
        return this.getClosestOdd(LEAD_THICKNESS.convertToPixels());
    }

    protected Color getLeadColorForPainting(ComponentState componentState) {
        return componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getLeadColor();
    }

    @EditableProperty(name="Lead Color")
    public Color getLeadColor() {
        if (this.leadColor == null) {
            this.leadColor = LEAD_COLOR_ICON;
        }
        return this.leadColor;
    }

    public void setLeadColor(Color leadColor) {
        this.leadColor = leadColor;
    }

    protected int calculatePinSpacing(Rectangle shapeRect) {
        return shapeRect.width;
    }

    public int getControlPointCount() {
        return this.getPoints().length;
    }

    public Point getControlPoint(int index) {
        return this.getPoints()[index];
    }

    public boolean isControlPointSticky(int index) {
        return index < 2;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return this.getMoveLabel() || index < 2 ? VisibilityPolicy.ALWAYS : VisibilityPolicy.NEVER;
    }

    public boolean canControlPointOverlap(int index) {
        return index >= 2;
    }

    public void setControlPoint(Point point, int index) {
        if (index < 2) {
            if (this.gamma == null) {
                double x = (double)(this.getPoints()[1].x + this.getPoints()[0].x) / 2.0;
                double y = (double)(this.getPoints()[1].y + this.getPoints()[0].y) / 2.0;
                double theta = Math.atan2(this.getPoints()[1].y - this.getPoints()[0].y, this.getPoints()[1].x - this.getPoints()[0].x);
                double beta = Math.atan2((double)this.getPoints()[2].y - y, (double)this.getPoints()[2].x - x);
                this.gamma = beta + (1.5707963267948966 - theta);
                this.r = this.getPoints()[2].distance(x, y);
            } else {
                this.gamma = null;
                this.r = null;
            }
        }
        this.getPoints()[index].setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    public Color getStandingBodyColor() {
        return this.bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Length", defaultable=true, validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getLength() {
        return this.length;
    }

    public void setLength(Size length) {
        this.length = length;
    }

    @EditableProperty(name="Width", defaultable=true, validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getWidth() {
        return this.width;
    }

    public void setWidth(Size width) {
        this.width = width;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Label Color")
    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty(name="Label Orientation")
    public LabelOriantation getLabelOriantation() {
        if (this.labelOriantation == null) {
            this.labelOriantation = LabelOriantation.Directional;
        }
        return this.labelOriantation;
    }

    public void setLabelOriantation(LabelOriantation labelOriantation) {
        this.labelOriantation = labelOriantation;
    }

    public String getInternalLinkName(int index1, int index2) {
        if (index1 == 0 && index2 == 1 || index2 == 0 && index1 == 1) {
            return this.getName();
        }
        return null;
    }

    public boolean getFlipStanding() {
        return this.flipStanding;
    }

    public void setFlipStanding(boolean flipStanding) {
        this.flipStanding = flipStanding;
    }

    @EditableProperty(name="Moveable Label")
    public boolean getMoveLabel() {
        return this.moveLabel;
    }

    public void setMoveLabel(boolean moveLabel) {
        this.moveLabel = moveLabel;
    }

    public String getControlPointNodeName(int index) {
        if (index >= 2) {
            return null;
        }
        return Integer.toString(index + 1);
    }

    public static enum LabelOriantation {
        Directional,
        Horizontal;

    }
}

