/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.plugins.cloud.presenter;

import com.diyfever.httpproxy.IFlatProxy;
import com.diyfever.httpproxy.PhpFlatProxy;
import com.diyfever.httpproxy.ProxyFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.PropertyWrapper;
import org.diylc.plugins.cloud.model.CommentEntity;
import org.diylc.plugins.cloud.model.IServiceAPI;
import org.diylc.plugins.cloud.model.ProjectEntity;
import org.diylc.plugins.cloud.model.UserEntity;
import org.diylc.plugins.cloud.presenter.CloudException;
import org.diylc.presenter.ComparatorFactory;
import org.diylc.presenter.ComponentProcessor;

public class CloudPresenter {
    public static final CloudPresenter Instance = new CloudPresenter();
    private static String USERNAME_KEY = "cloud.Username";
    private static String TOKEN_KEY = "cloud.token";
    private static String ERROR = "Error";
    private static final Logger LOG = Logger.getLogger(CloudPresenter.class);
    private static final Object SUCCESS = "Success";
    private IServiceAPI service;
    private String serviceUrl;
    private String machineId;
    private String[] categories;
    private boolean loggedIn = false;

    private CloudPresenter() {
    }

    private IServiceAPI getService() {
        if (this.service == null) {
            this.serviceUrl = ConfigurationManager.getInstance().readString("serviceUrl", "http://www.diy-fever.com/diylc/api/v1");
            ProxyFactory proxyFactory = new ProxyFactory((IFlatProxy)new PhpFlatProxy());
            this.service = (IServiceAPI)proxyFactory.createProxy(IServiceAPI.class, this.serviceUrl);
        }
        return this.service;
    }

    public boolean logIn(String string, String string2) throws CloudException {
        String string3;
        LOG.info((Object)("Trying to login to cloud as " + string));
        try {
            string3 = this.getService().login(string, string2, this.getMachineId());
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
        if (string3 == null || string3.equals(ERROR)) {
            LOG.info((Object)"Login failed");
            return false;
        }
        LOG.info((Object)"Login success");
        ConfigurationManager.getInstance().writeValue(USERNAME_KEY, (Object)string);
        ConfigurationManager.getInstance().writeValue(TOKEN_KEY, (Object)string3);
        this.loggedIn = true;
        return true;
    }

    public boolean tryLogInWithToken() throws CloudException {
        String string = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string2 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        if (string != null && string2 != null) {
            String string3;
            LOG.info((Object)("Trying to login to cloud using a token as " + string));
            try {
                string3 = this.getService().loginWithToken(string, string2, this.getMachineId());
            }
            catch (Exception exception) {
                throw new CloudException(exception);
            }
            if (string3 == null || string3.equals(ERROR)) {
                LOG.info((Object)"Login failed");
                return false;
            }
            LOG.info((Object)"Login success");
            this.loggedIn = true;
            return true;
        }
        return false;
    }

    public void logOut() {
        LOG.info((Object)"Logged out");
        ConfigurationManager.getInstance().writeValue(TOKEN_KEY, null);
        this.loggedIn = false;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public String[] getCategories() throws CloudException {
        if (this.categories == null) {
            LOG.info((Object)"Fetching categories");
            try {
                List<String> list = this.getService().getCategories();
                if (list != null && ((Object)list).equals(ERROR)) {
                    throw new CloudException("Could not fetch categories from the server.");
                }
                if (!(list instanceof List)) {
                    throw new CloudException("Unexpected server response received for category list: " + list.getClass().getName());
                }
                List<String> list2 = list;
                list2.add(0, "");
                this.categories = list2.toArray(new String[0]);
            }
            catch (Exception exception) {
                throw new CloudException(exception);
            }
        }
        return this.categories;
    }

    public void uploadProject(String string, String string2, String string3, String string4, String string5, File file, File file2, Integer n) throws IOException, CloudException {
        String string6 = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string7 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        if (string6 == null || string7 == null) {
            throw new CloudException("Login failed. Please try to login again.");
        }
        LOG.info((Object)("Uploading a new project: " + string));
        try {
            String string8 = this.getService().uploadProject(string6, string7, this.getMachineId(), string, string2, string3, string5, string4, file, file2, n);
            if (!string8.equals(SUCCESS)) {
                throw new CloudException(string8);
            }
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public void updateProjectDetails(ProjectEntity projectEntity, String string) throws IOException, CloudException {
        String string2 = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string3 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        if (string2 == null || string3 == null) {
            throw new CloudException("Login failed. Please try to login again.");
        }
        LOG.info((Object)("Updating project with projectId: " + projectEntity.getId()));
        try {
            String string4 = this.getService().uploadProject(string2, string3, this.getMachineId(), projectEntity.getName(), projectEntity.getCategoryForDisplay(), projectEntity.getDescription(), string, projectEntity.getKeywords(), null, null, projectEntity.getId());
            if (!string4.equals(SUCCESS)) {
                throw new CloudException(string4);
            }
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public void deleteProject(int n) throws CloudException {
        String string = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string2 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        if (string == null || string2 == null) {
            throw new CloudException("Login failed. Please try to login again.");
        }
        LOG.info((Object)("Deleting project with projectId: " + n));
        try {
            String string3 = this.getService().deleteProject(string, string2, this.getMachineId(), n);
            if (!string3.equals(SUCCESS)) {
                throw new CloudException(string3);
            }
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public void postComment(int n, String string) throws CloudException {
        String string2 = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string3 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        if (string2 == null || string3 == null) {
            throw new CloudException("Login failed. Please try to login again.");
        }
        LOG.info((Object)("Posting a new comment to projectId: " + n));
        try {
            String string4 = this.getService().postComment(string2, string3, this.getMachineId(), n, string);
            if (!string4.equals(SUCCESS)) {
                throw new CloudException(string4);
            }
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public void createUserAccount(String string, String string2, String string3, String string4, String string5) throws CloudException {
        LOG.info((Object)("Creating a new user: " + string));
        try {
            String string6 = this.getService().createUser(string, string2, string3, string4, string5);
            if (string6 == null) {
                throw new CloudException("Could not create user account.");
            }
            if (!SUCCESS.equals(string6)) {
                throw new CloudException(string6);
            }
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public UserEntity getUserDetails() throws CloudException {
        Object object;
        String string = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string2 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        LOG.info((Object)("Retreiving user details for: " + string));
        try {
            object = this.getService().getUserDetails(string, string2, this.getMachineId());
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
        if (object instanceof String) {
            throw new CloudException(object.toString());
        }
        if (object instanceof UserEntity) {
            return (UserEntity)object;
        }
        throw new CloudException("Unexpected server response received for category list: " + object.getClass().getName());
    }

    public String getCurrentUsername() {
        return ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
    }

    public void updatePassword(String string, String string2) throws CloudException {
        String string3;
        String string4 = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        LOG.info((Object)("Updating password for: " + string4));
        try {
            string3 = this.getService().updatePassword(string4, string, string2);
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
        if (!string3.equals(SUCCESS)) {
            throw new CloudException(string3);
        }
    }

    public void updateUserDetails(String string, String string2, String string3) throws CloudException {
        String string4;
        String string5 = ConfigurationManager.getInstance().readString(USERNAME_KEY, null);
        String string6 = ConfigurationManager.getInstance().readString(TOKEN_KEY, null);
        LOG.info((Object)("Updating user details for: " + string5));
        try {
            string4 = this.getService().updateUserDetails(string5, string6, this.getMachineId(), string, string2, string3);
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
        if (!string4.equals(SUCCESS)) {
            throw new CloudException(string4);
        }
    }

    public List<ProjectEntity> search(String string, String string2, String string3, int n, int n2) throws CloudException {
        LOG.info((Object)String.format("search(%1$s,%2$s,%3$s,%4$d,%5$d)", string, string2, string3, n, n2));
        try {
            Object object = this.getService().search(string, string2, n, n2, string3, null, null);
            return this.processResults(object);
        }
        catch (CloudException cloudException) {
            throw cloudException;
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public List<ProjectEntity> fetchUserUploads(Integer n) throws CloudException {
        UserEntity userEntity = this.getUserDetails();
        LOG.info((Object)("Fetching all user uploads for: " + userEntity.getUsername()));
        try {
            Object object = this.getService().search("", "", 1, Integer.MAX_VALUE, this.getSortings()[0], userEntity.getUsername(), n);
            return this.processResults(object);
        }
        catch (CloudException cloudException) {
            throw cloudException;
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    private List<ProjectEntity> processResults(Object object) throws CloudException, IOException {
        if (object == null) {
            throw new CloudException("Failed to retreive search results.");
        }
        if (object instanceof String) {
            throw new CloudException(object.toString());
        }
        if (object instanceof List) {
            List list = (List)object;
            LOG.info((Object)("Received " + list.size() + " results. Downloading thumbnails..."));
            for (ProjectEntity projectEntity : list) {
                String string = projectEntity.getThumbnailUrl();
                URL uRL = new URL(string);
                ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
                File file = File.createTempFile("thumbnail", ".png");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                projectEntity.setThumbnailUrl(file.getAbsolutePath());
                projectEntity.setCategories(this.getCategories());
                fileOutputStream.close();
            }
            LOG.info((Object)"Finished downloading thumbnails.");
            return list;
        }
        throw new CloudException("Unexpected server response received for search results: " + object.getClass().getName());
    }

    public String[] getSortings() throws CloudException {
        LOG.info((Object)"Fetching sortings");
        try {
            return this.getService().getSortings().toArray(new String[0]);
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public List<CommentEntity> getComments(int n) throws CloudException {
        LOG.info((Object)("Fetching comments for projectId: " + n));
        try {
            Object object = this.getService().getComments(n);
            if (object == null) {
                throw new CloudException("Failed to retreive search results.");
            }
            if (object instanceof String) {
                throw new CloudException(object.toString());
            }
            if (object instanceof List) {
                List list = (List)object;
                return list;
            }
            throw new CloudException("Unexpected server response received for comments: " + object.getClass().getName());
        }
        catch (Exception exception) {
            throw new CloudException(exception);
        }
    }

    public List<PropertyWrapper> getProjectProperties(ProjectEntity projectEntity) {
        List<PropertyWrapper> list = ComponentProcessor.getInstance().extractProperties(ProjectEntity.class);
        try {
            for (PropertyWrapper propertyWrapper : list) {
                propertyWrapper.readFrom(projectEntity);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"Could not get project entity properties", (Throwable)exception);
            return null;
        }
        Collections.sort(list, ComparatorFactory.getInstance().getDefaultPropertyComparator());
        return list;
    }

    private String getMachineId() {
        if (this.machineId == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
                byte[] byArray = networkInterface.getHardwareAddress();
                StringBuilder stringBuilder = new StringBuilder(18);
                for (byte by : byArray) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(':');
                    }
                    stringBuilder.append(String.format("%02x", by));
                }
                this.machineId = stringBuilder.toString();
            }
            catch (Exception exception) {
                this.machineId = "Generic";
            }
        }
        return this.machineId;
    }
}

