/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.netlist;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.diylc.core.IDIYComponent;
import org.diylc.netlist.Group;
import org.diylc.netlist.Netlist;
import org.diylc.netlist.Node;
import org.diylc.netlist.Summary;
import org.diylc.netlist.Tree;
import org.diylc.netlist.TreeConnectionType;
import org.diylc.netlist.TreeException;
import org.diylc.netlist.TreeLeaf;

public abstract class NetlistAnalyzer {
    public List<Summary> summarize(List<Netlist> list, Node node) throws TreeException {
        HashMap<String, Summary> hashMap = new HashMap<String, Summary>();
        for (Netlist netlist : list) {
            Summary summary = this.summarize(netlist, node);
            if (hashMap.containsKey(summary.getSummary())) {
                ((Summary)hashMap.get(summary.getSummary())).append(netlist);
                continue;
            }
            hashMap.put(summary.getSummary(), summary);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    protected abstract Summary summarize(Netlist var1, Node var2) throws TreeException;

    public Tree constructTreeBetween(Netlist netlist, Node node, Node node2) {
        Tree tree = new Tree(TreeConnectionType.Parallel);
        this.connectNodes(netlist, node, node2, tree.getChildren(), new Tree(TreeConnectionType.Series), new HashSet<Node>());
        return tree;
    }

    protected void connectNodes(Netlist netlist, Node node, Node node2, List<Tree> list, Tree tree, Set<Node> set) {
        if (node == node2) {
            list.add(tree);
            return;
        }
        Group group = this.findGroup(netlist, node);
        if (group == null) {
            return;
        }
        if (group.getNodes().contains(node2)) {
            list.add(tree);
            return;
        }
        set.addAll(group.getNodes());
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        for (Node node3 : group.getNodes()) {
            IDIYComponent<?> iDIYComponent = node3.getComponent();
            for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                if (i == node3.getPointIndex() || iDIYComponent.getInternalLinkName(i, node3.getPointIndex()) == null) continue;
                TreeLeaf treeLeaf = new TreeLeaf(iDIYComponent, i, node3.getPointIndex());
                Node node4 = new Node(iDIYComponent, i);
                if (set.contains(node4)) continue;
                Tree tree2 = null;
                try {
                    tree2 = (Tree)tree.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                Tree tree3 = new Tree(treeLeaf);
                if (!tree2.getChildren().contains(tree3)) {
                    tree2.getChildren().add(tree3);
                }
                HashSet<Node> hashSet = new HashSet<Node>(set);
                this.connectNodes(netlist, node4, node2, arrayList, tree2, hashSet);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() == 1) {
            if (((Tree)arrayList.get(0)).getConnectionType() == TreeConnectionType.Series) {
                tree.getChildren().clear();
                tree.getChildren().addAll(((Tree)arrayList.get(0)).getChildren());
            } else {
                tree.getChildren().add((Tree)arrayList.get(0));
            }
            list.add(tree);
            return;
        }
        this.mergePaths(arrayList, false);
        list.addAll(arrayList);
    }

    protected void mergePaths(List<Tree> list, boolean bl) {
        Serializable serializable;
        HashMap<Tree, Integer> hashMap = new HashMap<Tree, Integer>();
        for (Tree object : list) {
            if (object.getConnectionType() != TreeConnectionType.Series) continue;
            Tree tree = object.getChildren().get(bl ? object.getChildren().size() - 1 : 0);
            serializable = (Integer)hashMap.get(tree);
            hashMap.put(tree, serializable == null ? 1 : (Integer)serializable + 1);
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list);
        for (Map.Entry entry : hashMap.entrySet()) {
            Tree tree7;
            Iterator<Object> iterator;
            boolean bl2;
            int n;
            Tree tree2;
            Tree tree32;
            if ((Integer)entry.getValue() <= 1) continue;
            serializable = new ArrayList();
            for (Tree tree32 : list) {
                tree2 = tree32.getChildren().get(bl ? tree32.getChildren().size() - 1 : 0);
                if (!tree2.equals(entry.getKey())) continue;
                serializable.add(tree32);
            }
            arrayList.removeAll((Collection<?>)((Object)serializable));
            Tree tree4 = new Tree(new ArrayList<Tree>(), TreeConnectionType.Series);
            tree32 = new Tree(new ArrayList<Tree>(), TreeConnectionType.Series);
            tree2 = (Tree)entry.getKey();
            for (n = 0; n < ((Tree)serializable.get(0)).getChildren().size(); ++n) {
                bl2 = true;
                tree2 = ((Tree)serializable.get(0)).getChildren().get(bl ? ((Tree)serializable.get(0)).getChildren().size() - n - 1 : n);
                iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    tree7 = (Tree)iterator.next();
                    if (tree7.getChildren().size() > n && tree7.getChildren().get(bl ? tree7.getChildren().size() - n - 1 : n).equals(tree2)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) break;
                ((Tree)(bl ? tree32 : tree4)).getChildren().add(tree2);
            }
            for (n = 0; n < ((Tree)serializable.get(0)).getChildren().size(); ++n) {
                bl2 = true;
                tree2 = ((Tree)serializable.get(0)).getChildren().get(bl ? n : ((Tree)serializable.get(0)).getChildren().size() - n - 1);
                iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    tree7 = (Tree)iterator.next();
                    if (tree7.getChildren().size() > n && tree7.getChildren().get(bl ? 0 : tree7.getChildren().size() - 1).equals(tree2)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) break;
                ((Tree)(bl ? tree4 : tree32)).getChildren().add(tree2);
            }
            if (tree4.getChildren().isEmpty() && tree32.getChildren().isEmpty()) continue;
            Tree tree5 = new Tree(new ArrayList<Tree>(), TreeConnectionType.Series);
            Tree tree6 = new Tree(new ArrayList<Tree>((Collection<Tree>)((Object)serializable)), TreeConnectionType.Parallel);
            if (!tree4.getChildren().isEmpty()) {
                tree5.getChildren().add(tree4);
                for (Tree tree7 : tree6.getChildren()) {
                    tree7.trimChildrenLeft(tree4.getChildren().size());
                }
            }
            tree5.getChildren().add(tree6);
            if (!tree32.getChildren().isEmpty()) {
                tree5.getChildren().add(tree32);
                for (Tree tree7 : tree6.getChildren()) {
                    tree7.trimChildrenRight(tree32.getChildren().size());
                }
            }
            list.removeAll((Collection<?>)((Object)serializable));
            list.add(tree5);
        }
        if (!bl && !arrayList.isEmpty()) {
            list.removeAll(arrayList);
            this.mergePaths((List<Tree>)arrayList, true);
            list.addAll((Collection<Tree>)arrayList);
        }
    }

    protected Group findGroup(Netlist netlist, Node node) {
        for (Group group : netlist.getGroups()) {
            if (!group.getNodes().contains(node)) continue;
            return group;
        }
        return null;
    }

    protected List<Node> find(Set<String> set, String string, Netlist netlist) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Group group : netlist.getGroups()) {
            for (Node node : group.getNodes()) {
                if (!set.contains(node.getComponent().getClass().getCanonicalName()) || string != null && !node.getDisplayName().equalsIgnoreCase(string)) continue;
                arrayList.add(node);
            }
        }
        return arrayList;
    }

    protected String extractName(IDIYComponent<?> iDIYComponent) {
        return iDIYComponent.getName() + " " + iDIYComponent.getValueForDisplay();
    }

    public static List<Set<IDIYComponent<?>>> extractComponentGroups(List<Netlist> list) {
        ArrayList arrayList = new ArrayList();
        for (Netlist netlist : list) {
            arrayList.addAll(NetlistAnalyzer.extractComponentGroups(netlist));
        }
        return arrayList;
    }

    public static List<Set<IDIYComponent<?>>> extractComponentGroups(Netlist netlist) {
        ArrayList arrayList = new ArrayList();
        for (Group group : netlist.getGroups()) {
            HashSet hashSet = new HashSet();
            for (Node node : group.getNodes()) {
                hashSet.add(node.getComponent());
            }
            arrayList.add(hashSet);
        }
        return arrayList;
    }

    public static Set<IDIYComponent<?>> extractComponents(Netlist netlist) {
        HashSet hashSet = new HashSet();
        for (Group group : netlist.getGroups()) {
            for (Node node : group.getNodes()) {
                hashSet.add(node.getComponent());
            }
        }
        return hashSet;
    }

    protected int find(Node node, List<Group> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getNodes().contains(node)) continue;
            return i;
        }
        return -1;
    }

    protected boolean intersect(List<Group> list, Node node) {
        for (Group group : list) {
            if (!group.getNodes().contains(node)) continue;
            return true;
        }
        return false;
    }

    protected Node intersect(List<Group> list, Group group) {
        for (Group group2 : list) {
            for (Node node : group.getNodes()) {
                if (!group2.getNodes().contains(node)) continue;
                return node;
            }
        }
        return null;
    }
}

