/*
 * Decompiled with CFR 0.152.
 */
package com.diyfever.httpproxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class ClientHttpRequest {
    URLConnection connection;
    OutputStream os = null;
    Map cookies = new HashMap();
    private static Random random = new Random();
    String boundary = "---------------------------" + ClientHttpRequest.randomString() + ClientHttpRequest.randomString() + ClientHttpRequest.randomString();

    protected void connect() throws IOException {
        if (this.os == null) {
            this.os = this.connection.getOutputStream();
        }
    }

    protected void write(char c) throws IOException {
        this.connect();
        this.os.write(c);
    }

    protected void write(String string) throws IOException {
        this.connect();
        this.os.write(string.getBytes());
    }

    protected void newline() throws IOException {
        this.connect();
        this.write("\r\n");
    }

    protected void writeln(String string) throws IOException {
        this.connect();
        this.write(string);
        this.newline();
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this.boundary);
    }

    public ClientHttpRequest(URLConnection uRLConnection) throws IOException {
        this.connection = uRLConnection;
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public ClientHttpRequest(URL uRL) throws IOException {
        this(uRL.openConnection());
    }

    public ClientHttpRequest(String string) throws IOException {
        this(new URL(string));
    }

    private void postCookies() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.cookies.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey().toString() + "=" + entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("; ");
        }
        if (stringBuffer.length() > 0) {
            this.connection.setRequestProperty("Cookie", stringBuffer.toString());
        }
    }

    public void setCookie(String string, String string2) throws IOException {
        this.cookies.put(string, string2);
    }

    public void setCookies(Map map) throws IOException {
        if (map == null) {
            return;
        }
        this.cookies.putAll(map);
    }

    public void setCookies(String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            this.setCookie(stringArray[i], stringArray[i + 1]);
        }
    }

    private void writeName(String string) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(string);
        this.write('\"');
    }

    public void setParameter(String string, String string2) throws IOException {
        this.boundary();
        this.writeName(string);
        this.newline();
        this.newline();
        this.writeln(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[500000];
        int n = 0;
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
        }
        outputStream.flush();
        byArray = null;
    }

    public void setParameter(String string, String string2, InputStream inputStream) throws IOException {
        this.boundary();
        this.writeName(string);
        this.write("; filename=\"");
        this.write(string2);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String string3 = URLConnection.guessContentTypeFromName(string2);
        if (string3 == null) {
            string3 = "application/octet-stream";
        }
        this.writeln(string3);
        this.newline();
        ClientHttpRequest.pipe(inputStream, this.os);
        this.newline();
    }

    public void setParameter(String string, File file) throws IOException {
        this.setParameter(string, file.getPath(), new FileInputStream(file));
    }

    public void setParameter(String string, Object object) throws IOException {
        if (object instanceof File) {
            this.setParameter(string, (File)object);
        } else {
            this.setParameter(string, object.toString());
        }
    }

    public void setParameters(Map map) throws IOException {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.setParameter(entry.getKey().toString(), entry.getValue());
        }
    }

    public void setParameters(Object[] objectArray) throws IOException {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            this.setParameter(objectArray[i].toString(), objectArray[i + 1]);
        }
    }

    public InputStream post() throws IOException {
        this.boundary();
        this.writeln("--");
        this.os.close();
        return this.connection.getInputStream();
    }

    public InputStream post(Map map) throws IOException {
        this.setParameters(map);
        return this.post();
    }

    public InputStream post(Object[] objectArray) throws IOException {
        this.setParameters(objectArray);
        return this.post();
    }

    public InputStream post(Map map, Map map2) throws IOException {
        this.setCookies(map);
        this.setParameters(map2);
        return this.post();
    }

    public InputStream post(String[] stringArray, Object[] objectArray) throws IOException {
        this.setCookies(stringArray);
        this.setParameters(objectArray);
        return this.post();
    }

    public InputStream post(String string, Object object) throws IOException {
        this.setParameter(string, object);
        return this.post();
    }

    public InputStream post(String string, Object object, String string2, Object object2) throws IOException {
        this.setParameter(string, object);
        return this.post(string2, object2);
    }

    public InputStream post(String string, Object object, String string2, Object object2, String string3, Object object3) throws IOException {
        this.setParameter(string, object);
        return this.post(string2, object2, string3, object3);
    }

    public InputStream post(String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4) throws IOException {
        this.setParameter(string, object);
        return this.post(string2, object2, string3, object3, string4, object4);
    }

    public static InputStream post(URL uRL, Map map) throws IOException {
        return new ClientHttpRequest(uRL).post(map);
    }

    public static InputStream post(URL uRL, Object[] objectArray) throws IOException {
        return new ClientHttpRequest(uRL).post(objectArray);
    }

    public static InputStream post(URL uRL, Map map, Map map2) throws IOException {
        return new ClientHttpRequest(uRL).post(map, map2);
    }

    public static InputStream post(URL uRL, String[] stringArray, Object[] objectArray) throws IOException {
        return new ClientHttpRequest(uRL).post(stringArray, objectArray);
    }

    public static InputStream post(URL uRL, String string, Object object) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object);
    }

    public static InputStream post(URL uRL, String string, Object object, String string2, Object object2) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object, string2, object2);
    }

    public static InputStream post(URL uRL, String string, Object object, String string2, Object object2, String string3, Object object3) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object, string2, object2, string3, object3);
    }

    public static InputStream post(URL uRL, String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4) throws IOException {
        return new ClientHttpRequest(uRL).post(string, object, string2, object2, string3, object3, string4, object4);
    }
}

