/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.userdialog;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.swing.action.ActionConfiguration;
import net.disy.commons.swing.action.IActionConfiguration;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogResources;
import net.disy.commons.swing.dialog.core.AbstractDialog;
import net.disy.commons.swing.dialog.core.DialogResult;
import net.disy.commons.swing.dialog.core.IDialogResult;
import net.disy.commons.swing.dialog.userdialog.DefaultDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.DialogPageControl;
import net.disy.commons.swing.dialog.userdialog.IDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.IUserDialogContainer;
import net.disy.commons.swing.dialog.userdialog.buttons.IDialogButtonConfiguration;
import net.disy.commons.swing.dialog.userdialog.page.IDialogPage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;
import net.disy.commons.swing.util.GuiUtilities;
import net.disy.commons.swing.util.RelativePosition;

public class UserDialog
extends AbstractDialog
implements IUserDialogContainer {
    private final DialogPageControl dialogControl;
    private JButton okButton;
    private JButton cancelButton;
    private boolean neverVisualized = true;
    private final RelativePosition relativePosition;

    public UserDialog(Component parentComponent, IDialogConfiguration userDialog) {
        this(parentComponent, userDialog, RelativePosition.CENTER);
    }

    public UserDialog(Component parentComponent, IDialogConfiguration userDialog, RelativePosition relativePosition) {
        super(parentComponent, userDialog);
        this.dialogControl = new DialogPageControl((IDialogPage)userDialog.getDialogPage());
        userDialog.setUserDialogContainer(this);
        this.dialogControl.setUserDialogContainer(this);
        this.initialize();
        this.setContent(this.dialogControl.getContent());
        this.updateAll();
        this.dialogControl.requestFocus();
        this.relativePosition = relativePosition;
    }

    public UserDialog(Component parentComponent, IDialogPage dialogPage) {
        this(parentComponent, new DefaultDialogConfiguration<IDialogPage>(dialogPage));
    }

    protected IDialogConfiguration getConfiguration() {
        return (IDialogConfiguration)this.getGenericDialog();
    }

    private void updateAll() {
        this.updateDescription();
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
    }

    @Override
    public void updateDescription() {
        this.setDescription(this.getDialogControl().getDescription());
    }

    @Override
    public void updateTitle() {
        this.setTitle(this.getDialogControl().getTitle());
    }

    @Override
    public void updateMessage() {
        this.setMessage(this.getDialogControl().getMessage());
    }

    @Override
    public void updateButtons() {
        this.okButton.setEnabled(this.getDialogControl().canFinish());
    }

    @Override
    protected JComponent createButtonBar() {
        JComponent[] createdButtons = this.createButtons();
        if (createdButtons.length > 0 && createdButtons[0] instanceof JButton) {
            this.setDefaultButton((JButton)createdButtons[0]);
        }
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder(LayoutDirection.HORIZONTAL);
        for (int i = 0; i < createdButtons.length; ++i) {
            buttonPanelBuilder.add(createdButtons[i]);
        }
        JPanel buttonPanel = buttonPanelBuilder.createPanel();
        JComponent leftComponent = this.getConfiguration().createOptionalButtonPanelLeftComponent();
        if (leftComponent == null) {
            return buttonPanel;
        }
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add(leftComponent);
        panel.add((Component)buttonPanel, GridDialogLayoutData.FILL_HORIZONTAL);
        return panel;
    }

    protected final JComponent[] createButtons() {
        IDialogButtonConfiguration buttonConfiguration = this.getConfiguration().getButtonConfiguration();
        IActionConfiguration okActionConfiguration = buttonConfiguration.getOkActionConfiguration();
        SmartAction okAction = new SmartAction(okActionConfiguration != null ? okActionConfiguration : new ActionConfiguration()){

            @Override
            protected void execute(Component parentComponent) {
                UserDialog.this.requestFinish();
            }
        };
        this.okButton = new JButton(okAction);
        IActionConfiguration cancelActionConfiguration = buttonConfiguration.getCancelActionConfiguration();
        SmartAction cancelAction = new SmartAction(cancelActionConfiguration != null ? cancelActionConfiguration : new ActionConfiguration()){

            @Override
            protected void execute(Component parentComponent) {
                UserDialog.this.performCancel();
            }
        };
        this.cancelButton = new JButton(cancelAction);
        SmartAction helpAction = new SmartAction(BasicDialogResources.HELP_TEXT_SMART){

            @Override
            protected void execute(Component parentComponent) {
                UserDialog.this.helpPressed();
            }
        };
        JButton helpButton = new JButton(helpAction);
        ArrayList<JComponent> buttonList = new ArrayList<JComponent>();
        if (okActionConfiguration != null) {
            buttonList.add(this.okButton);
        }
        JComponent[] additionalButtons = this.getConfiguration().createAdditionalButtons();
        buttonList.addAll(Arrays.asList(additionalButtons));
        buttonList.addAll(Arrays.asList(this.createAdditionalButtons()));
        if (cancelActionConfiguration != null) {
            buttonList.add(this.cancelButton);
        }
        if (this.getDialogControl().isHelpAvailable()) {
            buttonList.add(helpButton);
        }
        return buttonList.toArray(new JComponent[buttonList.size()]);
    }

    protected JComponent[] createAdditionalButtons() {
        return new JComponent[0];
    }

    protected boolean okPressed() {
        if (!this.getDialogControl().performOk()) {
            return false;
        }
        return this.getConfiguration().performOk(this.getDialog().getWindow());
    }

    protected void helpPressed() {
        this.getDialogControl().performHelp();
    }

    public DialogPageControl getDialogControl() {
        return this.dialogControl;
    }

    @Override
    protected boolean cancelPressed() {
        if (!this.getDialogControl().performCancel()) {
            return false;
        }
        return this.getConfiguration().performCancel(this.getDialog().getWindow());
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.neverVisualized) {
                GuiUtilities.placeRelativeToOwner(this.getDialog().getWindow(), this.relativePosition);
                Object page = this.getConfiguration().getDialogPage();
                page.enter();
                this.getDialog().show();
                this.neverVisualized = false;
            } else {
                Object page = this.getConfiguration().getDialogPage();
                page.enter();
                this.getDialog().show();
            }
        } else {
            this.closeDialog();
        }
    }

    @Override
    public IDialogResult show() {
        this.setVisible(true);
        return new DialogResult(this.isCanceled());
    }

    @Override
    public final void requestFinish() {
        GuiUtilities.stopCellEditing(this.getDialog().getContentPane());
        if (!this.getDialogControl().canFinish()) {
            return;
        }
        if (this.okPressed()) {
            this.closeDialog();
            this.getConfiguration().performAfterDispose(false);
        }
    }

    @Override
    protected void closeDialog() {
        super.closeDialog();
        Object page = this.getConfiguration().getDialogPage();
        page.leave();
        page.dispose();
    }

    @Override
    public void showNonModal() {
        this.getDialog().setModal(false);
        this.setVisible(true);
    }
}

