/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pixelplate;

import de.jave.gui.button.ModernToggleButtonFactory;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.MixCharactersPanel;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateFeltPenMode;
import de.jave.jave.pixelplate.PixelPlateMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.button.SmartButtonGroup;
import net.disy.commons.swing.color.SwingColors;
import net.disy.commons.swing.component.VerticalLine;
import net.disy.commons.swing.fontchooser.util.FontUtilities;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public class PixelPlateOptionsPanel
extends JPanel {
    private final SmartButtonGroup sizeButtonGroup;
    private final SmartButtonGroup styleButtonGroup;
    private static double[] CURSOR_DIAMETER = new double[]{1.9, 2.5, 3.2, 4.0};

    public PixelPlateOptionsPanel(BooleanModel mixCharactersModel) {
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new FlowLayout(1, 0, 2));
        this.sizeButtonGroup = new SmartButtonGroup();
        JToggleButton bs0 = this.createToggleButton(JaveIcons.PENCIL1, JaveIcons.PENCIL1_DISABLED);
        this.sizeButtonGroup.add(bs0);
        sizePanel.add(bs0);
        sizePanel.add(new VerticalLine());
        JToggleButton bs1 = this.createToggleButton(JaveIcons.PENCIL4, JaveIcons.PENCIL4_DISABLED);
        this.sizeButtonGroup.add(bs1);
        sizePanel.add(bs1);
        JToggleButton bs2 = this.createToggleButton(JaveIcons.PENCIL5, JaveIcons.PENCIL5_DISABLED);
        this.sizeButtonGroup.add(bs2);
        sizePanel.add(bs2);
        JToggleButton bs3 = this.createToggleButton(JaveIcons.PENCIL6, JaveIcons.PENCIL6_DISABLED);
        this.sizeButtonGroup.add(bs3);
        sizePanel.add(bs3);
        JToggleButton bs4 = this.createToggleButton(JaveIcons.PENCIL7, JaveIcons.PENCIL7_DISABLED);
        this.sizeButtonGroup.add(bs4);
        sizePanel.add(bs4);
        bs0.setSelected(true);
        JPanel stylePanel = new JPanel(new FlowLayout(1, 0, 2));
        this.styleButtonGroup = new SmartButtonGroup();
        for (int i = 0; i < PixelPlate.FELTPEN_CHARS.length; ++i) {
            JToggleButton toggleButton = PixelPlateOptionsPanel.createStyleToggleButton(PixelPlate.FELTPEN_CHARS[i]);
            this.styleButtonGroup.add(toggleButton);
            stylePanel.add(toggleButton);
        }
        this.styleButtonGroup.setSelectedIndex(4);
        this.setLayout(new GridDialogLayout(1, false));
        this.add((Component)sizePanel, GridDialogLayoutData.FILL_HORIZONTAL);
        this.add((Component)stylePanel, GridDialogLayoutData.FILL_HORIZONTAL);
        this.add((Component)new MixCharactersPanel(mixCharactersModel).getContent(), GridDialogLayoutData.FILL_HORIZONTAL);
    }

    private static JToggleButton createStyleToggleButton(char character) {
        JToggleButton button = ModernToggleButtonFactory.createModernToggleButton();
        button.setIcon(PixelPlateOptionsPanel.createCharacterIcon(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH, character));
        button.setPreferredSize(new Dimension(16, 19));
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private static Icon createCharacterIcon(final Font font, final char character) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(SwingColors.getTextAreaForegroundColor());
                g.setFont(font);
                FontMetrics fontMetrics = g.getFontMetrics();
                String text = String.valueOf(character);
                int stringWidth = fontMetrics.stringWidth(text);
                int dx = (this.getIconWidth() - stringWidth) / 2;
                g.drawString(text, x + dx, y + fontMetrics.getAscent());
            }

            @Override
            public int getIconWidth() {
                Rectangle2D bounds = font.getMaxCharBounds(FontUtilities.DEFAULT_FONT_RENDER_CONTEXT);
                return (int)Math.ceil(bounds.getWidth());
            }

            @Override
            public int getIconHeight() {
                Rectangle2D bounds = font.getMaxCharBounds(FontUtilities.DEFAULT_FONT_RENDER_CONTEXT);
                return (int)Math.ceil(bounds.getHeight());
            }
        };
    }

    private JToggleButton createToggleButton(Icon icon, Icon disabledIcon) {
        JToggleButton button = ModernToggleButtonFactory.createModernToggleButton();
        button.setIcon(icon);
        button.setDisabledIcon(disabledIcon);
        return button;
    }

    public boolean isFeltpenMode() {
        return this.getSelectedSize() > 0;
    }

    public boolean isLineMode() {
        return this.getSelectedSize() == 0;
    }

    public double getFeltpenPreviewDiameter() {
        return CURSOR_DIAMETER[this.getSelectedSize() - 1];
    }

    public void configure(PixelPlate pixelPlate) {
        int size;
        int feltPenSize = size = this.getSelectedSize();
        char feltPenChar = PixelPlate.FELTPEN_CHARS[this.styleButtonGroup.getSelectedIndex()];
        if (size == 0) {
            if (feltPenChar == ':') {
                pixelPlate.setMode(PixelPlateMode.DOT);
            } else {
                pixelPlate.setMode(PixelPlateMode.PIXEL);
            }
        } else {
            pixelPlate.setMode(new PixelPlateFeltPenMode(feltPenChar, feltPenSize));
        }
    }

    private int getSelectedSize() {
        return this.sizeButtonGroup.getSelectedIndex();
    }
}

