/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.filter;

import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.filter.FilterMatrix;
import de.jave.jave.filter.FilterMode;
import de.jave.lib.CharacterPlate;
import java.awt.Insets;
import net.disy.commons.core.util.Ensure;

public class Filter {
    private static final String[] FILTER_IMAGE2ASCII_SIMPLE_EDGE = new String[]{"7171", "?\\_____", "?``--..", "7171", "_____/?", ",,--''?", "5151", "\\____", "``--.", "5151", "____/", ",--''", "5151", "\\___?", "`--.?", "5151", "?___/", "?,--'", "3131", "\\__", "`-.", "3131", "__/", ",-'", "5131", "?\\___", "`-.", "5131", "___/?", ",-'", "5331", "???!??_/??!????", ",'?", "5331", "!?????\\_?????!?", "`.?", "3311", "_\\??\\\\?? ", "`", "3311", "?/_//? ??", "'"};
    private static final String[] FILTER_LINE_ART_CLEANER = new String[]{"3311", "?? ?/'???", ",", "3333", " ??'\\????", "???`.????", "3311", " ??`\\????", ".", "3311", "??,,-????", "'", "3311", "?| ?/? |?", "|", "3311", " |??\\??| ", "|", "3311", "?| ?/? '?", "|", "3311", "??_?, ???", "/", "3311", "??_.-????", "'", "3311", "? ?-| ?|?", ".", "3311", "_?? -.???", "`", "3311", "??_,-????", "'", "3333", "???'-_???", "???`.????", "3311", "  |?|?/ ?", "/", "3311", "??',- ???", "'", "3333", "? ' ' !??", "??/?/????", "3311", "?|?? .???", "`", "3311", "?|?- ????", "'", "3311", "?|?? -???", "`", "3311", "???? -?|?", ",", "3311", "???- ??|?", ".", "3311", "? ! ' ! ?", "/", "3333", "._ ? .???", "? ??`????", "3311", "\\?? -.???", "`", "3311", "??_ - '??", "/", "3311", "???`_???!", ".", "3311", "!  ?'!???", "`", "3333", "'.??\\????", "`???|????", "3333", "`.??\\????", "????|????", "3333", "?.'?/????", "????|????", "3311", "?,?/' ???", " ", "3311", ".?  -. ??", "`", "3311", "   ?|'?!?", ",", "3311", "!?  -  ?!", "\\", "3311", "?_?''????", " ", "5533", "??????? _! _- ?!?????????", "???,'????", "3311", "  /?\\ ???", "(", "3311", "???`- ??\\", ".", "3311", " ?? !'!  ", ",", "3311", "!   !   !", "\\", "3311", "  ! ! !  ", "/", "3311", "   _!,   ", ",", "3333", "  !_-    ", "???,'????", "3311", "?? `-_ ??", ".", "3311", "?  ?/-? ?", ",", "3311", "  ?-\\?? ?", ".", "3311", "?!? '\\???", " ", "3311", "    !_ | ", ",", "3311", "?|?/! ?  ", " ", "3311", "? !,- ?  ", "'", "3311", "?  !` ? !", ".", "3311", "?? -- ??\\", ".", "3333", " _,- ?? ?", "? ??'????", "3311", " !? \\.?? ", "`", "3311", "!??`\\????", ".", "3311", "?! ,/?? ??", "'", "3311", " ?? --!??", ",", "5533", "??????! ??? -_ ?? ?!?????", "????`.???", "3311", "???!_ ?\\?", " ", "5511", "??????????? _-'?!????????", ","};
    private static final String[] FILTER_POST = new String[]{"7553", "??????????????--\\???????\\--????????", "?????._?????''?", "7553", "?????????????????/--?--/???????????", "???????_.?''???", "5533", "?????-\\?????\\-????????????", ".???'????", "5533", "???????/-?-/?????????????", "?,?'?????", "5533", "?????-\\?????\\\\?????\\?????", ".???`.???", "5533", "?????????/??//?-/????????", "????,''??", "5533", "????????/-?//??/?????????", "??,,'????", "5533", "?????\\?????\\\\?????\\-?????", "???`.???'", "5533", "?!?????\\????\\?????!??????", "?:??:????", "5533", "???!???/????/???!????????", "?;??;????", "5533", "????????!??//??!?????????", "???,'????", "5533", "?????!?????\\\\?????!??????", "???`.????", "3311", "???\\-/???", "_", "3333", "???/-\\???", "?_?? ????", "3311", "?!??\\???!", ":", "3311", "??!?/??!?", ";", "3311", "!???\\??!?", ":", "3311", "?!??/?!??", ";", "3311", "!???\\-???", "`", "3311", "??!-/????", "'", "3311", "???-\\???!", ".", "3311", "????/-!??", ",", "3311", "??!?< ??!", "(", "3311", "!?? >?!??", ")", "3311", "!?!?V????", "'", "3311", "????^?!?!", "."};
    private static final String[] FILTER_PRE = new String[]{"3311", "  ? ##?#?", " ", "3311", "?#?## ?  ", " ", "3311", "?  ## ?#?", " ", "3311", "?#? ##  ?", " "};
    private static final String[] FILTER_MID = new String[]{"3311", "????#!?!?", "+", "3311", "???!#??!?", "+", "3311", "?!?!#????", "+", "3311", "?!??#!???", "+", "3311", "  ??#!  ?", "-", "3311", "?  !#??  ", "-", "3311", "? ?!#!? ?", "-", "3311", "?!? #  ? ", "|", "3311", " ?  # ?!?", "|", "3311", "?!? # ?!?", "|", "3311", "! ! # ! !", "X", "3311", "  ! #?  !", "<", "3311", "!  ?# !  ", ">", "3311", "!?! #    ", "V", "3311", "    # !?!", "^", "3311", "! !?#??!?", "|", "3311", "?!??#?! !", "|", "3311", "????# ? !", "\\", "3311", "??? #?! ?", "/", "3311", "! ? #????", "\\", "3311", "? !?# ???", "/", "3311", "    #    ", "+"};
    private static FilterMatrix[] postFilters;
    private static FilterMatrix[] preFilters;
    private static FilterMatrix[] midFilters;
    private static FilterMatrix[] lineArtCleanerFilters;
    private static FilterMatrix[] image2asciiSimpleEdgeFilters;
    private static boolean initialized;

    public static void init() {
        int i;
        if (initialized) {
            return;
        }
        initialized = true;
        postFilters = new FilterMatrix[FILTER_POST.length / 3];
        for (i = 0; i < FILTER_POST.length / 3; ++i) {
            Filter.postFilters[i] = new FilterMatrix(FILTER_POST[i * 3], FILTER_POST[i * 3 + 1], FILTER_POST[i * 3 + 2]);
        }
        preFilters = new FilterMatrix[FILTER_PRE.length / 3];
        for (i = 0; i < FILTER_PRE.length / 3; ++i) {
            Filter.preFilters[i] = new FilterMatrix(FILTER_PRE[i * 3], FILTER_PRE[i * 3 + 1], FILTER_PRE[i * 3 + 2]);
        }
        midFilters = new FilterMatrix[FILTER_MID.length / 3];
        for (i = 0; i < FILTER_MID.length / 3; ++i) {
            Filter.midFilters[i] = new FilterMatrix(FILTER_MID[i * 3], FILTER_MID[i * 3 + 1], FILTER_MID[i * 3 + 2]);
        }
        lineArtCleanerFilters = new FilterMatrix[FILTER_LINE_ART_CLEANER.length / 3];
        for (i = 0; i < FILTER_LINE_ART_CLEANER.length / 3; ++i) {
            Filter.lineArtCleanerFilters[i] = new FilterMatrix(FILTER_LINE_ART_CLEANER[i * 3], FILTER_LINE_ART_CLEANER[i * 3 + 1], FILTER_LINE_ART_CLEANER[i * 3 + 2]);
        }
        image2asciiSimpleEdgeFilters = new FilterMatrix[FILTER_IMAGE2ASCII_SIMPLE_EDGE.length / 3];
        for (i = 0; i < FILTER_IMAGE2ASCII_SIMPLE_EDGE.length / 3; ++i) {
            Filter.image2asciiSimpleEdgeFilters[i] = new FilterMatrix(FILTER_IMAGE2ASCII_SIMPLE_EDGE[i * 3], FILTER_IMAGE2ASCII_SIMPLE_EDGE[i * 3 + 1], FILTER_IMAGE2ASCII_SIMPLE_EDGE[i * 3 + 2]);
        }
    }

    private static void filter(CharacterPlate plate, FilterMatrix[] filters) {
        int x;
        int y;
        Ensure.ensureArgumentNotNull(plate);
        Ensure.ensureArgumentNotNull(filters);
        int height = plate.getHeight();
        int width = plate.getWidth();
        int[][] raster = new int[height][width];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (plate.get(x, y) == ' ') continue;
                for (int yy = y - 1; yy <= y + 1; ++yy) {
                    for (int xx = x - 1; xx <= x + 1; ++xx) {
                        if (yy < 0 || yy >= height || xx < 0 || xx >= width) continue;
                        int[] nArray = raster[yy];
                        int n = xx;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        for (y = 0; y < height; ++y) {
            block5: for (x = 0; x < width; ++x) {
                if (raster[y][x] == 0) continue;
                for (int f = 0; f < filters.length; ++f) {
                    if (!filters[f].fits(plate, width, height, x, y, raster[y][x])) continue;
                    filters[f].apply(plate, width, height, x, y);
                    continue block5;
                }
            }
        }
    }

    private static void filterQuick(CharacterPlate cp, FilterMatrix[] filters) {
        int h = cp.getHeight();
        int w = cp.getWidth();
        for (int y = 0; y < h; ++y) {
            block1: for (int x = 0; x < w; ++x) {
                char character = cp.get(x, y);
                if (character != '#') continue;
                for (int filterIndex = 0; filterIndex < filters.length; ++filterIndex) {
                    if (!filters[filterIndex].fits(cp, w, h, x, y, -1)) continue;
                    filters[filterIndex].apply(cp, w, h, x, y);
                    continue block1;
                }
            }
        }
    }

    private static void cleanUp(CharacterPlate cp) {
        GeneralAlgorithm.replace(cp, '#', ' ');
    }

    public static void filter(CharacterPlate characterPlate, FilterMode mode) {
        if (!initialized) {
            throw new IllegalStateException("Filter not initialized!");
        }
        int originalWidth = characterPlate.getWidth();
        int originalHeight = characterPlate.getHeight();
        Insets emptyInsets = characterPlate.getEmptyInsets();
        int originX = emptyInsets.left + 1;
        int originY = emptyInsets.top + 1;
        int newWidth = originalWidth + 2 - emptyInsets.left - emptyInsets.right;
        int newHeight = originalHeight + 2 - emptyInsets.top - emptyInsets.bottom;
        if (newWidth <= 0 || newHeight <= 0) {
            return;
        }
        CharacterPlate tp = new CharacterPlate(newWidth, newHeight);
        characterPlate.getCopy(emptyInsets.left, emptyInsets.top, newWidth - 1, newHeight - 1).pasteInto(tp, 1, 1);
        switch (mode) {
            case SOFT: {
                Filter.filterQuick(tp, preFilters);
                Filter.filterQuick(tp, midFilters);
                Filter.cleanUp(tp);
                Filter.filter(tp, postFilters);
                break;
            }
            case MID: {
                Filter.filterQuick(tp, preFilters);
                Filter.filterQuick(tp, midFilters);
                Filter.cleanUp(tp);
                break;
            }
            case LINE_ART_CLEANER: {
                Filter.filter(tp, lineArtCleanerFilters);
                break;
            }
            case IMAGE2ASCII_SIMPLE_EDGE: {
                Filter.filter(tp, image2asciiSimpleEdgeFilters);
            }
        }
        tp.pasteIntoForce(characterPlate, emptyInsets.left - 1, emptyInsets.top - 1);
    }

    static {
        initialized = false;
    }
}

