/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.gradient;

import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.disy.commons.core.io.IOUtilities;

public class AsciiGradientConfiguration
implements IJaveInitializable {
    private static boolean initialized = false;
    private static final String[] DEFAULT_GRADIENTS = new String[]{" .'~:;!>+=icjtJY56SXDQKHNWM", " .':!+ijY6XbKHNM", " .:+j6bHM", " .:coCO8@", " .:oO8@", " .:oO8", " :+#"};
    private String[] gradients = DEFAULT_GRADIENTS;
    private static final AsciiGradientConfiguration instance = new AsciiGradientConfiguration();

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/gradients.txt");
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(configurationFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        int size = lines.size();
        if (size == 0) {
            throw new ConfigurationException(configurationFile, "The file seems to be empty.");
        }
        this.gradients = new String[size];
        for (int i = 0; i < size; ++i) {
            this.gradients[i] = (String)lines.get(i);
        }
        initialized = true;
    }

    private AsciiGradientConfiguration() {
    }

    public static final boolean isInitialized() {
        return initialized;
    }

    public static AsciiGradientConfiguration getInstance() {
        return instance;
    }

    public String[] getGradients() {
        return this.gradients;
    }
}

