/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.CharField;
import de.jave.gui.CharacterModel;
import de.jave.jave.AbstractPencilTool;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.MixCharactersPanel;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.model.listener.IChangeListener;

public class BrushTool
extends AbstractPencilTool {
    private JPanel brushPanel;
    private CharacterModel[] brushCharacterModels;
    private int brushHeight = 4;
    private int brushWidth = 4;
    private static final char[][] DEFAULT_BRUSH = new char[][]{{' ', '_', '_', ' '}, {'d', '8', '8', 'b'}, {'Y', '8', '8', 'P'}, {' ', ' ', ' ', ' '}};

    public BrushTool(JaveMainPanel plate, JavEApplication asciiPainter) {
        super(plate, asciiPainter);
    }

    @Override
    public String getName() {
        return "Brush";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_BRUSH_ICON;
    }

    @Override
    protected String getUndoRedoActionName() {
        return "brush";
    }

    @Override
    public JComponent createOptionsComponent() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        this.brushPanel = new JPanel();
        this.setBrush(DEFAULT_BRUSH);
        optionsPanel.add((Component)this.brushPanel, "Center");
        optionsPanel.add((Component)new MixCharactersPanel(this.getMixCharactersModel()).getContent(), "South");
        return optionsPanel;
    }

    @Override
    protected void paint(int x0, int y0) {
        char[][] brush = this.getBrush();
        int h = brush.length;
        int w = brush[0].length;
        int cx = (w - 1) / 2;
        int cy = (h - 1) / 2;
        if (this.isMouseRightButton()) {
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    char pixel = brush[y][x];
                    if (pixel == ' ') continue;
                    this.getPlate().setCharForce(x0 - cx + x, y0 - cy + y, ' ');
                }
            }
        } else {
            this.setMixMode(this.isMix());
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    char pixel = brush[y][x];
                    if (pixel == '\u00a0') {
                        this.getPlate().setCharForce(x0 - cx + x, y0 - cy + y, ' ');
                        continue;
                    }
                    if (pixel == ' ') continue;
                    this.getPlate().setChar(x0 - cx + x, y0 - cy + y, pixel);
                }
            }
        }
        this.getPlate().repaint(50L);
    }

    public void setBrush(CharacterPlate cp) {
        this.setBrush(cp.getContent());
    }

    public void setBrush(char[][] brush) {
        this.brushHeight = brush.length;
        this.brushWidth = brush[0].length;
        this.brushPanel.removeAll();
        this.brushPanel.setLayout(new GridLayout(0, this.brushWidth, 0, 0));
        this.brushCharacterModels = new CharacterModel[this.brushWidth * this.brushHeight];
        IChangeListener changeListener = new IChangeListener(){

            @Override
            public void stateChanged() {
                BrushTool.this.repaintCursor();
            }
        };
        CharField[] brushCharFields = new CharField[this.brushWidth * this.brushHeight];
        int index = 0;
        for (int y = 0; y < this.brushHeight; ++y) {
            for (int x = 0; x < this.brushWidth; ++x) {
                this.brushCharacterModels[index] = new CharacterModel(brush[y][x]);
                brushCharFields[index] = new CharField(this.brushCharacterModels[index]);
                this.brushCharacterModels[index].addChangeListener(changeListener);
                brushCharFields[index].setFont(JaveGlobalRessources.FONT_DEFAULT);
                this.brushPanel.add(brushCharFields[index++]);
            }
        }
        this.brushPanel.validate();
        this.packOptionsDialog();
        this.repaintCursor();
    }

    @Override
    public char[][] getBrush() {
        char[][] result = new char[this.brushHeight][this.brushWidth];
        int index = 0;
        for (int y = 0; y < this.brushHeight; ++y) {
            for (int x = 0; x < this.brushWidth; ++x) {
                result[y][x] = this.brushCharacterModels[index++].getCharacter();
            }
        }
        return result;
    }
}

