/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmEdgeTracingOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmEdgeTracingOptionsPanel;
import de.jave.jave.filter.Filter;
import de.jave.jave.filter.FilterMode;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public class Image2AsciiAlgorithmEdgeTracing
extends Image2AsciiAlgorithm {
    private final AlgorithmEdgeTracingOptionsModel optionsModel = new AlgorithmEdgeTracingOptionsModel();

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getName() {
        return "Edge Tracing";
    }

    @Override
    public IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmEdgeTracingOptionsPanel(this.optionsModel);
    }

    @Override
    public IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    @Override
    public void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    @Override
    public void setSpecialChars(String specialCharacters) {
    }

    @Override
    public int getVerticalPixelsPerChar() {
        return 1;
    }

    @Override
    public int getHorizontalPixelsPerChar() {
        return 1;
    }

    @Override
    public boolean isMonochromeImageRequired() {
        return true;
    }

    @Override
    public CharacterPlate convert(IValueRaster raster, IProgressMonitor progressMonitor, ICancelable cancelable) throws InterruptedException {
        int x;
        int y;
        int width = raster.getWidth();
        int height = raster.getHeight() + 1;
        int fillChar = 58;
        CharacterPlate result = new CharacterPlate(width, height);
        progressMonitor.beginTask("Converting...", height);
        for (y = -1; y < height - 1; ++y) {
            for (x = 0; x < width; ++x) {
                if (Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y)) {
                    if (!(Image2AsciiAlgorithmEdgeTracing.isSet(raster, x - 1, y) || Image2AsciiAlgorithmEdgeTracing.isSet(raster, x + 1, y) || Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y - 1) || Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y + 1))) {
                        result.set(x, y + 1, 'O');
                        continue;
                    }
                    if (!Image2AsciiAlgorithmEdgeTracing.isSet(raster, x - 1, y) && !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y - 1)) {
                        result.set(x, y + 1, '/');
                        continue;
                    }
                    if (!Image2AsciiAlgorithmEdgeTracing.isSet(raster, x + 1, y) && !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y - 1)) {
                        result.set(x, y + 1, '\\');
                        continue;
                    }
                    if (!Image2AsciiAlgorithmEdgeTracing.isSet(raster, x - 1, y) && !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y + 1)) {
                        result.set(x, y + 1, '\\');
                        continue;
                    }
                    if (!Image2AsciiAlgorithmEdgeTracing.isSet(raster, x + 1, y) && !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y + 1)) {
                        result.set(x, y + 1, '/');
                        continue;
                    }
                    if (!Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y + 1)) {
                        result.set(x, y + 1, '_');
                        continue;
                    }
                    if (Image2AsciiAlgorithmEdgeTracing.isSet(raster, x - 1, y) && Image2AsciiAlgorithmEdgeTracing.isSet(raster, x + 1, y)) continue;
                    result.set(x, y + 1, '|');
                    continue;
                }
                if (!Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y + 1) || !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x - 1, y + 1) || !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x + 1, y + 1)) continue;
                result.set(x, y + 1, '_');
            }
            progressMonitor.worked(1);
        }
        if (this.optionsModel.isSmoothing()) {
            Filter.init();
            Filter.filter(result, FilterMode.IMAGE2ASCII_SIMPLE_EDGE);
        }
        if (this.optionsModel.isFill()) {
            for (y = -1; y < height - 1; ++y) {
                for (x = 0; x < width; ++x) {
                    if (result.get(x, y + 1) != ' ' || !Image2AsciiAlgorithmEdgeTracing.isSet(raster, x, y)) continue;
                    result.set(x, y + 1, ':');
                }
            }
        }
        return result;
    }

    private static boolean isSet(IValueRaster pixels, int x, int y) {
        if (y < 0 || x < 0 || y >= pixels.getHeight() || x >= pixels.getWidth()) {
            return false;
        }
        return pixels.getValueAt(x, y) == 0;
    }
}

