/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.dialog.disposeanimation;

import de.jave.gui.dialog.disposeanimation.IDialogDisposeContext;
import de.jave.gui.dialog.disposeanimation.RectangleGlassPane;
import de.jave.gui.dialog.disposeanimation.RectangleInterpolator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.listener.IChangeListener;

public class DialogDisposeRectangleAnimator {
    private static final int MILLISECONDS_FOR_ANIMATION = 400;

    public static void attachTo(final BooleanModel dialogVisibilityModel, final IDialogDisposeContext context) {
        dialogVisibilityModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                if (dialogVisibilityModel.getValue()) {
                    return;
                }
                Rectangle dialogArea = context.getDialogAreaOnScreen();
                if (dialogArea == null) {
                    return;
                }
                Rectangle targetRectangle = context.getTargetAreaOnScreen();
                if (targetRectangle == null) {
                    return;
                }
                JFrame parentFrame = context.getParentFrame();
                if (parentFrame == null) {
                    return;
                }
                Component previousGlassPane = parentFrame.getGlassPane();
                RectangleGlassPane glassPane = new RectangleGlassPane();
                parentFrame.setGlassPane(glassPane);
                glassPane.setVisible(true);
                Point translate = glassPane.getLocationOnScreen();
                Rectangle startRectangle = new Rectangle(dialogArea);
                Rectangle actualTargetRectangle = new Rectangle(targetRectangle);
                startRectangle.translate(-translate.x, -translate.y);
                actualTargetRectangle.translate(-translate.x, -translate.y);
                DialogDisposeRectangleAnimator.startAnimationThread(parentFrame, previousGlassPane, glassPane, startRectangle, actualTargetRectangle);
            }
        });
    }

    private static void startAnimationThread(final JFrame parentFrame, final Component previousGlassPane, final RectangleGlassPane glassPane, final Rectangle startRectangle, final Rectangle actualTargetRectangle) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                long millis;
                RectangleInterpolator rectangleInterpolator = new RectangleInterpolator();
                long startTime = System.currentTimeMillis();
                while ((millis = System.currentTimeMillis() - startTime) <= 400L) {
                    double t = (double)millis / 400.0;
                    Rectangle interpolated = rectangleInterpolator.interpolate(startRectangle, actualTargetRectangle, t);
                    glassPane.setRectangle(interpolated);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        parentFrame.setGlassPane(previousGlassPane);
                    }
                });
            }
        }, "DialogDisposeRectangleAnimator");
        thread.start();
    }
}

