/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.button;

import de.jave.gui.GuiTools;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.swing.action.SmartToggleAction;

public class ModernToggleButtonFactory {
    public static JToggleButton createModernToggleButton() {
        return ModernToggleButtonFactory.createToggleButton(null);
    }

    private static JToggleButton createToggleButton(Action action) {
        JToggleButton button = new JToggleButton(action){

            @Override
            public void setUI(ButtonUI ui) {
                super.setUI(new BasicToggleButtonUI(){

                    @Override
                    public void paint(Graphics g, JComponent c) {
                        super.paint(g, c);
                        AbstractButton b = (AbstractButton)c;
                        if (b.getModel().isSelected() || b.getModel().isPressed() && b.getModel().isArmed()) {
                            Dimension size = b.getSize();
                            GuiTools.drawSmall3dRectangleDown(g, 0, 0, size.width, size.height);
                        } else if (b.isRolloverEnabled() && b.getModel().isRollover()) {
                            Dimension size = b.getSize();
                            GuiTools.drawSmall3dRectangleUp(g, 0, 0, size.width, size.height);
                        }
                    }
                });
            }
        };
        button.setPreferredSize(new Dimension(24, 23));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        return button;
    }

    public static JToggleButton createModernToggleButton(final SmartToggleAction action) {
        final JToggleButton button = ModernToggleButtonFactory.createToggleButton(action);
        button.setSelected(action.getSelectionModel().getValue());
        action.getSelectionModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                button.setSelected(action.getSelectionModel().getValue());
            }
        });
        return button;
    }
}

