/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

public class FigFileName {
    public static final String FIGLET_FONT_FILE_EXTENSION = ".flf";
    public static final String FIGLET_CONTROL_FILE_EXTENSION = ".flc";
    private String name;

    public FigFileName(String name) {
        if (name.indexOf(47) != -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        if (!name.endsWith(FIGLET_FONT_FILE_EXTENSION) && !name.endsWith(FIGLET_CONTROL_FILE_EXTENSION)) {
            name = name + FIGLET_FONT_FILE_EXTENSION;
        }
        this.name = name;
    }

    public boolean isFont() {
        return this.name.endsWith(FIGLET_FONT_FILE_EXTENSION);
    }

    public boolean isControlFile() {
        return this.name.endsWith(FIGLET_CONTROL_FILE_EXTENSION);
    }

    public String getName() {
        return this.name;
    }

    public String getPrintName() {
        return this.getName().substring(0, this.getName().length() - this.getExtension().length());
    }

    private String getExtension() {
        return this.isControlFile() ? FIGLET_CONTROL_FILE_EXTENSION : FIGLET_FONT_FILE_EXTENSION;
    }

    public String toString() {
        return this.getName();
    }
}

