/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

import de.jave.figlet.engine.primitives.FigCharacter;
import de.jave.figlet.engine.primitives.FigFontOptions;
import de.jave.figlet.engine.primitives.FigLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FigFont {
    public static final char HARDBLANK = '\u007f';
    private final Map<Integer, FigCharacter> characterMapping = new HashMap<Integer, FigCharacter>();
    private final List<FigCharacter> characters = new ArrayList<FigCharacter>();
    private final String name;
    private final FigFontOptions options;

    public FigFont(String name, FigFontOptions options) {
        this.options = options;
        this.name = name;
    }

    public void addCharacter(FigCharacter character) {
        this.characters.add(character);
        this.characterMapping.put(new Integer(character.getCharacterCode()), character);
    }

    public String getComments() {
        return this.options.getComments();
    }

    public int getHeight() {
        return this.options.getHeight();
    }

    public int getMaxlength() {
        return this.options.getMaxLength();
    }

    public int getUnderLength() {
        return this.options.getHeight() - this.options.getBaseline();
    }

    public FigCharacter getFIGCharacter(int ch) {
        if (this.characterMapping.containsKey(new Integer(ch))) {
            return this.characterMapping.get(new Integer(ch));
        }
        return this.characterMapping.get(new Integer(32));
    }

    public String getInfo() {
        StringBuffer s = new StringBuffer();
        s.append("\nHeight:   " + this.options.getHeight());
        s.append("\nBaseline: " + this.options.getBaseline());
        s.append("\nMaximum length:  " + this.options.getMaxLength());
        s.append("\nCodetag count:   " + this.options.getCodetagCount());
        return s.toString();
    }

    public String[] getInfos() {
        return new String[]{"Height:", String.valueOf(this.options.getHeight()), "Baseline:", String.valueOf(this.options.getBaseline()), "Maximum length:", String.valueOf(this.options.getMaxLength()), "Codetag count:", String.valueOf(this.options.getCodetagCount())};
    }

    public void dump() {
        System.out.println("FIGLet Font >" + this.name + "<");
        System.out.println(" height     = " + this.options.getHeight());
        System.out.println(" baseline   = " + this.options.getBaseline());
        System.out.println(" max_length = " + this.options.getMaxLength());
        System.out.println(" comment_lines  = " + this.options.getCommentLineCount());
        System.out.println(" layout    = " + this.options.getLayout());
        System.out.println(" codetagCount   = " + this.options.getCodetagCount());
        System.out.println(" hardblank  = " + this.options.getHardblank());
        for (int i = 0; i < this.characters.size(); ++i) {
            this.characters.get(i).dump();
        }
    }

    public FigLayout getLayout() {
        return this.options.getLayout();
    }

    public String getName() {
        return this.name;
    }

    public FigFontOptions getOptions() {
        return this.options;
    }
}

