/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard.vrml;

import de.grogra.billboard.BBResources;
import de.grogra.billboard.BasicBillboarder;
import de.grogra.billboard.vrml.VRMLBuilder;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.MimeType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class VRMLDynamicBuilder
extends BasicBillboarder
implements VRMLBuilder {
    protected String vrmlFileName = "bb";
    private String vrmlTempl = "";
    protected File vrmlDest;

    public VRMLDynamicBuilder(File file, MimeType mimeType) {
        super(file, mimeType);
        this.vrmlDest = new File(file.getPath() + File.separator + this.vrmlFileName + ".wrl");
        this.imageFolder = "";
        this.vrmlTempl = BBResources.getVRMLTempl(this.getClass(), "vrmldyntempl.txt");
    }

    public VRMLDynamicBuilder(File file, MimeType mimeType, String string) throws IOException {
        super(file, mimeType);
        this.vrmlDest = new File(file.getPath() + File.separator + this.vrmlFileName + ".wrl");
        file = new File(file.getPath() + File.separator + string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        this.imageFolder = string;
        this.vrmlTempl = BBResources.getVRMLTempl(this.getClass(), "vrmldyntempl.txt");
    }

    public void writeVRML(int n, int n2) {
        String string = this.vrmlTempl;
        String string2 = "";
        int n3 = 0;
        double d = (double)n2 / (double)n;
        while (n3 < this.sides) {
            string2 = string2 + "PngFrame { url \"" + this.getBBName(n3++) + "\" } " + System.getProperty("line.separator") + "\t\t";
        }
        string = string.replaceAll("::REL_HEIGHT::", Double.toString(d));
        string = string.replaceAll("::PNG_PROTO_CALL::", string2);
        string = string.replaceAll("::BILL_NUM::", Integer.toString(this.sides));
        try {
            FileWriter fileWriter = new FileWriter(this.vrmlDest);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Workbench.current().logGUIInfo("Error: " + iOException.getMessage());
        }
    }

    protected void finalAction() {
        this.writeVRML(this.imgWidth, this.imgHeight);
    }
}

