/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.greenlab;

import de.grogra.greenlab.GreenLabGUI;
import de.grogra.greenlab.ui.elements.GreenLabJLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class GreenLabTooltipPanel
extends JPanel {
    private static final long serialVersionUID = -207343200110708L;
    private JTextArea descriptionArea = new JTextArea();
    private JTextArea typeArea = new JTextArea();
    private JTextArea rangeArea = new JTextArea();
    private JTextArea unitArea = new JTextArea();
    private static final Font KEY_WORT_FONT = new Font("LucidaSans", 0, 12);
    private static final Color BACKGROUND = UIManager.getColor("Button.background");

    GreenLabTooltipPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        GreenLabJLabel greenLabJLabel = new GreenLabJLabel("tooltip.type.Name");
        greenLabJLabel.setFont(KEY_WORT_FONT);
        jPanel.add(greenLabJLabel);
        GreenLabJLabel greenLabJLabel2 = new GreenLabJLabel("tooltip.range.Name");
        greenLabJLabel2.setFont(KEY_WORT_FONT);
        jPanel.add(greenLabJLabel2);
        GreenLabJLabel greenLabJLabel3 = new GreenLabJLabel("tooltip.unit.Name");
        greenLabJLabel3.setFont(KEY_WORT_FONT);
        jPanel.add(greenLabJLabel3);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.add(new GreenLabJLabel(" : "));
        jPanel2.add(new GreenLabJLabel(" : "));
        jPanel2.add(new GreenLabJLabel(" : "));
        this.typeArea.setEditable(false);
        this.rangeArea.setEditable(false);
        this.unitArea.setEditable(false);
        this.typeArea.setBackground(BACKGROUND);
        this.rangeArea.setBackground(BACKGROUND);
        this.unitArea.setBackground(BACKGROUND);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        this.typeArea.setColumns(25);
        this.rangeArea.setColumns(25);
        this.unitArea.setColumns(25);
        jPanel3.add(this.typeArea);
        jPanel3.add(this.rangeArea);
        jPanel3.add(this.unitArea);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)new JSeparator(1), "West");
        jPanel5.add((Component)jPanel4, "Center");
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setBackground(BACKGROUND);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)this.descriptionArea, "Center");
        jPanel6.add((Component)jPanel5, "East");
        jPanel6.setBorder(new TitledBorder(" " + GreenLabGUI.getString("tooltip.Name")));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel6, "Center");
    }

    public void updateValue(String string) {
        String string2 = string.replaceAll("\\s", "").replaceAll("[\\(\\)]", "_");
        if (!GreenLabGUI.getString(string2 + ".description").equals(string2 + ".description")) {
            this.descriptionArea.setText(GreenLabGUI.getString(string2 + ".description"));
            this.typeArea.setText(GreenLabGUI.getString(GreenLabGUI.getString(string2 + ".type") + ".type.Name"));
            if (!GreenLabGUI.getString(string2 + ".range.min").equals(string2 + ".range.min")) {
                String string3 = GreenLabGUI.getString(string2 + ".range.min");
                String string4 = GreenLabGUI.getString(string2 + ".range.max");
                if (string3.equals("MIN")) {
                    string3 = "-\u221e";
                }
                if (string4.equals("MAX")) {
                    string4 = "+\u221e";
                }
                this.rangeArea.setText("[" + string3 + ", " + string4 + "]");
            } else {
                this.rangeArea.setText("");
            }
            this.unitArea.setText(GreenLabGUI.getString(string2 + ".unit"));
        }
    }
}

