/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.spectral;

import de.grogra.imp3d.spectral.SpectralCurve;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;

public class IrregularSpectralCurve
extends SpectralCurve {
    private float[] wavelengths;
    private float[] amplitudes;
    public static final Type $TYPE = new Type(IrregularSpectralCurve.class);
    public static final SCOType.Field wavelengths$FIELD = Type._addManagedField($TYPE, "wavelengths", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(float[].class), null, 0);
    public static final SCOType.Field amplitudes$FIELD = Type._addManagedField($TYPE, "amplitudes", 0x200002, (de.grogra.reflect.Type)ClassAdapter.wrap(float[].class), null, 1);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public IrregularSpectralCurve() {
    }

    public IrregularSpectralCurve(float[] fArray, float[] fArray2) {
        this.wavelengths = fArray;
        this.amplitudes = fArray2;
        if (fArray.length != fArray2.length) {
            throw new RuntimeException(String.format("Error creating irregular spectral curve: %d wavelengths and %d amplitudes", fArray.length, fArray2.length));
        }
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i - 1] >= fArray[i])) continue;
            throw new RuntimeException(String.format("Error creating irregular spectral curve: values are not sorted - error at index %d", i));
        }
    }

    public float sample(float f) {
        if (this.wavelengths.length == 0) {
            return 0.0f;
        }
        if (this.wavelengths.length == 1 || f <= this.wavelengths[0]) {
            return this.amplitudes[0];
        }
        if (f >= this.wavelengths[this.wavelengths.length - 1]) {
            return this.amplitudes[this.wavelengths.length - 1];
        }
        for (int i = 1; i < this.wavelengths.length; ++i) {
            if (!(f < this.wavelengths[i])) continue;
            float f2 = (f - this.wavelengths[i - 1]) / (this.wavelengths[i] - this.wavelengths[i - 1]);
            return (1.0f - f2) * this.amplitudes[i - 1] + f2 * this.amplitudes[i];
        }
        return this.amplitudes[this.wavelengths.length - 1];
    }

    static /* synthetic */ float[] access$002(IrregularSpectralCurve irregularSpectralCurve, float[] fArray) {
        irregularSpectralCurve.wavelengths = fArray;
        return fArray;
    }

    static /* synthetic */ float[] access$102(IrregularSpectralCurve irregularSpectralCurve, float[] fArray) {
        irregularSpectralCurve.amplitudes = fArray;
        return fArray;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 2;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(IrregularSpectralCurve irregularSpectralCurve, SCOType sCOType) {
            super((Object)irregularSpectralCurve, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    IrregularSpectralCurve.access$002((IrregularSpectralCurve)((Object)object), (float[])object2);
                    return;
                }
                case 1: {
                    IrregularSpectralCurve.access$102((IrregularSpectralCurve)((Object)object), (float[])object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((IrregularSpectralCurve)((Object)object)).wavelengths;
                }
                case 1: {
                    return ((IrregularSpectralCurve)((Object)object)).amplitudes;
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new IrregularSpectralCurve();
        }
    }
}

